
<?php $__env->startSection('title', 'News'); ?>
<?php $__env->startSection('content'); ?>
<section class="p-0">
  <div class="row content">
    <div class="video-image">
      <img class="img-fluid w-100" src="<?php echo e(asset('storage/location/news/'.$news->banner)); ?>" />
    </div>
  </div>

  <div class="container" data-aos="fade-up">
    <div class="row">
      <div class="col-md-12">
        <div class="col-md-7 mx-auto">
          <div class="container mt-4" data-aos="fade-up">
            <div class="row">
              <div class="col-md-12">
                <div class="mt-2 mb-2 d-block text-success"><?php echo e($news->tags); ?></div>
                <div class="heading4 dark mb-2"><?php echo e(ucfirst($news->name)); ?></div>
                <div class="d-inline">
                <?php if($news->createdBy->profile_pic): ?>
                <img src="<?php echo e(asset('storage/profile-pic/'.$news->createdBy->profile_pic)); ?>" alt="Profile" class="rounded-circle height35">
                <?php else: ?>
                <img src="<?php echo e(asset('images/user-img.png')); ?>" alt="Profile" class="rounded-circle height35">
                <?php endif; ?>
                </div>
                <div class="d-inline">
                  <span class="font13px" style="font-weight:100;"><?php echo e(ucfirst($news->createdBy->fname)); ?> <?php echo e(ucfirst($news->createdBy->lname)); ?></span>
                  <div class="font12px" style="margin-top:-15px;margin-left:40px;"><?php echo e(date('d l Y',strtotime($news->created_at))); ?></div>
                </div>
              </div>
              <div class="col-md-12 mt-4">
                <div class="heading3 dark"><?php echo e($news->heading_intro); ?></div>
                <div class="mb-2"><?php echo html_entity_decode($news->para_intro); ?></div>
              </div>
              <div class="col-md-12 mt-4">
                <div class="heading3 dark"><?php echo e($news->heading_elaboration); ?></div>
                <div class="mb-2"><?php echo html_entity_decode($news->para_elaboration); ?></div>
              </div>
              <div class="col-md-12 mt-4">
                <?php if($news->conclusion_picture): ?>
                <img src="<?php echo e(asset('storage/location/news/'.$news->conclusion_picture)); ?>" alt="Profile" class="img-thumbnail p-0">
                <?php endif; ?>
                <?php if($news->heading_conclusion): ?>
                <div class="mt-3 keyinfobg p-3">
                  <div class="heading3 dark"><?php echo e($news->heading_conclusion); ?></div>
                  <div class="mb-2"><?php echo html_entity_decode($news->para_conclusion); ?></div>
                </div>
                <?php endif; ?>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<section class="p-0">
<div class="container" data-aos="fade-up">
  <?php echo $__env->make('frontend.news.related-news', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>
</section>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/nomadic/resources/views/frontend/news/view-news.blade.php ENDPATH**/ ?>