
<?php $__env->startSection('title', 'Nomadic-Event'); ?>
<?php $__env->startSection('content'); ?>
<section class="section profile position-relative">
  <div class="col-xl-12">
    <!-- Bordered Tabs -->
    <input type="hidden" id="locationId" name="locationId" value="<?php echo e($locationId); ?>" readonly>
    <?php if($event): ?>
        <?php if(isset($event->thumbnail) && $event->thumbnail!=""): ?>
        <img src="<?php echo e(asset('storage/location/events/' . $event->thumbnail)); ?>" alt="Event Image" class="img-fluid w-100 " style="border-radius:5px;">
        <?php endif; ?>
        <?php if(session('success')): ?>
        <div class="alert alert-success">
            <?php echo e(session('success')); ?>

        </div>
        <?php endif; ?>
        <div class="container mt-4 center-content" style="padding-left:180px;">
            <h3 ><?php echo e($event->formattedDate()); ?></h3>
            <!-- Name of Event Creator -->
            <h1><?php echo e(ucfirst($event->event_title)); ?></h1>
            <h2><?php echo e($event->createdBy->fname.' '.$event->createdBy->lname); ?></h2>
            <!-- Edit and Share Buttons with Icons -->
            <div class="d-flex mb-3">
                <?php if($layout=='sidebar'): ?>
                <a class="btn btn-primary me-1" href="<?php echo e(url('backend/events/'.$locationId.'/'.$event->event_id)); ?>" style="display:inline;" ><i class="bi bi-pencil-square"></i></a>
                <?php else: ?>
                <button type="button" class="btn btn-primary me-1" <?php if(Auth::guest()): ?> disabled <?php elseif(isset($event->interested[0]->user_id)): ?> disabled <?php else: ?> onclick="event_action(this,<?php echo e($event->event_id); ?>,'interested')" <?php endif; ?>>Interested</button>
                <button type="button" class="btn btn-primary me-1" <?php if(Auth::guest()): ?> disabled <?php elseif(isset($event->going[0]->user_id)): ?> disabled <?php else: ?> onclick="event_action(this,<?php echo e($event->event_id); ?>,'going')" <?php endif; ?>>Going</button>
                <?php endif; ?>
                <button type="button" onclick="share(<?php echo e($event->event_id); ?>)" class="btn btn-primary"><i class="bi bi-share-fill"></i></button>
            </div>
            <!-- User Icon and Responded Number -->
            <div class="d-flex align-items-center mt-3" style="padding-top:50px;">
                <i class="bi bi-person-fill"></i>
                <span class="ml-2" style="padding-left:15px;"><?php echo e($interestedCount + $goingCount); ?> User Responded</span> &nbsp;
                <?php if($layout=='sidebar'): ?>
                <a href="<?php echo e(url('backend/event-responded/'.$locationId.'/'.$event->event_id)); ?>" style="display:inline;" >view</a>
                <?php endif; ?>
            </div>
            <!-- Calendar Icon and Event Date Time -->
            <div class="d-flex align-items-center mt-3">
                <i class="bi bi-calendar"></i>
                <span class="ml-2" style="padding-left:15px;"><?php echo e($event->formattedDate()); ?></span>
            </div>
            
            <div class="d-flex align-items-center mt-3">
                <i class="bi bi-geo-alt-fill"></i>
                <?php if($event->event_type=='online'): ?>
                <span class="ml-2" style="padding-left:15px;">ONLINE</span>
                <?php elseif($event->event_type=='location' && $event->address): ?>
                <span class="ml-2" style="padding-left:15px;"><?php echo e($event->address); ?></span>
                <?php endif; ?>
            </div>
            
            <!-- Ticket Icon and Ticket Price with Link -->
            <div class="d-flex align-items-center mt-3">
            <i class="bi bi-ticket-perforated"></i>
                <span class="ml-2" style="padding-left:15px;"> $<?php echo e($event->ticket_price); ?> <a href="<?php echo e($event->ticket_url); ?>" target="_blank">Tickets</a></span>
            </div>
            <!-- Globe Icon and Event Type -->
            <div class="d-flex align-items-center mt-3">
                <i class="bi bi-globe"></i>
                <span class="ml-2" style="padding-left:15px;"><?php echo e($event->public_private); ?></span>
            </div>
            <!-- Event Description -->
            <div class="mt-3">
                <?php echo $event->description; ?>

            </div>
            <!-- Participant Heading -->
            <h5 class="mt-4">Participants</h5>
            <!-- Interested and Going Buttons -->
            
            <!-- Interested button form -->
            <button type="button" style="background-color:#ffffff; padding:30px; width:250px; color:blue;" class="btn btn-outline-primary"><span id="interested_count"><?php echo e($interestedCount); ?></span> Interested</button>

            <!-- Going button form -->
            <button type="button" style="background-color:#ffffff; padding:30px; width:250px; color:blue;" class="btn btn-outline-primary"><span id="going_count"><?php echo e($goingCount); ?></span> Going</button>

            <?php if($event->event_type=='location' && $event->address): ?>
            <h5 class="mt-4">Address</h5>
            <p><?php echo e($event->address); ?></p>
            <div class="row mt-5">
                <div class="col-md-12">
                    <div class="mapouter">
                        <div class="gmap_canvas">
                            <iframe class="gmap_iframe" width="100%" frameborder="0" scrolling="no" marginheight="0" marginwidth="0" src="https://maps.google.com/maps?width=1324&amp;height=400&amp;hl=en&amp;q=<?php echo e($event->address); ?>&amp;t=&amp;z=14&amp;ie=UTF8&amp;iwloc=B&amp;output=embed"></iframe>
                            <a href="https://connectionsgame.org/">Connections Unlimited</a>
                        </div><style>.mapouter{position:relative;text-align:right;width:100%;height:400px;}.gmap_canvas {overflow:hidden;background:none!important;width:100%;height:400px;}.gmap_iframe {height:400px!important;}</style>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>
    <?php else: ?>
        <p>No event found.</p>
    <?php endif; ?>  
  </div>
</section>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.'.$layout, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/nomadic/resources/views/managing/event-detail.blade.php ENDPATH**/ ?>