
<?php $__env->startSection('title', 'Nomadic-Login'); ?>
<?php $__env->startSection('content'); ?>
<div class="banner">
    <div class="img-text img-margin"><?php echo e(__('Join global creatives')); ?></div>
    <img class="img-fluid w-100" src="<?php echo e(asset('images/banner1.png')); ?>">
</div>

<div class="container" data-aos="fade-up">
    <h2 class="mt-4"><?php echo e(__('Login')); ?></h2>
    <div class="row mb-5 d-block" align="center">
        <div class="col-md-4">
            <?php if(session('error')): ?>
            <div class="alert alert-danger"><?php echo e(session('error')); ?></div>
            <?php endif; ?>
            <?php if(session('success')): ?>
            <div class="alert alert-success"><?php echo e(session('success')); ?></div>
            <?php endif; ?>
            <form id="loginForm" class="w-100">
                <?php echo csrf_field(); ?>
                <div class="form-container">
                    <div class="form-group mb-2">
                        <input type="text" id="mobile_number" name="mobile_number" class="form-control" placeholder="Phone Number/Email" />
                    </div>
                    <div class="form-group mb-3">
                        <input type="password" id="password" name="password" class="form-control" placeholder="Password" />
                    </div>
                    <div class="form-group mb-3" align="left">
                        <input id="checkbox-20" name="remember_token" class="checkbox-custom" value="1" type="checkbox" checked>
                        <label for="checkbox-20" class="checkbox-custom-label">Keep me logged in</label> 
                    </div>

                    <a class="float-start" href="<?php echo e(url('login')); ?>"><?php echo e(__('Login with phone')); ?></a>
                    <a class="float-end" href="<?php echo e(url('reset-password')); ?>"><?php echo e(__('Forgot password?')); ?></a>

                    <div class="btnconter clearfix mt-5 mb-4">
                        <button class="btn" type="button" id="btn_login"><?php echo e(__('Login')); ?>

                            <div class="spinner-border text-primary spinner" role="status" style="display:none;vertical-align:text-top;"><span class="visually-hidden"><?php echo e(__('Loading')); ?>...</span></div>
                        </button>
                    </div>
                    <span><?php echo e(__("Don’t have an account?")); ?></span> <a href="<?php echo e(url('signup')); ?>"><?php echo e(__('Sign up')); ?></a>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer_scripts'); ?>
<script>
    $(document).ready(function () {
        $('#btn_login').click(function(){
            if($('#loginForm').valid()){
                $('#btn_login .spinner').show();
                $.ajax({
                    type: 'POST',
                    dataType: 'json',
                    data: $('#loginForm').serialize(),
                    url: APP_URL+"/login-save",
                    success: function(res) {
                        $('#btn_login .spinner').hide();
                        if(res.status){
                            window.location.href = APP_URL+'/my-profile';
                        }
                    },
                    error: function(res) {                    
                        $('#btn_login .spinner').hide();
                        ajax_error(res);
                    }
                });
            }
        });

        $('#loginForm').validate({
            rules: {
                mobile_number: {
                    required: true,
                },
                password: {
                    required: true
                },
            },
            errorElement: 'span',
            errorPlacement: function (error, element) {
                // error.addClass('invalid-feedback float-start');
                // element.closest('.form-group').append(error);
            },
            highlight: function (element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function (element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            }
        });  

    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/nomadic/resources/views/auth/login.blade.php ENDPATH**/ ?>