
<?php $__env->startSection('title', 'Nomadic-Reset Password'); ?>
<?php $__env->startSection('content'); ?>
<div class="container">
    <h2 style="margin-top:6rem;margin-bottom:2rem;"><?php echo e(__('Reset Password')); ?></h2>
    <div class="row mb-5 d-block">
        <div class="col-md-6">
            <?php if(session('error')): ?>
            <div class="alert alert-danger"><?php echo e(session('error')); ?></div>
            <?php endif; ?>
            <?php if(session('success')): ?>
            <div class="alert alert-success"><?php echo e(session('success')); ?></div>
            <?php endif; ?>
            <form id="resetForm">
                <?php echo csrf_field(); ?>
                <div class="mb-3">
                    <label for="emilAddress" class="form-label">E-mail Address</label>
                    <input name="email" type="email" class="form-control" id="emailInput" placeholder="Please enter your email">
                </div>
                <div class="mb-3">
                    <button class="btn btn-primary" id="btn_forgot_pass" type="button">Send Password Reset Link</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer_scripts'); ?>
<script>
$(document).ready(function () {
    $('#btn_forgot_pass').click(function(){
        $.ajax({
            type: 'POST',
            dataType: 'json',
            data: $('#resetForm').serialize(),
            url: APP_URL+"/reset-password",
            success: function(res) {
                if(res.status){
                    window.location.reload();
                }else{
                    $('.pagemsgcontent').html('<div class="alert alert-error">'+res.message+'</div>');
                    $('#alertMsg').modal('show');
                }
            },
            error: function(res) {                    
                ajax_error(res);
            }
        });
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/nomadic/resources/views/auth/reset-password.blade.php ENDPATH**/ ?>