<?php
namespace App;
//use AmrShawky\LaravelCurrency\Facade\Currency;
use Twilio\Rest\Client;
class Helpers
{    
    static function send_otp($receiverNumber){
        try{
            $account_sid = env("TWILIO_SID");
            $auth_token = env("TWILIO_TOKEN");
            $verify_sid = env("TWILIO_VERIFY_SID");
            $twilio = new Client($account_sid, $auth_token);
            $verification = $twilio->verify->v2->services($verify_sid)->verifications->create($receiverNumber, "sms");
            return response()->json([
                'status' => true,
                'message' => 'OTP has been sent to your mobile number.',
            ], 200);
        }catch(\Exception $e){
            return response()->json([
                'status' => false,
                'error' => $e->getMessage(),
            ], 422);
        }
    }

    static function verify_otp($receiverNumber,$otp){
        try{
            $account_sid = env("TWILIO_SID");
            $auth_token = env("TWILIO_TOKEN");
            $verify_sid = env("TWILIO_VERIFY_SID");
            $twilio = new Client($account_sid, $auth_token);
            
            $verification = $twilio->verify->v2->services($verify_sid)->verificationChecks
                        ->create(['code'=>$otp, 'to' => $receiverNumber]);
            
            if ($verification->valid) {
                return true;
            }else{
                return false;
            }
        }catch(\Exception $e){
            return false;
        }
    }

    static function clean_string($string){
        $string = str_replace(' ', '-', $string);
        return preg_replace('/[^A-Za-z0-9.\-]/', '', $string);
    }

    static function generatePassword($length = 8, $strength = 1) {
        $alphabet = "abcdefghijklmnopqrstuwxyzABCDEFGHIJKLMNOPQRSTUWXYZ0123456789@#$%";
        $pass = array(); //remember to declare $pass as an array
        $alphaLength = strlen($alphabet) - 1; //put the length -1 in cache
        for ($i = 0; $i < $length; $i++) {
            $n = rand(0, $alphaLength);
            $pass[] = $alphabet[$n];
        }
        return implode($pass);
    }

}