<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Location;
use App\Models\LandingPage;
use App\Models\Gallery;
use App\Models\Role;
use App\Helpers;
use Carbon\Carbon, Validator;

class ContentEditingController extends Controller
{
    private $paginate = 20;

    public function location_landing_page(Request $request, $locationId=null)
    {
        // if(auth()->user()->role!='super-admin'){
        //     abort(403);
        // }
        $resources = Role::where('type','resource')->where('status',1)->get();
        $location = Location::Select('id','location')->where('id',$locationId)->first();
        $page = LandingPage::with('location')->where('type','location')->where('location_id',$locationId)->first();
        return view("content-editing.location-landing-page")->with(['location'=>$location, 'page'=>$page, 'resources'=>$resources]);
    }

    public function fileupload(Request $request)
    {
        $validator = Validator::make($request->all(),[ 
            'type'  => 'required',
            'image_type' => 'required',
            'location_id' => 'required'
        ]);
        
        if($validator->fails()) {
            return response()->json([
                'status' => false,
                'error'=>$validator->errors()
            ], 422);
        }
        
        
        $lpid = $request->lpid;
        $image_type = $request->image_type;
        if(!$lpid && ($request->type=='location' ||$request->type=='studio')){
            $lp = new LandingPage;
            $lp->location_id = $request->location_id;
            $lp->type = $request->type;
            $lp->save();
            $lpid = $lp->id;
        }
        $lp = LandingPage::find($lpid);
        if($lp && $request->type=='location'){
            $storage_path = storage_path('app/public/location/');
            $image = $request->file('file');
            $imageName = time().'.'.$image->extension();
            $image->move($storage_path, $imageName);
            if($image_type=='banner'){
                $lp->banner_picture = $imageName;
                $lp->save();
                return response()->json(['status'=>true,'lpid'=>$lpid,'imgurl'=>'storage/location/'.$imageName]);
            }else if($image_type=='gallery'){
                $gallery = new Gallery;
                $gallery->type = $request->type;
                $gallery->ref_id = $lp->id;
                $gallery->image_url = $imageName;
                $gallery->save();
                return response()->json(['status'=>true,'lpid'=>$lpid,'imgurl'=>'storage/location/'.$imageName]);
            }
        }
        return response()->json(['status'=>false,'error'=>'Invalid form data received.']);
    }

    public function gallery_images(Request $request){
        $gallery = Gallery::where('type',$request->type)->where('ref_id',$request->refid)->get();
        $content = view('content-editing.gallery-images')->with(['gallery'=>$gallery])->render();
        return response()->json(['status'=>true,'content'=>$content]);
    }
    
}
