<?php

namespace App\Http\Controllers;
  
use Illuminate\Http\Request;
use App\Models\Plan;
use App\Models\User;
Use App\Models\Point;
use Stripe\PaymentIntent;
use Session, Log;
class PlanController extends Controller
{
    public function index(Request $request)
    {
        $plans = Plan::get();
        $guests = config('app.guests');
        return view("stripe.plans", compact("plans", "guests"));
    }  
  
    public function show(Plan $plan, Request $request)
    {
        Session::flash('success','Payment captured successfully');
        $intent = auth()->user()->createSetupIntent();
  
        return view("stripe.subscription", compact("plan", "intent"));
    }
    
    public function subscription(Request $request)
    {
        try{
            // if subscription exist then cancel
            if(auth()->user()->membership){
              auth()->user()->subscription(auth()->user()->membership)->cancel();
            }
            // create new subscription
            $plan = Plan::find($request->plan);
            $metadata = [
                'uuid' => auth()->user()->uuid,
            ];
            //dd($stripe_data);
            $subscription = $request->user()->newSubscription($plan->slug, $plan->stripe_plan)
                            ->create($request->token, ['email'=>auth()->user()->email],['metadata'=> $metadata]);
            
            User::where('id',auth()->user()->id)->update(['role'=>'member','membership'=>$plan->slug,'status'=>1]);
            Session::flash('success','Payment captured successfully');
            
            if($request->session()->has('signup_flow')){
              return  redirect()->route('additional-information');
            }else{
              return  redirect('account-setting');
            }
        }catch(\Stripe\Error\Card $e){
            $body = $e->getJsonBody();
            $err  = $body['error'];
            return redirect()->back()->with('error', $err);
        }
    }

    public function subscription_cancel(Request $request)
    {
      try{
        if(auth()->user()->membership){
          auth()->user()->subscription(auth()->user()->membership)->cancel();
          return response()->json([
            "status" => true,
            "message" => 'Subscription cancelled successfully.',
          ],200);
        }

        return response()->json([
          "status" => false,
          "error" => 'Invalid form data received.',
        ],422);

      } catch (\PDOException $pde) {
          return response()->json([
              "status" => false,
              "error" => $pde->getMessage(),
          ],422);
      } catch (\Exception $e) {
          return response()->json([
              "status" => false,
              "error" => $e->getMessage(),
          ],422);
      }
    }

    public function stripe_webhook(Request $request)
    {
        $payload = @file_get_contents('php://input');
        $event = null;
        Log::debug($payload);
        //echo '<pre>';print_r($payload);exit;
        // $payload = '{
        //   "id": "evt_3O159aBfA6yrUxU00cSOOQD4",
        //   "object": "event",
        //   "api_version": "2023-08-16",
        //   "created": 1697279588,
        //   "data": {
        //     "object": {
        //       "id": "ch_3O159aBfA6yrUxU00UtlC70Y",
        //       "object": "charge",
        //       "amount": 114900,
        //       "amount_captured": 114900,
        //       "amount_refunded": 0,
        //       "application": null,
        //       "application_fee": null,
        //       "application_fee_amount": null,
        //       "balance_transaction": "txn_3O159aBfA6yrUxU00VvMhLiL",
        //       "billing_details": {
        //         "address": {
        //           "city": null,
        //           "country": null,
        //           "line1": null,
        //           "line2": null,
        //           "postal_code": "20130",
        //           "state": null
        //         },
        //         "email": null,
        //         "name": "Sudhir",
        //         "phone": null
        //       },
        //       "calculated_statement_descriptor": "NOMADIC STUDIOS",
        //       "captured": true,
        //       "created": 1697279587,
        //       "currency": "usd",
        //       "customer": "cus_OoiacwFGDhaEma",
        //       "description": "Subscription creation",
        //       "destination": null,
        //       "dispute": null,
        //       "disputed": false,
        //       "failure_balance_transaction": null,
        //       "failure_code": null,
        //       "failure_message": null,
        //       "fraud_details": {
        //       },
        //       "invoice": "in_1O159aBfA6yrUxU0E4FST3B0",
        //       "livemode": false,
        //       "metadata": {
        //       },
        //       "on_behalf_of": null,
        //       "order": null,
        //       "outcome": {
        //         "network_status": "approved_by_network",
        //         "reason": null,
        //         "risk_level": "normal",
        //         "risk_score": 41,
        //         "seller_message": "Payment complete.",
        //         "type": "authorized"
        //       },
        //       "paid": true,
        //       "payment_intent": "pi_3O159aBfA6yrUxU009AiPvVA",
        //       "payment_method": "pm_1O159WBfA6yrUxU0ib3njfA9",
        //       "payment_method_details": {
        //         "card": {
        //           "amount_authorized": 114900,
        //           "brand": "visa",
        //           "checks": {
        //             "address_line1_check": null,
        //             "address_postal_code_check": "pass",
        //             "cvc_check": "pass"
        //           },
        //           "country": "US",
        //           "exp_month": 1,
        //           "exp_year": 2024,
        //           "extended_authorization": {
        //             "status": "disabled"
        //           },
        //           "fingerprint": "d8mN7ZcAWwMIUOY4",
        //           "funding": "credit",
        //           "incremental_authorization": {
        //             "status": "unavailable"
        //           },
        //           "installments": null,
        //           "last4": "4242",
        //           "mandate": null,
        //           "multicapture": {
        //             "status": "unavailable"
        //           },
        //           "network": "visa",
        //           "network_token": {
        //             "used": false
        //           },
        //           "overcapture": {
        //             "maximum_amount_capturable": 114900,
        //             "status": "unavailable"
        //           },
        //           "three_d_secure": null,
        //           "wallet": null
        //         },
        //         "type": "card"
        //       },
        //       "receipt_email": null,
        //       "receipt_number": null,
        //       "receipt_url": "https://pay.stripe.com/receipts/invoices/CAcaFwoVYWNjdF8xTnB5aFdCZkE2eXJVeFUwKOTcqakGMgbQfuEIc6M6LBZUaxtLFW6rI0h6JGeUlOhBd0NOVPSNuD1J4tjQccCjaTfjHTJsZ0PaiDyC?s=ap",
        //       "refunded": false,
        //       "review": null,
        //       "shipping": null,
        //       "source": null,
        //       "source_transfer": null,
        //       "statement_descriptor": null,
        //       "statement_descriptor_suffix": null,
        //       "status": "succeeded",
        //       "transfer_data": null,
        //       "transfer_group": null
        //     }
        //   },
        //   "livemode": false,
        //   "pending_webhooks": 1,
        //   "request": {
        //     "id": "req_TgpSrVvpuHkja0",
        //     "idempotency_key": "73507e70-0ce8-4438-90de-0aa84990747e"
        //   },
        //   "type": "charge.succeeded"
        // }';
        try {
            $event = \Stripe\Event::constructFrom(
                json_decode($payload, true)
            );
            //dd($event);
        } catch(\UnexpectedValueException $e) {
            // Invalid payload
            http_response_code(400);
            exit();
        }
        // Handle the event
        switch ($event->type) {
            case 'charge.succeeded':
                $charge = $event->data->object;
                $customer_id = $charge->customer;
                $invoice_id = $charge->invoice;
                $amount =  $charge->amount/100;
                $balance_point = 0;
                $plan = Plan::where('price',$amount)->first();
                $user = User::where('stripe_id',$customer_id)->first();
                $available_points = Point::select('balance')->where('receivedby_uuid',$user->uuid)->orderBy('id','desc')->first();
                if($available_points){
                  $balance_point = $available_points->balance + $plan->points;
                }else{
                  $balance_point = $plan->points;
                }
                // add into points table
                $point = new Point;
                $point->action = 'MEMBERSHIP_CREDIT';
                $point->receivedby_uuid = $user->uuid;
                $point->invoice_id = $invoice_id;
                $point->plan_id = $plan->id;
                $point->credit  = $plan->points;
                $point->balance = $balance_point;
                $point->save();
                dd('Done');
            case 'payment_intent.succeeded':
                $paymentIntent = $event->data->object; // contains a \Stripe\PaymentIntent
                // Then define and call a method to handle the successful payment intent.
                // handlePaymentIntentSucceeded($paymentIntent);
                break;
            case 'payment_method.attached':
                $paymentMethod = $event->data->object; // contains a \Stripe\PaymentMethod
                // Then define and call a method to handle the successful attachment of a PaymentMethod.
                // handlePaymentMethodAttached($paymentMethod);
                break;
            // ... handle other event types
            default:
                echo 'Received unknown event type ' . $event->type;
        }

        http_response_code(200);
    }
}
