$(document).ready(function () {
  $(document).on('click', '.notificationBell', function(){
    //$('.notifications').toggleClass('show');
  });
  $(document).on('click', '.profileIcon', function(){
    //$('.profile').toggleClass('show');
  });
  
  $(document).on('click', '.lang-box', function(){
    let lang_code = $(this).data('code');
    window.location.href = APP_URL+'/language/'+lang_code;
  });
  $(document).on('click', '.dlteprofilepic', function(){
    let uuid = $(this).data('uuid');
    deleteprofilepic(uuid);
  });
  $(document).on('click', '.cur-box', function(){
    let cur_code = $(this).data('code');
    $.ajax({
      type: 'POST',
      dataType: 'json',
      data: {_token:_token, currency:cur_code},
      url: APP_URL+"/set-currency",
      success: function(res) {
        if(res.status){
          window.location.reload();
        }
      },
      error: function(res) {
        ajax_error(res);
      }
    });
  });

  $(document).on('click', '.btnappaction', function(){
    let obj = $(this);
    obj.children('.spinner-border').show();
    let uuid = $('#user_uuid').val();
    let type = $(this).data('type');
    let action = $(this).data('action');
    $.ajax({
        type: 'POST',
        dataType: 'json',
        data: {_token:_token, uuid:uuid, action:action},
        url: APP_URL+"/user-app-action",
        success: function(res) {
          obj.children('.spinner-border').hide();
          if(res.status){
            if(type=='app'){
              if(action==2){
                $('.usraction, .'+uuid).html('<span class="txtApproved">Approved</span>');
              }else if(action==3){
                $('.usraction, .'+uuid).html('<span class="txtDenied">Denied</span>');
              }
            }else if(type=='muser'){
              if(action==2){
                $('.txt-status').html('<span class="txtApproved">Approved</span>');
              }else if(action==4){
                $('.txt-status').html('<span class="txtDenied">Suspended</span>');
              }else if(action==5){
                $('.txt-status').html('<span class="txtDenied">Blocked</span>');
              }
              obj.attr('disabled',true);
            }
          }
        },
        error: function(res) {
          obj.children('.spinner-border').hide();
          ajax_error(res);
        }
    });
  });

  $(document).on('click', '#btn_delete', function(){
    let obj = $(this);
    obj.attr('disabled',true);
    let did = obj.data('did');
    let type = obj.data('type');
    $.ajax({
        type: 'POST',
        dataType: 'json',
        data: {_token:_token, type:type, did:did},
        url: APP_URL+"/remove-action",
        success: function(res) {
          obj.attr('disabled',false);
          if(res.status){
            $('#alertMsg .pagemsgcontent').html('<div class="alert alert-success">'+res.message+'</div>');
            $('#alertMsg').modal('show');
            window.location.reload();
          }
        },
        error: function(res) {
          obj.attr('disabled',false);  
          ajax_error(res);
        }
    });
  });

  $(document).on('click','.searchicon',function(){
    let search = $('#search_field').val();
    let pathname = window.location.pathname;
    let patharray = pathname.split('/');
    let pathstring = patharray[patharray.length-1];
    if($.trim(search)!=""){
      window.location.href = APP_URL+'/'+pathstring+'?name='+search;
    }
  });

  $(document).on('change', 'select[name="location"]', function(){
    let location = $(this).val();
    if(location==""){
      $('select[name="role"]').html('').selectpicker('refresh');
    }
    let user_uuid = $('#user_uuid').val();
    $.ajax({
        type: 'POST',
        dataType: 'json',
        data: {_token:_token, uuid:user_uuid, location:location},
        url: APP_URL+"/userroles",
        success: function(res) {
          if(res.status){
            $('select[name="role"]').html(res.content).selectpicker('refresh');
          }
        },
        error: function(res) {
          ajax_error(res);
        }
    });
  });

  $(document).on('click', '#btn_addpoints', function(){
    let user_uuid = $('#user_uuid').val();
    if(user_uuid==""){
      $('#alertMsg .pagemsgcontent').html('<div class="alert alert-danger">Please select user to transfer points.</div>');
      $('#alertMsg').modal('show');
      return false;
    }
    let points = $('input[name="points"]').val();
    if(points==""){
      $('#alertMsg .pagemsgcontent').html('<div class="alert alert-danger">Points can not be blank.</div>');
      $('#alertMsg').modal('show');
      return false;
    }
    let obj = $(this);
    obj.attr('disabled',true);
    $.ajax({
        type: 'POST',
        dataType: 'json',
        data: {_token:_token, user_uuid:user_uuid, points:points},
        url: APP_URL+"/add-points",
        success: function(res) {
          obj.attr('disabled',false);
          if(res.status){
            $('#alertMsg .pagemsgcontent').html('<div class="alert alert-success">'+res.message+'</div>');
            $('#alertMsg').modal('show');
            if($('#page').length>0 && $('#page').html()=='account-setting'){
              window.location.reload();
            }
          }
        },
        error: function(res) {
          obj.attr('disabled',false);  
          ajax_error(res);
        }
    });
  });
});

function OTPInput() {
  const inputs = document.querySelectorAll('#otp > *[id]');
  for (let i = 0; i < inputs.length; i++) {
      inputs[i].addEventListener('keydown', function(event) {
          if (event.key==="Backspace" ) {
              inputs[i].value='';
              if (i !==0) inputs[i - 1].focus();
          }
          else {
              if (i===inputs.length - 1 && inputs[i].value !=='' ) {
                  return true;
              } else if (event.keyCode> 47 && event.keyCode < 58) {
                  inputs[i].value=event.key;
                  if (i !==inputs.length - 1) inputs[i + 1].focus(); event.preventDefault();
              } else if (event.keyCode> 64 && event.keyCode < 91) {
                  inputs[i].value=String.fromCharCode(event.keyCode);
                  if (i !==inputs.length - 1) inputs[i + 1].focus(); event.preventDefault();
              }
          }
      });
  }
}

function deleteprofilepic(uuid){
  $.ajax({
    type: 'POST',
    dataType: 'json',
    data: {_token:_token, uuid:uuid},
    url: APP_URL+"/remove-profile-picture",
    success: function(res) {
        if(res.status){
          window.location.href = APP_URL+'/profile-picture';
        }
    },
    error: function(res) {                    
        ajax_error(res);
    }
  });
}

function ajax_error(data){
  let errors = '<ul>';
  if (typeof data.responseJSON.error === 'string') {
    errors += '<li>' + data.responseJSON.error + '</li>';
  }else{
    for(datos in data.responseJSON.error){
      console.log(data.responseJSON.error);
      errors += '<li>' + data.responseJSON.error[datos] + '</li>';
    }
  }
  errors += '</ul>';
  $('#alertMsg .pagemsgcontent').html('<div class="alert alert-danger">'+errors+'</div>');
  $('#alertMsg').modal('show');
}