<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\UserController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\GlobalController;
use App\Http\Controllers\PlanController;
use App\Http\Controllers\StripeController;
use App\Http\Controllers\ContentEditingController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Route::get('language/{locale}', function ($locale) {
    app()->setLocale($locale);
    session()->put('locale', $locale);

    return redirect()->back();
});
Route::post('set-currency', [UserController::class, 'set_currency']);

Route::get('/', [HomeController::class, 'home'])->name('home');
Route::get('home', [HomeController::class, 'home'])->name('home');
Route::post('send-otp', [UserController::class, 'send_otp']);
Route::post('verify-otp', [UserController::class, 'verify_otp']);
Route::post('stripe-webhook', [PlanController::class, 'stripe_webhook']);

Route::group(['middleware' => ['guest','loc']], function() {
    Route::get('login-otp', [UserController::class, 'login_otp'])->name('login-otp');
    Route::get('login', [UserController::class, 'login'])->name('login');
    Route::post('login-save', [UserController::class, 'login_save']);
    Route::get('signup', [UserController::class, 'signup']);
    Route::post('signup-validate', [UserController::class, 'signup_validate']);
    Route::get('otp-verification', [UserController::class, 'otp_verification']);
    Route::post('signup-save', [UserController::class, 'signup_save']);
    Route::get('reset-password', [UserController::class, 'resetPassword'])->name('reset-password');
    Route::post('reset-password', [UserController::class, 'updatePassword']);
});

Route::group(['middleware' => ['auth','custom_auth']], function() {
    Route::get('backend/dashboard', function () {
        return view('dashboard');
    });
    Route::get('logout', [UserController::class,'logout'])->name('logout');
    Route::get('profile-picture', [UserController::class, 'profile_picture']);
    Route::post('save-profile-picture', [UserController::class, 'save_profile_picture']);
    Route::post('remove-profile-picture', [UserController::class, 'remove_profile_picture']);
    
    Route::get('plans', [PlanController::class, 'index']);
    Route::get('plans/{plan}', [PlanController::class, 'show'])->name("plans.show");
    Route::post('subscription', [PlanController::class, 'subscription'])->name("subscription.create");
    Route::post('subscription-cancel', [PlanController::class, 'subscription_cancel']);
        
    Route::get('additional-information', [UserController::class, 'additional_information'])->name('additional-information');
    Route::post('add-info-save', [UserController::class, 'additional_info_save']);
    Route::get('consent', [UserController::class, 'consent'])->name('consent');
    Route::get('congratulations', [UserController::class, 'congratulations'])->name('congratulations');
    Route::post('remove-action', [GlobalController::class, 'remove_action']);

    Route::get('account-setting', [GlobalController::class, 'account_setting']);
    Route::post('account-setting-save', [GlobalController::class, 'account_setting_save']);
    Route::post('otp-verification-profile', [GlobalController::class, 'otp_verification_profile']);
    Route::post('verify-otp-profile', [GlobalController::class, 'verify_otp_profile']);
    
    Route::get('backend/applications', [GlobalController::class, 'applications']);
    Route::get('backend/manage-users', [GlobalController::class, 'applications']);
    Route::post('user-app-action', [UserController::class, 'user_app_action']);
    Route::post('userinfo', [UserController::class, 'userinfo']);
    Route::post('userroles', [UserController::class, 'userroles']);
    Route::post('add-permissions', [UserController::class, 'add_permissions']);
    
    Route::post('transfer-points', [UserController::class, 'transfer_points']);
    Route::post('add-points', [UserController::class, 'add_points']);
    
    Route::post('update-user', [UserController::class, 'update_user']);
    Route::post('save-profile', [GlobalController::class, 'save_profile']);
    Route::get('backend/user-management/{uuid}', [GlobalController::class, 'user_management']);
    Route::get('backend/locations', [GlobalController::class, 'locations']);
    Route::post('location-detail', [GlobalController::class, 'location_detail']);
    Route::post('save-location', [GlobalController::class, 'save_location']);
    Route::get('backend/account-settings', [GlobalController::class, 'account_settings']);
    Route::get('backend/billing', [GlobalController::class, 'billing']);

    Route::get('backend/location-landing-page/{locationId}', [ContentEditingController::class, 'location_landing_page']);
    Route::post('fileupload', [ContentEditingController::class, 'fileupload']);
    Route::post('gallery-images', [ContentEditingController::class, 'gallery_images']);
});
