<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1" user-scalable="no">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $__env->yieldContent('title'); ?></title>    

    <link rel="stylesheet" href="<?php echo e(asset('vendor/bootstrap/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('vendor/bootstrap-icons/bootstrap-icons.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/topnav.css')); ?>">

    <script src="<?php echo e(asset('js/jquery-2.2.4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/jquery.validate.min.js')); ?>"></script>
</head>
  <script>
    var APP_URL = <?php echo json_encode(url('/')); ?>

    var _token = $('meta[name="csrf-token"]').attr('content');
  </script>
  <script src="<?php echo e(asset('js/nomadic.js')); ?>" ></script>
<body>
  <?php echo $__env->make('partials/header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <main id="main2">
    <?php echo $__env->yieldContent('content'); ?>
  </main>
  <div class="modal fade" id="alertMsg" style="z-index:90000">
      <div class="modal-dialog modal-dialog-centered">
          <div class="modal-content bdrradius">
          <div class="modal-body">
              <div class="mt-2 mb-4 pagemsgcontent"></div>
              <div class="text-center">
              <button type="button" class="btn btn-primary ml-2" data-bs-dismiss="modal">Ok</button>
              </div>
          </div>
          </div>
      </div>
  </div>

  <!-- Start modal for Language and region -->
  <div class="modal fade" id="Languageandregion" tabindex="-1">
    <div class="modal-dialog modal-xl">
    <div class="modal-content">
      <div class="modal-header position-relative">
        <i class="bi bi-x-lg popuclose" data-bs-dismiss="modal" aria-label="Close"></i>
      </div>
      <div class="modal-body">
        <div class="col-xl-12">
          <ul class="nav nav-tabs nav-tabs-bordered" id="borderedTab" role="tablist">
            <li class="nav-item " role="presentation">
              <button class="nav-link active" id="application-tab" data-bs-toggle="tab" data-bs-target="#bordered-application" type="button" role="tab" aria-controls="Application" aria-selected="true">Language and region</button>
            </li>
            <li class="nav-item" role="presentation">
              <button class="nav-link" id="membership-tab" data-bs-toggle="tab" data-bs-target="#bordered-membership" type="button" role="tab" aria-controls="Membership" aria-selected="false" tabindex="-1">Currency</button>
            </li>
          </ul>

          <div class="tab-content pt-2" id="borderedTabContent"> 
            <div class="tab-pane fade active show" id="bordered-application" role="tabpanel" aria-labelledby="application-tab">
              <div class="row">
                <div class="pagetitle">
                  <h4 class="mt-3"> Choose a language and region</h1>
                </div>
                <div class="col-xl-12 ">
                  <div class="card">
                    <div class="card-body pt-3">
                      <div class="row">
                        <ul class="countryandregionnav">
                          <?php $__currentLoopData = config('app.available_locales'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <?php
                          $lang_arr = explode('|',$key);
                          //countryandregion nav-active
                          ?>
                          <li data-code="<?php echo e($val); ?>" class="lang-box <?php if(session()->get('locale')==$val): ?> countryandregionnav-active <?php endif; ?>"><?php echo e($lang_arr[0]); ?>

                            <div class="clearfix"></div>
                            <span><?php echo e($lang_arr[1]); ?></span>
                          </li>
                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>

          <div class="tab-pane fade" id="bordered-membership" role="tabpanel" aria-labelledby="membership-tab">
            <div class="row">
              <div class="pagetitle">
                <h4 class="mt-3"> Choose a currency</h1>
              </div>
              <div class="col-xl-12 ">
                <div class="card">
                  <div class="card-body pt-3">
                    <div class="row">
                      <ul class="countryandregionnav">
                        <?php $__currentLoopData = config('app.available_currencies'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <?php
                          $cur_arr = explode('|',$val);
                          ?>
                        <li data-code="<?php echo e($key); ?>" class="cur-box <?php if(session()->get('user_currency')==$key): ?> countryandregionnav-active <?php endif; ?>"><?php echo e($cur_arr[0]); ?>

                          <div class="clearfix"></div>
                          <span><?php echo e($key); ?> - <?php echo e($cur_arr[1]); ?></span>
                        </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      </ul>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    </div>
  </div>
  <!-- End modal for Language and region-->

  <?php echo $__env->make('partials/footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <script src="<?php echo e(asset('vendor/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
  <script src="<?php echo e(asset('js/main.js')); ?>"></script>
  <script src="<?php echo e(asset('js/topnav.js')); ?>"></script>
  <?php echo $__env->yieldContent('footer_scripts'); ?>
</body>
</html><?php /**PATH D:\wamp64\www\nomadic\resources\views/layouts/main.blade.php ENDPATH**/ ?>