<?php
namespace App\Http\Middleware;
use Carbon\Carbon; use Closure;
use App\Helpers, Session;

class CustomAuth
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if(Session::has('page_access') && !in_array(auth()->user()->role,['super-admin','admin'])){
            if (str_contains($request->url(), 'backend')) {
                $url_array = explode('/',$request->url());
                $keyword = $url_array[count($url_array)-2];
                $locationId = $request->route()->parameter('locationId');
                if(isset(Session::get('page_access')[$locationId])){
                    $pages = Session::get('page_access')[$locationId];
                    if (!str_contains($pages, $keyword)) {
                        abort(403);
                    }
                }
            }
        }

        return $next($request);
    }
}
