<?php

namespace App\Models;
use Illuminate\Database\Eloquent\Model;

class Point extends Model
{
    protected $table = 'points';
    protected $primaryKey = 'id';

    public function receivedby()
    {
        return $this->hasOne(User::class, 'uuid', 'receivedby_uuid')->select('uuid','fname','lname');
    }

    public function sentby()
    {
        return $this->hasOne(User::class, 'uuid', 'sentby_uuid')->select('uuid','fname','lname');
    }

    public function plan()
    {
        return $this->hasOne(Plan::class, 'id', 'plan_id')->select('id','name','price');
    }

}
