@extends('layouts.main')
@section('title', 'Nomadic Studios | Additional Information')
@section('content')
<div class="banner">
    <div class="img-text img-margin">{{__('Join global creatives')}}</div>
    <img class="img-fluid w-100" src="{{asset('images/banner1.png')}}">
</div>

<div class="container" data-aos="fade-up">
    <h2 class="mt-4 mb-4">{{__('We would like to know you more')}}</h2>
    <div class="row mb-5 d-block" align="center">
        <div class="col-md-4">
            @if (session('error'))
            <div class="alert alert-danger p-2">{{session('error')}}</div>
            @elseif (session('success'))
            <div class="alert alert-success p-2">{{session('success')}}</div>
            @endif
            <div class="alert alert-danger errorMsgUpdt" style="display:none;"></div>
            <form id="addinfoForm" class="w-100">
                @csrf
                <div class="form-container">
                    <div class="form-group mb-2">
                        <label>{{__('What is your home city?')}} <b style="color:red;">*</b></label>
                        <select class="form-control" id="home_city" name="home_city">
                            <option>Select</option>
                            @foreach($location as $loc)
                            <option value="{{$loc->id}}">{{$loc->location}}</option>
                            @endforeach
                        </select>
                        <i class="bi bi-caret-down-fill searchicon"></i>
                    </div>
                    <div class="form-group mb-2">
                    <label>{{__('What are you creating?')}}</label>
                    <div class="mb-2 position-relative">
                        <div>
                            <input id="checkbox-1" class="checkbox-custom" value="Fine Art" name="creator_interest[]" type="checkbox">
                            <label for="checkbox-1" class="checkbox-custom-label">{{__('Fine Art')}} </label> 
                        </div>
                        <div>       
                            <input id="checkbox-2" class="checkbox-custom" name="creator_interest[]" type="checkbox" value="Music">
                            <label for="checkbox-2" class="checkbox-custom-label">{{__('Music')}}</label> 
                        </div>
                        <div>
                            <input id="checkbox-3" class="checkbox-custom" name="creator_interest[]" type="checkbox" value="Video">
                            <label for="checkbox-3"class="checkbox-custom-label">{{__('Video')}}</label>
                        </div>
                        <div>
                            <input id="checkbox-3" class="checkbox-custom" name="creator_interest[]" type="checkbox" value="Fashion">
                            <label for="checkbox-3"class="checkbox-custom-label">{{__('Fashion')}}</label>
                        </div>
                        <div>
                            <input id="checkbox-3" class="checkbox-custom" name="creator_interest[]" type="checkbox" value="Photography">
                            <label for="checkbox-3"class="checkbox-custom-label">{{__('Photography')}} </label>
                        </div>
                    </div>
                    <div class="form-group mb-2">
                        <label>{{__('Link to profile')}}</label>
                        <input type="text" placeholder="Link" id="profile_link" name="profile_link" class="form-control shadow-none"/>
                    </div>
                    <div class="form-group mb-3">
                        <label>{{__('Link to social media')}}</label>
                        <input type="text" id="instagram_link" name="instagram_link" class="form-control shadow-none" placeholder="{{__('Link to Instagram')}}" />
                        <input type="text" id="facebook_link" name="facebook_link" class="form-control shadow-none" placeholder="{{__('Link to Facebook')}}" />
                        <input type="text" id="twitter_link" name="twitter_link" class="form-control shadow-none" placeholder="{{__('Link to Twitter')}}" />
                        <input type="text" id="sm_link" name="sm_link" class="form-control shadow-none" placeholder="{{__('Link to SM')}}" />
                    </div>
                    <div class="form-group mb-2">
                        <label>{{__('Please provide the name of the member who referred you.')}}</label>
                        <input type="text" placeholder="{{__('Name')}}" id="referred_by" name="referred_by" class="form-control shadow-none"/>
                    </div>
                    
                    <div class="btnconter mt-3 mb-4">
                        <button class="btn" type="button" id="btn_addinfo">{{__('Save')}}
                            <div class="spinner-border text-primary spinner" role="status" style="display:none;vertical-align:text-top;"><span class="visually-hidden">{{__('Loading')}}...</span></div>
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('footer_scripts')
<script>
$(document).ready(function () {
    $('#btn_addinfo').click(function(){
        $('#btn_addinfo .spinner').show();
        $.ajax({
            type: 'POST',
            dataType: 'json',
            data: $('#addinfoForm').serialize(),
            url: APP_URL+"/add-info-save",
            success: function(res) {
                $('#btn_addinfo .spinner').hide();
                if(res.status){
                    window.location.href = APP_URL+'/consent';
                }
            },
            error: function(res) {                    
                $('#btn_addinfo .spinner').hide();
                ajax_error(res);
            }
        });
    });

    $('#addinfoForm1').validate({
        rules: {
            home_city: {
                required: true,
            },
            profile_link: {
                required: true,
            },
            password: {
                required: true,
                minlength: 6,
                
            },
            retype_password: {
                required: true,
                minlength: 6,
                equalTo: "#password"
            },
        },
        errorElement: 'span',
        errorPlacement: function (error, element) {
            // error.addClass('invalid-feedback float-start');
            // element.closest('.form-group').append(error);
        },
        highlight: function (element, errorClass, validClass) {
            $(element).addClass('is-invalid');
        },
        unhighlight: function (element, errorClass, validClass) {
            $(element).removeClass('is-invalid');
        }
    });  

});
</script>
@endsection