@extends('layouts.main')
@section('title', 'Nomadic Studios | Login')
@section('content')
<div class="banner">
    <div class="img-text img-margin">{{__('Join global creatives')}}</div>
    <img class="img-fluid w-100" src="{{asset('images/banner1.png')}}">
</div>

<div class="container" data-aos="fade-up">
    <h2 class="mt-4">{{__('Login')}}</h2>
    <div class="row mb-5 d-block" align="center">
        <div class="col-md-4">
            @if (session('error'))
            <div class="alert alert-danger">{{session('error')}}</div>
            @endif
            <form id="loginForm" class="w-100">
                @csrf
                <input type="hidden" name="type" value="login" readonly>
                <div class="form-container">
                    <div class="form-group mb-2">
                        <input type="text" id="mobile_number" name="mobile_number" class="form-control" placeholder="{{__('Phone Number')}}" />
                    </div>
                </div>
                <div id="btn-sendotp" class="form-container">
                    <div class="btnconter mt-3 mb-4">
                        <button class="btn send-otp" type="button">{{__('Send OTP')}}
                            <div class="spinner-border text-primary spinner" role="status" style="display:none;vertical-align:text-top;"><span class="visually-hidden">{{__('Loading')}}...</span></div>
                        </button>
                    </div>
                </div>
                <div class="otp-container">
                    <div id="otp" class="inputs d-flex flex-row justify-content-center mt-2">
                        <input class="m-2 text-center form-control rounded" type="text" id="first" name="first" maxlength="1" />
                        <input class="m-2 text-center form-control rounded" type="text" id="second" name="second" maxlength="1" />
                        <input class="m-2 text-center form-control rounded" type="text" id="third" name="third" maxlength="1" />
                        <input class="m-2 text-center form-control rounded" type="text" id="fourth" name="fourth" maxlength="1" />
                        <input class="m-2 text-center form-control rounded" type="text" id="fifth" name="fifth" maxlength="1" />
                        <input class="m-2 text-center form-control rounded" type="text" id="sixth" name="sixth" maxlength="1" />
                    </div>
                    <div class="form-container">
                        <span>{{__("Didn’t get an SMS?")}}</span> <a class="send-otp pointer">{{__('Send again')}}</a>
                        <div class="btnconter mt-3 mb-4">
                            <button class="btn" type="button" id="btn_verifyotp">{{__('Verify OTP')}}
                                <div class="spinner-border text-primary spinner" role="status" style="display:none;vertical-align:text-top;"><span class="visually-hidden">{{__('Loading')}}...</span></div>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="form-container">
                    <a href="{{url('login')}}">{{__('Login with password')}}</a>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('footer_scripts')
<script>
document.addEventListener("DOMContentLoaded", function(event) {
    OTPInput(); 
});
$(document).ready(function () {
    $(document).on('click','.send-otp',function(){
        let number = $('#mobile_number').val();
        if($.trim(number)==""){
            $('#mobile_number').addClass('is-invalid');
            return false;
        }else{
            $('#mobile_number').removeClass('is-invalid');
        }
        $.ajax({
            type: 'POST',
            dataType: 'json',
            data: {_token:_token, mobile_number:number},
            url: APP_URL+"/send-otp",
            success: function(res) {
                if(res.status){
                    $('#mobile_number').attr('readonly',true);
                    $('#btn-sendotp').hide();
                    $('.otp-container').show();
                    $('#alertMsg .pagemsgcontent').html('<div class="alert alert-success">'+res.message+'</div>');
                    $('#alertMsg').modal('show');
                }
            },
            error: function(res) {
                ajax_error(res);
            }
        });
    });
    $(document).on('click','#btn_verifyotp',function(){
        $.ajax({
            type: 'POST',
            dataType: 'json',
            data: $('#loginForm').serialize(),
            url: APP_URL+"/verify-otp",
            success: function(res) {
                if(res.status){
                    window.location.href = APP_URL+'/home';
                }
            },
            error: function(res) {
                ajax_error(res);
            }
        });
    });
});
</script>
@endsection
