@extends('layouts.main')
@section('title', 'Nomadic Studios | OTP Verification')
@section('content')
<div class="banner">
    <div class="img-text img-margin">{{__('Join global creatives')}}</div>
    <img class="img-fluid w-100" src="{{asset('images/banner1.png')}}">
</div>

<div class="container" data-aos="fade-up">
    <h2 class="mt-4 mb-4">{{__('Confirm your phone number and email')}}</h2>
    <span>{{__('Please input 6-digit code we just sent to')}} +*(***)*** {{$mobile}} and *******{{$email}}, {{__('wrong phone number/email')}} <a href="{{url('login')}}">{{__('Contact us')}}</a>.</span>
    
    <div class="alert alert-danger errorMsgUpdt" style="display:none;"></div>
    <form id="otpForm" class="w-100">
        @csrf
        <input type="hidden" id="email" value="{{$aemail}}" readonly>
        <input type="hidden" id="mobile_number" value="{{$amob}}" readonly>
        <div class="row mb-5 mt-4 d-block"  align="center">
            <div class="col-md-4">
                <div id="otp" class="inputs d-flex flex-row justify-content-center mt-2">
                    <input class="m-2 text-center form-control rounded" type="text" id="first" name="first" maxlength="1" />
                    <input class="m-2 text-center form-control rounded" type="text" id="second" name="second" maxlength="1" />
                    <input class="m-2 text-center form-control rounded" type="text" id="third" name="third" maxlength="1" />
                    <input class="m-2 text-center form-control rounded" type="text" id="fourth" name="fourth" maxlength="1" />
                    <input class="m-2 text-center form-control rounded" type="text" id="fifth" name="fifth" maxlength="1" />
                    <input class="m-2 text-center form-control rounded" type="text" id="sixth" name="sixth" maxlength="1" />
                </div>
                <div class="form-container">
                    <span>{{__('Didn’t get an SMS?')}}</span> <a data-type="mobile" class="send-otp pointer">{{__('Send again')}}</a>
                </div>
            </div>
        </div>
        <div class="row mb-5 mt-4 d-block"  align="center">
            <div class="col-md-4">
                <div id="otp2" class="inputs d-flex flex-row justify-content-center mt-2">
                    <input class="m-2 text-center form-control rounded" type="text" id="eot1" name="eot1" maxlength="1" />
                    <input class="m-2 text-center form-control rounded" type="text" id="eot2" name="eot2" maxlength="1" />
                    <input class="m-2 text-center form-control rounded" type="text" id="eot3" name="eot3" maxlength="1" />
                    <input class="m-2 text-center form-control rounded" type="text" id="eot4" name="eot4" maxlength="1" />
                    <input class="m-2 text-center form-control rounded" type="text" id="eot5" name="eot5" maxlength="1" />
                    <input class="m-2 text-center form-control rounded" type="text" id="eot6" name="eot6" maxlength="1" />
                </div>
                <div class="form-container">
                    <span>{{__('Didn’t get an Email?')}}</span> <a  data-type="email" class="send-otp pointer">{{__('Send again')}}</a>
                    <div class="btnconter mt-3 mb-4">
                        <button class="btn" type="button" id="btn_otpverify">{{__('Verify OTP')}}
                            <div class="spinner-border text-primary spinner" role="status" style="display:none;vertical-align:text-top;"><span class="visually-hidden">{{__('Loading')}}...</span></div>
                        </button>
                    </div>
                    <span>{{__('Already have an account?')}}</span> <a href="{{url('login')}}">{{__('Login')}}</a>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection

@section('footer_scripts')
<script>
document.addEventListener("DOMContentLoaded", function(event) {
    OTPInput(); 
});
$(document).ready(function () {
    $(document).on('click','#btn_otpverify',function(){
        if($('#otpForm').valid()){
            $('#btn_otpverify .spinner').show();
            $.ajax({
                type: 'POST',
                dataType: 'json',
                data: $('#otpForm').serialize(),
                url: APP_URL+"/signup-save",
                success: function(res) {
                    $('#btn_otpverify .spinner').hide();
                    if(res.status){
                        window.location.href = APP_URL+'/profile-picture';
                    }
                },
                error: function(res) {                    
                    $('#btn_otpverify .spinner').hide();
                    ajax_error(res);
                }
            });
        }
    });

    $(document).on('click','.send-otp',function(){
        let otpfield;
        let type = $(this).data('type');
        if(type=='email'){
            otpfield = $('#email').val();
        }else{
            otpfield = $('#mobile_number').val();
        }
        $.ajax({
            type: 'POST',
            dataType: 'json',
            data: {_token:_token, type:type, otpfield:otpfield},
            url: APP_URL+"/send-otp",
            success: function(res) {
                if(res.status){
                    $('#alertMsg .pagemsgcontent').html('<div class="alert alert-success">'+res.message+'</div>');
                    $('#alertMsg').modal('show');
                }
            },
            error: function(res) {
                ajax_error(res);
            }
        });
    });

    $('#otpForm').validate({
        rules: {
            first: {
                required: true,
            },
            second: {
                required: true
            },
            third: {
                required: true
            },
            fourth: {
                required: true
            },
            fifth: {
                required: true
            },
            sixth: {
                required: true
            },
            eot1: {
                required: true,
            },
            eot2: {
                required: true
            },
            eot3: {
                required: true
            },
            eot4: {
                required: true
            },
            eot5: {
                required: true
            },
            eot6: {
                required: true
            },
        },
        errorElement: 'span',
        errorPlacement: function (error, element) {
            error.addClass('invalid-feedback float-start');
            element.closest('.rounded').append(error);
        },
        highlight: function (element, errorClass, validClass) {
            $(element).addClass('is-invalid');
        },
        unhighlight: function (element, errorClass, validClass) {
            $(element).removeClass('is-invalid');
        }
    });

});
</script>
@endsection
