@extends('layouts.main')

@section('content')
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">{{ __('Reset Password') }}</div>
                    <form id="resetForm">
                        @csrf
                        @if (session('error'))
                        <div class="alert alert-danger">{{session('error')}}</div>
                        @endif
                        @if (session('success'))
                        <div class="alert alert-success">{{session('success')}}</div>
                        @endif
                        <div class="alert alert-danger errorMsgUpdt" style="display:none;"></div>
                            <div class="mb-3">
                                <label for="emilAddress" class="form-label">E-mail Address</label>
                                <input name="email" type="email" class="form-control" id="emailInput" placeholder="Please enter your email">
                            </div>
                        <div class="card-footer">
                            <button class="btn btn-success" id="btn_forgot_pass" type="button">Send Password Reset Link</button>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('footer_scripts')
<script>
    $(document).ready(function () {

        $('#btn_forgot_pass').click(function(){
            $('.login-spinner').show();
            $.ajax({
                type: 'POST',
                dataType: 'json',
                data: $('#resetForm').serialize(),
                url: APP_URL+"/reset-password",
                success: function(res) {
                    $('.login-spinner').hide();
                    console.log(res);                   
                    if(res.status){
                        window.location.reload();
                    }else{
                        $('.pagemsgcontent').html('<div class="alert alert-error">'+res.message+'</div>');
                        $('#alertMsg').modal('show');
                    }
                },
                error: function(res) {                    
                    $('.login-spinner').hide();
                    ajax_error(res,$('.errorMsgUpdt'));
                }
            });
        });

        $('#resetform').validate({ 
        rules: {
            email: {
                required: true,
            },
        },
        messages: {
            email: {
                required: 'E-mail address is required.'
            },
        },
        errorElement: 'span',
        errorPlacement: function (error, element) {
        error.addClass('invalid-feedback');
        element.closest('.form-floating').append(error);
        },
        highlight: function (element, errorClass, validClass) {
            $(element).addClass('is-invalid');
        },
        unhighlight: function (element, errorClass, validClass) {
            $(element).removeClass('is-invalid');
        }
        });  

    });

    function ajax_error(data,errorObj){
    let errors = '<ul>';
    if (typeof data.responseJSON.error === 'string') {
            errors += '<li>' + data.responseJSON.error + '</li>';
    }else{
        for(datos in data.responseJSON.error){
            errors += '<li>' + data.responseJSON.error[datos] + '</li>';
        }
    }
    errors += '</ul>';
    errorObj.html(errors).show();
    setTimeout(function () { errorObj.fadeOut('slow'); },8000);
    }
</script>
@endsection
