@extends('layouts.main')
@section('title', 'Nomadic Studios | Sign up')
@section('content')
<div class="banner">
    <div class="img-text img-margin">{{__('Join global creatives')}}</div>
    <img class="img-fluid w-100" src="{{asset('images/banner1.png')}}">
</div>

<div class="container" data-aos="fade-up">
    <h2 class="mt-4">{{__('Sign up')}}</h2>
    <div class="row mb-5 d-block"  align="center">
        <div class="col-md-4">
            @if (session('error'))
            <div class="alert alert-danger">{{session('error')}}</div>
            @endif
            <div class="alert alert-danger errorMsgUpdt" style="display:none;"></div>
            <form id="signupForm" class="w-100">
                @csrf
                <div class="form-container">
                    <div class="form-group mb-2">
                        <input type="text" id="fname" name="fname" class="form-control shadow-none" placeholder="{{__('First Name')}}" />
                    </div>
                    <div class="form-group mb-2">
                        <input type="text" id="lname" name="lname" class="form-control shadow-none" placeholder="{{__('Last Name')}}" />
                    </div>
                    <div class="form-group mb-2">
                        <input type="tel" placeholder="" id="telephone" class="form-control shadow-none" maxlength="14"/>
                        <span id="msg" class="error"></span>
                        <input type="hidden" id="mobile_number" name="mobile_number"/>
                    </div>
                    <div class="form-group mb-2">
                        <input type="text" id="email" name="email" class="form-control shadow-none" placeholder="{{__('Email Address')}}" />
                    </div>
                    <div class="form-group mb-3">
                        <input type="text" id="password" name="password" class="form-control shadow-none" placeholder="{{__('Password')}}" />
                    </div>
                    <div class="form-group mb-3">
                        <input type="password" id="retype_password" name="retype_password" class="form-control shadow-none" placeholder="{{__('Retype Password')}}" />
                    </div>
                    <span>{{__('By clicking Sign Up, you are indicating that you have read and acknowledge the')}} <a href="{{url('reset-password')}}">{{__('Terms of Service')}}</a> {{__('and')}} <a href="{{url('reset-password')}}">{{__('Privacy Policy')}}</a>.</span></br>
                    <span>{{__('By continue your mobile number, you agree to receive SMS for verification.')}}</span>
                    <div class="btnconter mt-3 mb-4">
                        <button class="btn" type="button" id="btn_signup">{{__('Sign up')}}
                            <div class="spinner-border text-primary spinner" role="status" style="display:none;vertical-align:text-top;"><span class="visually-hidden">{{__('Loading')}}...</span></div>
                        </button>
                    </div>
                    <span>{{__('Already have an account?')}}</span> <a href="{{url('login')}}">{{__('Login')}}</a>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('footer_scripts')
<link rel="stylesheet" href="{{asset('css/intlTelInput.css')}}">
<script src="{{asset('js/intlTelInput.js')}}"></script> 
<script>
    var errorMap = ["{{__('Invalid number')}}", "{{__('Invalid country code')}}", "{{__('Too short')}}", "{{__('Too long')}}"];
    var input = document.querySelector("#telephone");
    var msg = document.querySelector("#msg");
    var intl = window.intlTelInput(input, {
        // showFlags: false,
        separateDialCode: true,
        placeholderNumberType: "MOBILE",
        utilsScript: "{{asset('js/utils.js')}}"
    });
    // Validate on blur event
    input.addEventListener('keyup', function() {
        if(input.value.trim()){
            if(intl.isValidNumber()){
                input.classList.remove("error");
                msg.classList.add("hide");
                //msg.hide();
            }else{
                input.classList.add("error");
                var errorCode = intl.getValidationError();
                msg.innerHTML = errorMap[errorCode];
                msg.classList.remove("hide");
                //msg.show();
            }
        }
        let full_number = intl.getNumber();
        $('#mobile_number').val(full_number);
    });
    input.addEventListener('keyup', (e) => {
        let val = e.target.value;
        e.target.value = val
        .replace(/\D/g, '')
        .replace(/(\d{1,4})(\d{1,3})?(\d{1,3})?/g, function(txt, f, s, t) {
            if (t) {
                return `(${f}) ${s}-${t}`
            } else if (s) {
                return `(${f}) ${s}`
            } else if (f) {
                return `(${f})`
            }
        });
    });
    
    $(document).ready(function () {
        $('#btn_signup').click(function(){
            let isValid1 = false;
            let isValid2 = false;
            if($('#signupForm').valid()){
                isValid1 = true;
            }
            if(intl.isValidNumber()){
                $('#telephone').removeClass('is-invalid');
                isValid2 = true;
            }else{
                $('#telephone').addClass('is-invalid');
                $('#msg').html("{{__('This field is required.')}}");
                isValid2 = false;
            }
            if(isValid1 && isValid2){
                $('#btn_signup .spinner').show();
                $.ajax({
                    type: 'POST',
                    dataType: 'json',
                    data: $('#signupForm').serialize(),
                    url: APP_URL+"/signup-validate",
                    success: function(res) {
                        $('#btn_signup .spinner').hide();
                        if(res.status){
                            window.location.href = APP_URL+'/otp-verification';
                        }
                    },
                    error: function(res) {                    
                        $('#btn_signup .spinner').hide();
                        ajax_error(res);
                    }
                });
            }
        });

        $('#signupForm').validate({
            rules: {
                fname: {
                    required: true,
                },
                lname: {
                    required: true,
                },
                email: {
                    required: true,
                    email:true,
                },
                password: {
                    required: true,
                    minlength: 6,
                    
                },
                retype_password: {
                    required: true,
                    minlength: 6,
                    equalTo: "#password"
                },
            },
            messages: {
                // fname: {
                //     required: 'First name is required.'
                // },
                // lname: {
                //     required: 'Last name is required.'
                // },
                // telephone: {
                //     required: 'Mobile number is required.'
                // },
                // password: {
                //     required: 'Password is required.'
                // },
            },
            errorElement: 'span',
            errorPlacement: function (error, element) {
                // error.addClass('invalid-feedback float-start');
                // element.closest('.form-group').append(error);
            },
            highlight: function (element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function (element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            }
        });  

    });
</script>
@endsection
