@extends('layouts.sidebar')
@section('title', 'Nomadic Studios | Applications')
@section('content')
<div class="pagetitle">
  <h1>Applications</h1>
</div><!-- End Page Title -->

<section class="section profile">
  <div class="row">
    <div class="gridcard col-xl-12">

      <div class="card">
        <div class="row">
          <div class="col-md-7 mb-2 position-relative">
            <input id="search_field" type="text" class="form-control" placeholder="Search">
            <i class="bi bi-search searchicon"></i>
          </div>
        </div>
        <div class="card-body profile-card pt-4 pl-0 d-flex flex-column align-items-center">
          <table class="table">
            <thead>
              <tr>
                <td>Name</td>
                <td>Home City</td>
                <td>Art</td>
                <td>Status</td>
                <td></td>
              </tr>
            </thead>
            <tbody>
              @if(!empty($data) && $data->count())
                @foreach($data as $dt)
                <tr>
                  <td>{{$dt->fname}} {{$dt->lname}}</td>
                  <td>{{$dt->user_location->location}}</td>
                  <td>{{$dt->creator_interest}}</td>
                  <td class="{{$dt->uuid}}">
                    @if($dt->status==0) <span>Sent</span> 
                    @elseif($dt->status==1) <span class="txtPayment">Payment Captured</span> 
                    @elseif($dt->status==2) <span class="txtApproved">Approved</span> 
                    @elseif($dt->status==3) <span class="txtDenied">Denied</span> @endif
                  </td>
                  <td>
                  @if($dt->status==0 || $dt->status==1)
                    <i class="bi bi-eye vieweye" style="color:#0d6efd" data-uuid="{{$dt->uuid}}"></i>
                    @else
                    <i class="bi bi-eye vieweye" data-uuid="{{$dt->uuid}}"></i>
                    @endif
                  </td>
                </tr>
                @endforeach
              @else
              <tr>
                <td colspan="5">No record found</td>
              </tr>  
              @endif
            </tbody>
            <tfoot>
              <tr>
                <td colspan="5">
                  <div class="foot-paging">
                    {!! $data->withQueryString()->links('vendor.pagination.bootstrap-5') !!}
                  </div>  
                </td>
              </tr>
            </tfoot>
          </table>
        </div>
      </div>

    </div>

    <div class="col-xl-5 user-card" style="display:none;">
      <div class="card thinborder" style="min-height:500px;">
        <div class="card-body pt-3">
        </div>
      </div>
    </div>

  </div>
</section>
@endsection
@section('footer_scripts')
<script>
  $(document).ready(function () {
    $(document).on('click', '.vieweye', function(){
      $('.gridcard').removeClass('col-xl-12').addClass('col-xl-7');
      $('.user-card').show();
      $('.user-card .card-body').html('<div class="pt-5 d-flex justify-content-center"><div class="spinner-grow" role="status"></div></div>');
      
      let uuid = $(this).data('uuid');
      $.ajax({
          type: 'POST',
          dataType: 'json',
          data: {_token:_token, uuid:uuid, type:'view'},
          url: APP_URL+"/userinfo",
          success: function(res) {
            if(res.status){
              $('.user-card .card-body').html(res.content);
            }
          },
          error: function(res) {                    
            ajax_error(res);
          }
      });
    });

  });
</script>
@endsection