
<?php $__env->startSection('title', 'Nomadic Studios | Plans'); ?>
<?php $__env->startSection('content'); ?>
<div class="banner">
    <div class="img-text img-margin"><?php echo e(__('Join global creatives')); ?></div>
    <img class="img-fluid w-100" src="<?php echo e(asset('images/banner1.png')); ?>">
</div>

<div class="container" data-aos="fade-up">
    <h2 class="mt-4 mb-4"><?php echo e(__('Select membership level')); ?></h2> 
    <span>- <?php echo e(__('14 days residence/year')); ?></span></br>
    <span>- <?php echo e(__('14 days studio time/year')); ?></span>
    <div class="row mb-5" align="center">
        <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-md-22 me-4 subscription-box">
            <div class="p-2 mb-4"><?php echo e($plan->name); ?></div>
            <h3 class="mb-4"><b>$<?php echo e($plan->price); ?></b><span>/<?php echo e($plan->frequency); ?></span></h3>
            <div class="p-2"><i class="bi bi-check2 me-2"></i><?php echo e($plan->points); ?> Pts</div>
            <div class="p-2"><i class="bi bi-check2 me-2"></i>
            <?php if($plan->stripe_plan==""): ?>
            Must be invited by member
            <?php else: ?>
            Book up <?php echo e($plan->advance_duration); ?> <?php echo e($plan->advance_frequency); ?> in advance
            <?php endif; ?>
            </div>
            <div class="p-2"><i class="bi bi-check2 me-2"></i><?php echo e($guests[$plan->num_of_guest]); ?> guests</div>
            <?php if($plan->slug=='guest'): ?>
            <a href="<?php echo e(route('consent')); ?>" class="btn btn-primary pull-right mt-4 mb-3"><?php echo e(__('Choose plan')); ?></a>
            <?php else: ?>
            <a href="<?php echo e(route('plans.show', $plan->slug)); ?>" class="btn btn-primary pull-right mt-4 mb-3"><?php echo e(__('Choose plan')); ?></a>
            <?php endif; ?>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\nomadic\resources\views/stripe/plans.blade.php ENDPATH**/ ?>