

<?php $__env->startSection('content'); ?>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header"><?php echo e(__('Reset Password')); ?></div>
                    <form id="resetForm">
                        <?php echo csrf_field(); ?>
                        <?php if(session('error')): ?>
                        <div class="alert alert-danger"><?php echo e(session('error')); ?></div>
                        <?php endif; ?>
                        <?php if(session('success')): ?>
                        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
                        <?php endif; ?>
                        <div class="alert alert-danger errorMsgUpdt" style="display:none;"></div>
                            <div class="mb-3">
                                <label for="emilAddress" class="form-label">E-mail Address</label>
                                <input name="email" type="email" class="form-control" id="emailInput" placeholder="Please enter your email">
                            </div>
                        <div class="card-footer">
                            <button class="btn btn-success" id="btn_forgot_pass" type="button">Send Password Reset Link</button>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer_scripts'); ?>
<script>
    $(document).ready(function () {

        $('#btn_forgot_pass').click(function(){
            $('.login-spinner').show();
            $.ajax({
                type: 'POST',
                dataType: 'json',
                data: $('#resetForm').serialize(),
                url: APP_URL+"/reset-password",
                success: function(res) {
                    $('.login-spinner').hide();
                    console.log(res);                   
                    if(res.status){
                        window.location.reload();
                    }else{
                        $('.pagemsgcontent').html('<div class="alert alert-error">'+res.message+'</div>');
                        $('#alertMsg').modal('show');
                    }
                },
                error: function(res) {                    
                    $('.login-spinner').hide();
                    ajax_error(res,$('.errorMsgUpdt'));
                }
            });
        });

        $('#resetform').validate({ 
        rules: {
            email: {
                required: true,
            },
        },
        messages: {
            email: {
                required: 'E-mail address is required.'
            },
        },
        errorElement: 'span',
        errorPlacement: function (error, element) {
        error.addClass('invalid-feedback');
        element.closest('.form-floating').append(error);
        },
        highlight: function (element, errorClass, validClass) {
            $(element).addClass('is-invalid');
        },
        unhighlight: function (element, errorClass, validClass) {
            $(element).removeClass('is-invalid');
        }
        });  

    });

    function ajax_error(data,errorObj){
    let errors = '<ul>';
    if (typeof data.responseJSON.error === 'string') {
            errors += '<li>' + data.responseJSON.error + '</li>';
    }else{
        for(datos in data.responseJSON.error){
            errors += '<li>' + data.responseJSON.error[datos] + '</li>';
        }
    }
    errors += '</ul>';
    errorObj.html(errors).show();
    setTimeout(function () { errorObj.fadeOut('slow'); },8000);
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\nomadic\resources\views/auth/reset-password.blade.php ENDPATH**/ ?>