
<?php $__env->startSection('title', 'Nomadic Studios | Applications'); ?>
<?php $__env->startSection('content'); ?>
<div class="pagetitle">
  <h1>Applications</h1>
</div><!-- End Page Title -->

<section class="section profile">
  <div class="row">
    <div class="gridcard col-xl-12">

      <div class="card">
        <div class="row">
          <div class="col-md-7 mb-2 position-relative">
            <input id="search_field" type="text" class="form-control" placeholder="Search">
            <i class="bi bi-search searchicon"></i>
          </div>
        </div>
        <div class="card-body profile-card pt-4 pl-0 d-flex flex-column align-items-center">
          <table class="table">
            <thead>
              <tr>
                <td>Name</td>
                <td>Home City</td>
                <td>Art</td>
                <td>Status</td>
                <td></td>
              </tr>
            </thead>
            <tbody>
              <?php if(!empty($data) && $data->count()): ?>
                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                  <td><?php echo e($dt->fname); ?> <?php echo e($dt->lname); ?></td>
                  <td><?php echo e($dt->user_location->location); ?></td>
                  <td><?php echo e($dt->creator_interest); ?></td>
                  <td class="<?php echo e($dt->uuid); ?>">
                    <?php if($dt->status==0): ?> <span>Sent</span> 
                    <?php elseif($dt->status==1): ?> <span class="txtPayment">Payment Captured</span> 
                    <?php elseif($dt->status==2): ?> <span class="txtApproved">Approved</span> 
                    <?php elseif($dt->status==3): ?> <span class="txtDenied">Denied</span> <?php endif; ?>
                  </td>
                  <td>
                  <?php if($dt->status==0 || $dt->status==1): ?>
                    <i class="bi bi-eye vieweye" style="color:#0d6efd" data-uuid="<?php echo e($dt->uuid); ?>"></i>
                    <?php else: ?>
                    <i class="bi bi-eye vieweye" data-uuid="<?php echo e($dt->uuid); ?>"></i>
                    <?php endif; ?>
                  </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              <?php else: ?>
              <tr>
                <td colspan="5">No record found</td>
              </tr>  
              <?php endif; ?>
            </tbody>
            <tfoot>
              <tr>
                <td colspan="5">
                  <div class="foot-paging">
                    <?php echo $data->withQueryString()->links('vendor.pagination.bootstrap-5'); ?>

                  </div>  
                </td>
              </tr>
            </tfoot>
          </table>
        </div>
      </div>

    </div>

    <div class="col-xl-5 user-card" style="display:none;">
      <div class="card thinborder" style="min-height:500px;">
        <div class="card-body pt-3">
        </div>
      </div>
    </div>

  </div>
</section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer_scripts'); ?>
<script>
  $(document).ready(function () {
    $(document).on('click', '.vieweye', function(){
      $('.gridcard').removeClass('col-xl-12').addClass('col-xl-7');
      $('.user-card').show();
      $('.user-card .card-body').html('<div class="pt-5 d-flex justify-content-center"><div class="spinner-grow" role="status"></div></div>');
      
      let uuid = $(this).data('uuid');
      $.ajax({
          type: 'POST',
          dataType: 'json',
          data: {_token:_token, uuid:uuid, type:'view'},
          url: APP_URL+"/userinfo",
          success: function(res) {
            if(res.status){
              $('.user-card .card-body').html(res.content);
            }
          },
          error: function(res) {                    
            ajax_error(res);
          }
      });
    });

  });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\nomadic\resources\views/global/applications.blade.php ENDPATH**/ ?>