<?php
function convertCurrency($amount){
    $user_currency = session()->get('user_currency');
    if($user_currency=='USD'){ return $amount; }
    if(session()->has('currency') && isset(session()->get('currency')[$user_currency])){
        $conversion_rate = session()->get('currency')[$user_currency];
        $converted_amount = round($amount*$conversion_rate);
        return $converted_amount;
    }
    return $amount;
}

function formatTimestamp($timestamp) {
    $date = new DateTime();  
    $timestamp = ($timestamp/1000);
    if ($date->format('Y-m-d') === date('Y-m-d', $timestamp)) {  
        return $date->format('g:i A').", Today";  
    } elseif ($date->modify('-1 day')->format('Y-m-d') === date('Y-m-d', $timestamp)) {  
        return $date->format('g:i A').", Yesterday";  
    } else {
        return date('g:i A, jS M', $timestamp);  
    }
    
    // $currentDate = new DateTime();
    // $givenDate = new DateTime();
    // $givenDate->setTimestamp($timestamp);

    // $interval = $currentDate->diff($givenDate)->days;

    // if ($interval == 0) {
    //     return $givenDate->format('H:i').", Today";
    // } elseif ($interval == 1) {
    //     return $givenDate->format('H:i').", Yesterday";
    // } else {
    //     return $givenDate->format('l, F j, Y \a\t H:i');
    // }
} 