<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Gallery;
use App\Models\Role;
use App\Models\File;
use App\Helpers;
use Carbon\Carbon, Validator, Session;

class CmsController extends Controller
{
    public function index(Request $request, $page)
    {
        $files = File::where('page',$page)->get();

        $template = "cms.index";
        if($page=='our-partners'){
            $template = "cms.partners";
        }
        
        return view($template)->with(['files'=>$files, 'page'=>ucfirst($page)]);
    }

    public function save_file(Request $request)
    {
        $validator = Validator::make($request->all(),[ 
            'file_id'  => 'required'
        ]);
        
        if($validator->fails()) {
            return response()->json([
                'status' => false,
                'error'=>$validator->errors()
            ], 422);
        }
        
        $file_id = $request->file_id;
        $file = File::find($file_id);
        if($file){
            $imageName = basename($file->image_path);
            $image_path = public_path('images/fe/');
            $image = $request->file('file');
            $image->move($image_path, $imageName);
            $file->image_path = 'images/fe/'.$imageName;
            $file->save();

            // if(\File::exists(public_path($old_image))){
            //     \File::delete(public_path($old_image));
            // }

            $new_url = url('images/fe/'.$imageName);

            return response()->json(['status'=>true, 'file_id'=>$file_id, 'image_url'=>$new_url]);
        }
        return response()->json(['status'=>false,'error'=>'Invalid form data received.']);
    }

    public function save_carousel_file(Request $request)
    {
        $validator = Validator::make($request->all(),[ 
            'page'  => 'required',
            'section'  => 'required'
        ]);
        
        if($validator->fails()) {
            return response()->json([
                'status' => false,
                'error'=>$validator->errors()
            ], 422);
        }
        $image = $request->file('file');
        $imageName = time().'.'.$image->extension();
        $image_path = public_path('images/our-partners/');
        $image->move($image_path, $imageName);
        
        $file = new File;
        $file->page = $request->page;
        $file->section = $request->section;
        $file->image_path = 'images/our-partners/'.$imageName;
        $file->save();

        return response()->json(['status'=>true,'message'=>'File uploaded successfully.']);
    }

    public function carousel_images(Request $request)
    {
        $gallery = File::where('page',$request->page)->where('section',$request->section)->get();
        $content = view('cms.carousel-images')->with(['gallery'=>$gallery])->render(); 
        return response()->json(['status'=>true,'content'=>$content]);
    }

    public function carousel_image_delete(Request $request)
    {
        $validator = Validator::make($request->all(),[ 
            'id' => 'required'
        ]);
        
        if($validator->fails()) {
            return response()->json([
                'status' => false,
                'error'=>$validator->errors()
            ], 422);
        }

        try{
            $file = File::where('id',$request->id)->first();
            $file->delete();
            
            if(\File::exists(public_path($file->image_path))){
                \File::delete(public_path($file->image_path));
            }

            return response()->json([
                'status' => true,
            ], 200);
        }catch(\PDOException $pde ) {
            return response()->json([
                'status' => false,
                'error' => $pde->getMessage(),
            ], 422);
        }catch(\Exception $e){
            return response()->json([
                'status' => false,
                'error' => $e->getMessage(),
            ], 422);
        }
    }
    
}
