<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\SendBird;
use App\Models\User;
use Carbon\Carbon;
use Validator, Session, DB;

class CommunicationController extends Controller
{
    public function index(Request $request)
    {
        $data = [];
        $sendbird = new SendBird();
        $res = $sendbird->GET_Call('open_channels',['limit'=>20]);
        if($res['status']){
            $data = $res['data'];
        }else{
            Session::flash('error',$res['error']);
        }
        //dd($data);
        return view("communication.index")->with($data);
    }

    public function messages(Request $request)
    {
        $data = [];
        $channel_type = $request->channel_type;
        $channel_url = $request->channel_url;
        $params['message_ts'] = time()*1000;
        $api_name = "{$channel_type}/{$channel_url}/messages";
        $sendbird = new SendBird();
        $res = $sendbird->GET_Call($api_name, $params);
        //dd($res);
        if($res['status']){
            $data = $res['data'];
        }else{
            Session::flash('error',$res['error']);
        }

        $content = view("communication.chat-messages")->with($data)->render();
        
        return response()->json([
            'status' => true,
            'content' => $content,
        ], 200);
        
    }

    public function send_txt(Request $request)
    {
        $data = [];
        $channel_type = $request->channel_type;
        $channel_url = $request->channel_url;
        $params['message_type'] = "MESG";
        $params['message'] = $request->txt;
        $params['user_id'] = auth()->user()->uuid;
        $api_name = "{$channel_type}/{$channel_url}/messages";
        $sendbird = new SendBird();
        $res = $sendbird->POST_Call($api_name, $params);
        
        if($res['status']){
            $data = $res['data'];
        }
        
        return response()->json([
            'status' => true,
            'tmpmsgid' => $request->tmpmsgid,
            'data' => $data
        ], 200);
        
    }

}
