<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Event;
use App\Helpers;

use Carbon\Carbon, Validator, Session;

class CronController extends Controller
{
    public function channel_expire(Request $request)
    {
        set_time_limit(0);

        $undeleted_channel = [];
        $event_date = date('Y-m-d', strtotime('-1 day'));
        $awsIvsService = resolve(\App\Services\AwsIvsService::class);
        $events = Event::where('event_date',$event_date)->get();
        foreach($events as $event){
            $result = $awsIvsService->deleteChannel($event->channel_arn);
            if (isset($result['error'])) {
                $undeleted_channel[] =  $event->channel_arn;
            }else{
                //Event::where('event_id',$event->event_id)->update();
            }
        }

        if(count($undeleted_channel) > 0){
            // $edata = array();
            // $edata['email'] = 'sudhir.bhadauria18@gmail.com';
            // $edata['channels'] = $undeleted_channel;
            // \Mail::send('emails.channel-expire', $edata, function($message) use($edata) {
            //     $message->to($edata['email']);
            //     $message->subject('Channel Expire Cron Status!');
            // });

            $content = '<p>Channel expired:</p><ul>';
            foreach($undeleted_channel as $ch){
                $content .= '<li>'.$ch.'</li>';
            }
            $content .= '</ul>';

            $templateId = env('SENDGRID_TEMPLATE_ID3');
            $template_data['subject'] = 'Channel Expire Cron Status!';
            $template_data['content'] = $content;
            $res = Helpers::__send_email('sudhir.bhadauria18@gmail.com', $template_data, $templateId);
        }

        dd('Cron Job executed successfully');
    }

    public function points_expired(Request $request)
    {
        set_time_limit(0);

        $current_date = date('Y-m-d');
        $users = User::select('uuid','fname', 'lname', 'email')->where('membership','!=','guest')->get();
        foreach($users as $user){
            $current_balance = 0;
            $balance_data = Point::select('balance')->where('receivedby_uuid',$user->uuid)->orderBy('id','desc')->first();
            if($balance_data){
                $current_balance = $balance_data->balance;
            }

            if($current_balance > 0){
                $expired_points = Point::where('receivedby_uuid',$user->uuid)->whereIn('action',['POINTS_RECEIVED', 'POINTS_PURCHASED'])->where('status',0)->whereDate('expired_at', '<',$current_date)->sum('credit');
                if($expired_points > 0){
                    // add points expired
                    $balance = 0;
                    if($current_balance > $expired_points){
                        $balance = ($current_balance - $expired_points);
                    }
                    $point = new Point;
                    $point->action = 'POINTS_EXPIRED';
                    $point->receivedby_uuid = $user->uuid;
                    $point->debit = $expired_points;
                    $point->balance = $balance;
                    $point->save();
                    // change status
                    Point::where('receivedby_uuid',$user->uuid)->whereIn('action',['POINTS_RECEIVED', 'POINTS_PURCHASED'])->where('status',0)->whereDate('expired_at', '<',$current_date)->update(['status'=>1]);
                    // notifications
                    Notification::insert(['user'=>$user->uuid, 'type'=>'point', 'action'=>'POINTS_EXPIRED', 'content'=>'Your points ('.$expired_points.') had been expired.']);
                    // emails
                    if($user->email){
                        // $edata = array();
                        // $edata['email'] = $user->email;
                        // $edata['name']  = $user->fname.' '.$user->lname;
                        // $edata['heading'] = 'Points expired';
                        // $edata['content'] = 'Your points ('.$expired_points.') had been expired.';
                        // \Mail::send('emails.general', $edata, function($message) use($edata) {
                        //     $message->to($edata['email']);
                        //     $message->subject('Points expired!');
                        // });

                        $templateId = env('SENDGRID_TEMPLATE_ID3');
                        $template_data['subject'] = 'Points expired!';
                        $template_data['content'] = '<p>Your points ('.$expired_points.') had been expired.</p>';
                        $res = Helpers::__send_email($user->email, $template_data, $templateId);
                    }
                }
            }
        }
        
        dd('Cron Job executed successfully');
    }
    
}
