<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Location;
use App\Models\UpcomingGuest, App\Models\Event;
use App\Models\Point, App\Helpers, Hash;
use App\Models\Notification;
class GuestController extends Controller
{
    public function upcoming_guests(Request $request, $locationId, $guestId='')
    {
        $query = UpcomingGuest::select('upcoming_guests.*','users.fname','users.lname','users.email')
        ->Join('users','guest_uuid','users.uuid')->with('location','host')->where('location_id',$locationId);
        if($request->has('name') && $request->name!=""){
            $query->whereRaw('concat(fname," ",lname) like "'.$request->name.'%"');
        }
        $guests = $query->OrderBy('created_at', 'desc')->paginate(10);
        //dd($guests);
        return view("user.upcoming-guest")->with(['data'=>$guests,'guestId'=>$guestId]);
    }
	
    public function invite_action(Request $request)
    {
        try{
            if($request->status==3){
                $guestData = UpcomingGuest::select('invitation_date', 'invitation_time', 'uuid', 'users.fname', 'users.lname', 'users.email')->join('users', 'guest_uuid', '=', 'users.uuid')
                ->where('upcoming_guests.id',$request->upcoming_id)->first();
                $password = Helpers::generatePassword();
                User::where('uuid',$guestData->uuid)->update(['password'=>Hash::make($password)]);
                // invitation email
                // $data = array();
                // $data['email']  = $guestData->email;
                // $data['name']   = $guestData->fname.' '.$guestData->lname;
                // $data['password']   = $password;
                // $data['invcontent'] = 'You are invited as a guest on '.$guestData->invitation_date.' '.$guestData->invitation_time;
                // \Mail::send('emails.invitation', $data, function($message) use($data) {
                //     $message->to($data['email']);
                //     $message->subject('Resend Invitation');
                // });

                $content = '<p>You are invited as a guest on '.$guestData->invitation_date.' '.$guestData->invitation_time.'</p>';
                $content .= "<p>Please use these credentials to login:</p>";
                $content .= "<p>Email:{$guestData->email}</br>Password:{$password}</p>";
                
                $templateId = env('SENDGRID_TEMPLATE_ID3');
                $template_data['content'] = $content;
                $template_data['subject'] = 'Resend Invitation';
                $res = Helpers::__send_email($guestData->email, $template_data, $templateId);

                return response()->json([
                    'status' => true,
                ], 200);
            }else{
                if($request->status==1){
                    // get guest detail
                    $guest = UpcomingGuest::where('id',$request->upcoming_id)->with('guest', 'host')->first();
                    if($guest->invitation_type=='event' && $guest->comp!=0){
                        // get guest points balance
                        $point_balance = 0;
                        $points_data = Point::select('balance')->where('receivedby_uuid',$guest->guest_uuid)
                        ->orderBy('id','desc')->first();
                        if($points_data){
                            $point_balance = $points_data->balance;
                        }
                        // get event points
                        $nomadic_account_uuid = env('NOMADIC_ACCOUNT_UUID');
                        $event = Event::find($guest->ref_id);
                        if($point_balance >= $guest->comp){
                            //receivedby entry
                            $rec_current_balance = 0;
                            $rec_balance_data = Point::select('balance')->where('receivedby_uuid',$nomadic_account_uuid)->orderBy('id','desc')->first();
                            if($rec_balance_data){
                                $rec_current_balance = $rec_balance_data->balance;
                            }
                            $point = new Point;
                            $point->action = 'POINTS_RECEIVED_EVENT';
                            $point->receivedby_uuid = $nomadic_account_uuid;
                            $point->receivedby_uuid = $guest->host_uuid;
                            $point->sentby_uuid = $guest->guest_uuid;
                            $point->credit = $guest->comp;
                            $point->balance = ($rec_current_balance + $guest->comp);
                            //$point->expired_at = $expired_at;
                            $point->save();
                            $recPointId = $point->id;
                            //notification
                            Notification::insert(['user'=>$nomadic_account_uuid, 'type'=>'point', 'action'=>'POINTS_RECEIVED_EVENT', 'content'=>'Your have received ('.$guest->comp.') points from <b>'.$guest->guest->fname.' '.$guest->guest->lname.'</b>.','reference_id'=>$recPointId]);
                            //sentby entry
                            $rpoint = new Point;
                            $rpoint->action = 'POINTS_SENT_EVENT';
                            $rpoint->receivedby_uuid = $guest->guest_uuid;
                            $rpoint->sentby_uuid = $nomadic_account_uuid;
                            $rpoint->debit = $guest->comp;
                            $rpoint->balance = ($point_balance - $guest->comp);
                            $rpoint->save();
                            $sentPointId = $point->id;
                            //notification
                            Notification::insert(['user'=>$guest->guest_uuid, 'type'=>'point', 'action'=>'POINTS_SENT_EVENT', 'content'=>'Your have sent ('.$guest->comp.') to <b>'.$guest->host->fname.' '.$guest->host->lname.'</b>.','reference_id'=>$sentPointId]);
                            
                        }else{
                            return response()->json([
                                'status' => false,
                                'content' => 'Your wallet balance is low, recharge your wallet to checked in this event. <input type="button" class="btn btn-primary w-30 mb-2 buypoints" data-type="cancel" value="Buy points">',
                            ], 200);
                        }
                    }
                }
                $mngstatus = UpcomingGuest::where('id',$request->upcoming_id)->update(['status'=>$request->status]);
                if($mngstatus){
                    if($request->status==1){
                        $msg = 'CheckedIn successfully.';
                    }else if($request->status==2){
                        $msg = 'Invitation cancelled successfully.';
                    }else{
                        $msg = 'Status updated successfully.';
                    }
                    return response()->json([
                        'status' => true,
                        'message' => $msg,
                    ], 200);
                }
            }
            return response()->json([
                'status' => false,
                'error' => 'Invalid form data received.',
            ], 422);
        }catch(\PDOException $pde ) {
            return response()->json([
                'status' => false,
                'error' => $pde->getMessage(),
            ], 422);
        }catch(\Exception $e){
            return response()->json([
                'status' => false,
                'error' => $e->getMessage(),
            ], 422);
        }
    }

    public function guest_detail(Request $rrquest, $guestId){
        $data = UpcomingGuest::select('upcoming_guests.*', 'users.fname', 'users.lname', 'users.email', 'profile_pic')
            ->join('users', 'guest_uuid', '=', 'users.uuid')->with('location', 'host')
            ->where('upcoming_guests.id', $guestId)->first();
        if(is_null($data)){
            abort(404);
        }
        $event = false;
        if(!empty($data)){
            if(!empty($data->ref_id) && $data->invitation_type=='event'){
                $event = Event::find($data->ref_id);
            }
        }
        
        return view("frontend.guest.guest-detail")->with(['data' => $data, 'event'=>$event]);
    }
    
}
