<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;
use Carbon\Carbon, Auth, DB, Session, Validator, Hash;
use App\Imports\GuestDataImport;
use App\Models\GuestData, App\Models\UpcomingGuest;
use App\Models\User, App\Models\Booking, App\Models\Point, App\Models\Plan;
use App\Models\Event, App\Models\Location, App\Models\Participant;
use Illuminate\Support\Facades\Mail;
use App\Helpers, App\Models\Notification;
use Ramsey\Uuid\Uuid;

class GuestDataController extends Controller
{
    public function import(Request $request)
    {
        $request->validate([
            'file' => 'required|mimes:xlsx,xls',
        ]);
        $import = new GuestDataImport();
        $import->guest_event_id = $request->guest_event; 
        
        Excel::import($import, $request->file('file')); 
        
        $guestDataRecords = GuestData::where('status', 0)->get();

        foreach ($guestDataRecords as $guestData) {
            if(isset($guestData->id)){
                $user = User::where('email', $guestData->email)->first();
                if ($user) {
                    $new_user = false;
                    $uuid = $user->uuid;
                    $user_id = $user->id;
                }else{
                    $new_user = true;
                    $uuid = (string) Uuid::uuid4();
                    $password = Helpers::generatePassword();
                    $user = new User;
                    $user->uuid = $uuid; 
                    $user->role = 'guest';
                    $user->fname = $guestData->fname;
                    $user->lname = $guestData->lname;
                    $user->email = $guestData->email;
                    $user->mobile_number = $guestData->mobile_number;
                    $user->status = 1;
                    $user->password = Hash::make($password);
                    $user->save();
                    $user_id = $user->id;
                }
                $event = Event::find($guestData->guest_event_id);
                $upcomingGuest = new UpcomingGuest([
                    'location_id' => $event->location_id, 
                    'invitation_type' => 'event', 
                    'ref_id' => $guestData->guest_event_id,
                    'guest_uuid' => $uuid,
                    'host_uuid' => $event->user_uuid, 
                    'invitation_date' => $event->event_date, 
                    'invitation_time' => $event->event_time, 
                    'comp' => $guestData->comp,
                    'status' => (!empty($guestData->comp)) ? 0 : 3, 
                ]);
                $upcomingGuest->save();	

                $part = new Participant;
                $part->event_id = $guestData->guest_event_id;
                $part->user_id = $user_id;
                $part->status = 'going';
                $part->save();

                $guestData->update(['status' => 1]);
                // invitation email
                // $data = array();
                // $data['email']      = $guestData->email;
                // $data['name']       = $guestData->fname.' '.$guestData->lname;
                // if($new_user){
                //     $data['password']   = $password;
                // }
                // $data['invcontent'] = 'You are invited as a guest for the event on '.$event->event_date.' '.$event->event_time;
                // \Mail::send('emails.invitation', $data, function($message) use($data) {
                //     $message->to($data['email']);
                //     $message->subject('Invitation for the event');
                // });

                $content = '<p>You are invited as a guest for the event on '.$event->event_date.' '.$event->event_time.'</p>';
                if (is_null($user)) {
                    $content .= "<p>Please use these credentials to login:</p>";
                    $content .= "<p>Email:{$guestData->email}</br>Password:{$password}</p>";
                }
                $templateId = env('SENDGRID_TEMPLATE_ID3');
                $template_data['subject'] = 'Invitation for the event';
                $template_data['content'] = $content;
                $res = Helpers::__send_email($guestData->email, $template_data, $templateId);
            }
        }

        return redirect()->back()->with('success', 'Guest data imported successfully.');
    }
	
	public function processGuestData()
    {
        $guestDataRecords = GuestData::where('status', 0)->get();

        foreach ($guestDataRecords as $guestData) {
            if(isset($guestData->id)){
                $user = User::where('email', $guestData->email)->first();
                
                if ($user) {
                    $new_user = false;
                    $uuid = $user->uuid;
                }else{
                    $new_user = true;
                    $uuid = (string) Uuid::uuid4();
                    $password = Helpers::generatePassword();
                    $user = new User([
                        'uuid' => $uuid, 
                        'role' => 'guest', 
                        'fname' => $guestData->fname,
                        'lname' => $guestData->lname,
                        'email' => $guestData->email,
                        'status' => 1, 
                        'password' => Hash::make($password), 
                    ]);
                    $user->save();
                }
                $event = Event::find($guestData->guest_event_id);
                $upcomingGuest = new UpcomingGuest([
                    'location_id' => $event->location_id, 
                    'invitation_type' => 'event', 
                    'ref_id' => $guestData->guest_event_id,
                    'guest_uuid' => $uuid,
                    'host_uuid' => $event->user_uuid, 
                    'invitation_date' => $event->event_date, 
                    'invitation_time' => $event->event_time, 
                    'comp' => $guestData->comp,
                    'status' => 0, 
                ]);
                $upcomingGuest->save();	
                $guestData->update(['status' => 1]);
                // invitation email
                // $data = array();
                // $data['email']      = $guestData->email;
                // $data['name']       = $guestData->fname.' '.$guestData->lname;
                // if($new_user){
                //     $data['password']   = $password;
                // }
                // $data['invcontent'] = 'You are invited as a guest for the event on '.$event->event_date.' '.$event->event_time;
                // \Mail::send('emails.invitation', $data, function($message) use($data) {
                //     $message->to($data['email']);
                //     $message->subject('Invitation for the event');
                // });

                $content = '<p>You are invited as a guest for the event on '.$event->event_date.' '.$event->event_time.'</p>';
                if (is_null($user)) {
                    $content .= "<p>Please use these credentials to login:</p>";
                    $content .= "<p>Email:{$guestData->email}</br>Password:{$password}</p>";
                }
                $templateId = env('SENDGRID_TEMPLATE_ID3');
                $template_data['subject'] = 'Invitation for the event';
                $template_data['content'] = $content;
                $res = Helpers::__send_email($guestData->email, $template_data, $templateId);
            }
        }

        dd('Guest data processing completed.');
    }
	
    public function invite_guest(Request $request, $type = null, $id = null)
    {
        $data = [];
        $data['id'] = $id;
        $data['type'] = (is_null($type)) ? 'location' : $type;
        if($id && $type=='booking'){
            $booking = Booking::select('location_id','start_date','start_time')
            ->where('booking_id',$id)->first();
            if(is_null($booking)){
                abort(404);
            }
            $data['loc']   = $booking->location_id;
            $data['start_date'] = $booking->start_date;
            $data['start_time'] = (!is_null($booking->start_time)) ? date("H:i", strtotime($booking->start_time)) : '00:00';
        }else if($id && $type=='event'){
            $event = Event::select('event_id', 'event_title', 'location_id','event_date','event_time','ticket_price')
            ->where('event_id',$id)->first();
            if(is_null($event)){
                abort(404);
            }
            $targetDatetime = date('Y-m-d H:i:s');
            $event_list = Event::select('event_id', 'location_id', 'event_title', 'event_date','event_time','ticket_price')->where(DB::raw("CONCAT(event_date, ' ', event_time)"), '>', $targetDatetime)
            ->where('public_private','public')->where('location_id',$event->location_id)->get();
            $data['loc']   = $event->location_id;
            $data['ticket_price']   = $event->ticket_price;
            $data['ticket_price_local'] = Helpers::convertCurrencyFromUSD(Helpers::convertPointsToUSD($event->ticket_price));
            $data['start_date'] = $event->event_date;
            $data['start_time'] = (!is_null($event->event_time)) ? date("H:i", strtotime($event->event_time)) : '00:00';
            $data['event_list'] = $event_list;
            
        } 

        if(session()->has('igld')){
            $data['loc'] = session()->get('igld.location_id');
            $data['start_date'] = session()->get('igld.start_date');
            $data['start_time'] = session()->get('igld.start_time');
            $data['end_date'] = session()->get('igld.end_date');
            $data['end_time'] = session()->get('igld.end_time');
            $data['id'] = session()->get('igld.id');
            $data['type'] = session()->get('igld.type');
        }

        $locations = Location::pluck('location','id');
        $data['locations'] = $locations;
        
        return view("frontend.guest.invite")->with($data);
    }

    public function invite_guest_process(Request $request)
    {
        $validator = Validator::make($request->all(),[
            'location_id' => 'required',
            'start_date' => 'required',
            'start_time' => 'required',
            'end_date' => 'required',
            'end_time' => 'required', 
        ]);
        
        if($validator->fails()) {
            return response()->json([
                'status' => false,
                'error' => $validator->errors()->first()
            ], 422);
        }

        $location_id = $request->location_id;
        $start_date = $request->start_date;
        $start_time = $request->start_time;
        $end_date = $request->end_date;
        $end_time = $request->end_time;

        $guests = session()->get('guests');

        foreach ($guests as $guestData) {
            $user = User::where('email', $guestData['email'])->first();
            
            if ($user) {
                $new_user = false;
                $uuid = $user->uuid;
            }else{
                $new_user = true;
                $uuid = (string) Uuid::uuid4();
                $password = Helpers::generatePassword();
                $user = new User([
                    'uuid' => $uuid, 
                    'role' => 'guest', 
                    'fname' => $guestData['fname'],
                    'lname' => $guestData['lname'],
                    'email' => $guestData['email'],
                    'mobile_number' => $guestData['mobile'],
                    'status' => 1, 
                    'password' => Hash::make($password), 
                ]);
                $user->save();
            }
            $upcomingGuest = new UpcomingGuest([
                'location_id' => $location_id, 
                'invitation_type' => $request->type, 
                'ref_id' => ($request->type=='location') ? $location_id : $request->num,
                'guest_uuid' => $uuid,
                'host_uuid' => auth()->user()->uuid, 
                'invitation_date' => $start_date, 
                'invitation_time' => $start_time, 
                'invitation_end_date' => $end_date, 
                'invitation_end_time' => $end_time, 
                'comp' => (isset($guestData['price'])) ? $guestData['price'] : 0,
                'status' => 0, 
            ]);
            $upcomingGuest->save();	
            
            $content = '<p>You are invited as a guest for the event on '.$start_date.' '.$start_time.'</p>';
            if (is_null($user)) {
                $content .= "<p>Please use these credentials to login:</p>";
                $content .= "<p>Email:{$guestData['email']}</br>Password:{$password}</p>";
            }
            $templateId = env('SENDGRID_TEMPLATE_ID3');
            $template_data['subject'] = 'Invitation for the event';
            $template_data['content'] = $content;
            $res = Helpers::__send_email($guestData['email'], $template_data, $templateId);
        }

        return response()->json([
            'status' => true,
            'message' => 'Guest invited successfully.'
        ], 200);
    }

	public function invite_guest_process2(Request $request)
    {
	    $validator = Validator::make($request->all(), [
            'fname' => 'required',
            'lname' => 'required',
            'email' => 'required|email',
            //'phone' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => false,
                'error' => $validator->errors()
            ], 422);
        }

        $invitation_time = $request->invitation_time;
        $invitation_date = $request->invitation_date;

        $ref_id = 0;
        $booking_id = 0;
        $invitiation_type = 'Studio';
        if($request->num!="" && $request->type=="booking"){
            // plan restriction:check guest count
            $guestCount = UpcomingGuest::join('booking_details', 'upcoming_guests.booking_id', '=', 'booking_details.booking_id')
                ->where('upcoming_guests.booking_id', $request->num)
                ->whereDate('upcoming_guests.invitation_date', '>=', DB::raw('booking_details.start_date'))
                ->whereDate('upcoming_guests.invitation_date', '<=', DB::raw('booking_details.end_date'))
                ->where('upcoming_guests.host_uuid', auth()->user()->uuid)
                ->where('upcoming_guests.status', '!=' ,2)
                ->count();

            $plan = Plan::where('slug',auth()->user()->membership)->first();
            if(isset($plan->num_of_guest) && $guestCount >= $plan->num_of_guest){
                return redirect('/invited-guest')->with('error', "You can only invite {$plan->num_of_guest} guest.");
            }

            $booking = Booking::select('location_id','start_date','start_time')
            ->where('booking_id',$request->num)->where('created_by',auth()->user()->id)->first();
            $location_id      = $booking->location_id;
            $invitation_date  = $booking->start_date;
            $invitation_time  = $booking->start_time;
            $booking_id = $request->num;
        }else if($request->num!="" && $request->type=="event"){
            $event = Event::select('event_id', 'location_id','event_date','event_time')
            ->where('event_id',$request->num)->first();
            $location_id      = $event->location_id;
            $invitation_date  = $event->event_date;
            $invitation_time  = $event->event_time;
            $ref_id = $event->event_id;
            $invitiation_type = 'event';
            
            // plan restriction:check guest count
            $guestCount = UpcomingGuest::join('booking_details', 'upcoming_guests.booking_id', '=', 'booking_details.booking_id')
                ->where('upcoming_guests.booking_id', $request->num)
                ->whereDate('upcoming_guests.invitation_date', '>=', DB::raw('booking_details.start_date'))
                ->whereDate('upcoming_guests.invitation_date', '<=', DB::raw('booking_details.end_date'))
                ->where('upcoming_guests.host_uuid', auth()->user()->uuid)
                ->where('upcoming_guests.status', '!=' ,2)
                ->count();


        }else{
            if($request->location_id=="" || $request->invitation_date=="" || $request->invitation_time==""){
                return response()->json([
                    'status' => false,
                    'error' => 'Required fields are missing.'
                ], 422);
            }
            $location_id     = $request->location_id;
            $invitation_date = $request->invitation_date;
            $invitation_time = $request->invitation_time;
        }
		
        $user = User::where('email', $request->email)->first();
        if ($user) {
            $new_user = false;
            $uuid = $user->uuid;
            $user_id = $user->id;
        }else{
            $new_user = true;
            $uuid = (string) Uuid::uuid4();
            $password = Helpers::generatePassword();
            $user = new User;
            $user->uuid = $uuid; 
            $user->role = 'guest';
            $user->fname = $request->fname;
            $user->lname = $request->lname;
            $user->email = $request->email;
            $user->mobile_number = (isset($request->mobile_number)) ? $request->mobile_number : null;
            $user->status = 1;
            $user->password = Hash::make($password);
            $user->save();
            $user_id = $user->id;
        }

        $upcomingGuest = new UpcomingGuest;
        $upcomingGuest->location_id = $location_id;
        $upcomingGuest->invitation_type = $invitiation_type;
        $upcomingGuest->ref_id = $ref_id;
        $upcomingGuest->booking_id = $booking_id;
        $upcomingGuest->guest_uuid = $uuid;
        $upcomingGuest->host_uuid = auth()->user()->uuid;
        $upcomingGuest->invitation_date = $invitation_date;
        $upcomingGuest->invitation_time = $invitation_time;
        $upcomingGuest->comp = (isset($request->comp)) ? $request->comp : 0;
		$upcomingGuest->status = 0;
        $upcomingGuest->save();

        if($request->num!="" && $request->type=="event"){
            $part = new Participant;
            $part->event_id = $ref_id;
            $part->user_id = $user_id;
            $part->status = 'going';
            $part->save();
        }
        // invitation email
        // $data = array();
        // $data['email']      = $request->email;
        // $data['name']       = $request->fname.' '.$request->lname;
        // if($new_user){
        //     $data['password']   = $password;
        // }
        // $data['invcontent'] = 'You are invited as a guest for the event on '.$invitation_date.' '.$invitation_time;
        // \Mail::send('emails.invitation', $data, function($message) use($data) {
        //     $message->to($data['email']);
        //     $message->subject('Invitation for the event');
        // });

        $content = "<p>You are invited as a guest for the event on {$invitation_date} {$invitation_time}</p>";
        if (is_null($user)) {
            $content .= "<p>Please use these credentials to login:</p>";
            $content .= "<p>Email:{$request->email}</br>Password:{$password}</p>";
        }
        $templateId = env('SENDGRID_TEMPLATE_ID3');
        $template_data['subject'] = 'Invitation for the event';
        $template_data['content'] = $content;
        $res = Helpers::__send_email($request->email, $template_data, $templateId);
        
        return redirect('/invited-guest')->with('success', 'Guest invited successfully.');
    }

    public function invitations(Request $request)
    {
        $data = UpcomingGuest::select('upcoming_guests.*', 'users.fname', 'users.lname', 'users.email')
        ->join('users', 'host_uuid', '=', 'users.uuid')->with('location', 'host')
        ->where('guest_uuid', auth()->user()->uuid)->paginate(10);
        
        return view("frontend.guest.invitation")->with(['data' => $data]);
    }

    public function invited_guest(Request $request)
    {
        $data = UpcomingGuest::select('upcoming_guests.*', 'users.fname', 'users.lname', 'users.email')
        ->join('users', 'guest_uuid', '=', 'users.uuid')->with('location', 'host')
        ->where('host_uuid', auth()->user()->uuid)->paginate(10);
        
        return view("frontend.guest.invited")->with(['data' => $data]);
    }

    public function guest_data(Request $request)
    {
        try{
            $data = UpcomingGuest::select('upcoming_guests.*', 'users.fname', 'users.lname', 'users.email')
            ->join('users', 'guest_uuid', '=', 'users.uuid')->with('location', 'host')
            ->where('upcoming_guests.id', $request->upcoming_id)->first();
        
            $content = view("frontend.guest.guest-data")->with(['data' => $data])->render();
            return response()->json([
                'status' => true,
                'content' => $content
            ], 200);
        }catch(\PDOException $pde ) {
            return response()->json([
                'status' => false,
                'error' => $pde->getMessage(),
            ], 422);
        }catch(\Exception $e){
            return response()->json([
                'status' => false,
                'error' => $e->getMessage(),
            ], 422);
        }
    }

    public function invite_guest_event(Request $request)
    {
	    $validator = Validator::make($request->all(), [
            'guest' => 'required',
            'event' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => false,
                'error' => $validator->errors()
            ], 422);
        }

        $event = Event::find($request->event);


        if($request->num!="" && $request->type=="booking"){
            $booking = Booking::select('location_id','start_date','start_time')
            ->where('booking_id',$request->num)->where('created_by',auth()->user()->id)->first();
            $location_id      = $booking->location_id;
            $invitation_date  = $booking->start_date;
            $invitation_time  = $booking->start_time;
            
        }else{
            if($request->location_id=="" || $request->invitation_date=="" || $request->invitation_time==""){
                return response()->json([
                    'status' => false,
                    'error' => 'Required fields are missing.'
                ], 422);
            }
            $location_id     = $request->location_id;
            $invitation_date = $request->invitation_date;
            $invitation_time = $request->invitation_time;
        }
		
        $user = User::where('email', $request->email)->first();
        if ($user) {
            $new_user = false;
            $uuid = $user->uuid;
        }else{
            $new_user = true;
			$uuid = (string) Uuid::uuid4();
            $password = Helpers::generatePassword();
            $user = new User([
                'uuid' => $uuid, 
                'role' => 'guest', 
                'fname' => $request->fname,
                'lname' => $request->lname,
                'email' => $request->email,
                'status' => 1, 
                'password' => Hash::make($password), 
                'mobile_number' => '0000000000'
            ]);
            $user->save();
        }
		
        $upcomingGuest = new UpcomingGuest([
            'location_id' => $location_id, 
            'invitation_type' => 'Studio', 
            'ref_id' => 0, 
            'guest_uuid' => $uuid, 
            'host_uuid' => auth()->user()->uuid, 
            'invitation_date' => $invitation_date, 
            'invitation_time' => $invitation_time, 
            'status' => 0, 
        ]);
        $upcomingGuest->save();
        // invitation email
        // $data = array();
        // $data['email']      = $request->email;
        // $data['name']       = $request->fname.' '.$request->lname;
        // if($new_user){
        //     $data['password']   = $password;
        // }
        // $data['invcontent'] = 'You are invited as a guest for the event on '.$invitation_date.' '.$invitation_time;
        // \Mail::send('emails.invitation', $data, function($message) use($data) {
        //     $message->to($data['email']);
        //     $message->subject('Invitation for the event');
        // });

        $content = '<p>You are invited as a guest for the event on '.$invitation_date.' '.$invitation_time.'</p>';
        if (is_null($user)) {
            $content .= "<p>Please use these credentials to login:</p>";
            $content .= "<p>Email:{$request->email}</br>Password:{$password}</p>";
        }
        $templateId = env('SENDGRID_TEMPLATE_ID3');
        $template_data['subject'] = 'Invitation for the event';
        $template_data['content'] = $content;
        $res = Helpers::__send_email($request->email, $template_data, $templateId);
        
        return redirect('/invited-guest')->with('success', 'Guest invited successfully.');
    }

    public function going_event(Request $request){
        $validator = Validator::make($request->all(),[  
            'event_id' => 'required',
        ]);
        
        if($validator->fails()) {
            return response()->json([
                'status' => false,
                'error'=>$validator->errors()
            ], 422);
        }
        
        try{        
            $event = Event::find($request->event_id);
            if(is_null($event)){
                return response()->json([
                    'status' => false,
                    'error' => 'Invalid event id'
                ], 422);
            }
            $host_uuid = $event->user_uuid;
            $guest_uuid = auth()->user()->uuid;
            // Get user points balance
            $point_balance  = Point::where('receivedby_uuid', $guest_uuid)
            ->whereIn('action', ['MEMBERSHIP_CREDIT', 'POINTS_PURCHASED','BOOKING_CANCELLED'])
            ->where('balance', '>', 0)
            ->whereDate('expired_at', '>=', now())
            ->get()->sum('balance');
            
            // Paid for event
            if($event->ticket_price > 0){
                if($point_balance >= $event->ticket_price){
                    $nomadic_account_uuid = env('NOMADIC_ACCOUNT_UUID');
                    //book event
                    $point = new Point;
                    $point->action = 'BOOK_EVENT';
                    $point->receivedby_uuid = $nomadic_account_uuid;
                    $point->sentby_uuid = $guest_uuid;
                    $point->credit = $event->ticket_price;
                    $point->balance = $event->ticket_price;
                    $point->amount = $event->ticket_price;
                    //$point->expired_at = $expired_at;
                    $point->save();
                    $recPointId = $point->id;
                    //notification
                    Notification::insert(['user'=>$nomadic_account_uuid, 'type'=>'point', 'action'=>'BOOK_EVENT', 'content'=>'Your have received ('.$event->ticket_price.') points from <b>'.auth()->user()->fname.' '.auth()->user()->lname.'</b>.','reference_id'=>$recPointId]);
                    //notification
                    Notification::insert(['user'=>$guest_uuid, 'type'=>'point', 'action'=>'BOOK_EVENT', 'content'=>'Your have sent ('.$event->ticket_price.') to <b>'.auth()->user()->fname.' '.auth()->user()->lname.'</b>.','reference_id'=>$recPointId]);
                    
                }else{
                    return response()->json([
                        'status' => false,
                        'content' => 'Your wallet balance is low, recharge your wallet to enroll in this event. <input type="button" class="btn btn-primary w-30 mb-2 buypoints" data-type="cancel" value="Buy points">',
                    ], 200);
                }
            }
            // Create paid entry in upcoming guest
            if(isset($request->guest_id)){
                $upcomingGuest = UpcomingGuest::find($request->guest_id);    
            }else{
                $upcomingGuest = new UpcomingGuest;
                $upcomingGuest->location_id = $event->location_id;
                $upcomingGuest->invitation_type = 'event';
                $upcomingGuest->ref_id = $event->event_id;
                $upcomingGuest->guest_uuid = $guest_uuid;
                $upcomingGuest->host_uuid = $host_uuid;
                $upcomingGuest->invitation_date = $event->event_date;
                $upcomingGuest->invitation_time = $event->event_time;
                $upcomingGuest->comp = $event->ticket_price;
            }
            $upcomingGuest->status = 3;//paid
            $upcomingGuest->save();

            // Create partcipant entry
            if(!isset($request->guest_id)){
                $part = new Participant;
                $part->event_id = $event->event_id;
                $part->user_id = auth()->user()->id;
                $part->status = 'going';
                $part->save();
            }

            return response()->json([
                'status' => true
            ], 200);

        }catch(\PDOException $pde ) {
            return response()->json([
                'status' => false,
                'error' => $pde->getMessage(),
            ], 422);
        }catch(\Exception $e){
            return response()->json([
                'status' => false,
                'error' => $e->getMessage(),
            ], 422);
        }

    }
    
}