<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Location, App\Models\Booking;
use App\Models\Event, App\Models\News;
use App\Models\UpcomingGuest, App\Models\Plan;
use Carbon\Carbon;

class HomeController extends Controller
{
    public function home()
    {
        if(isset(auth()->user()->id)){
            return redirect()->route('my-profile');
        }
        $locations = Location::with('landing_page')->get();
        
        return view("home")->with(['locations'=>$locations]);
    }
    
    public function my_profile()
    {
        $id = auth()->user()->id;
        $events = Event::withCount(['interested','going'])->where('event_status',1)
        ->with(['interested'=> function ($query) use($id){
            $query->where('user_id', $id);
        }])->with(['going'=> function ($query) use($id){
            $query->where('user_id', $id);
        }])->orderBy('event_id','desc')->take(4)->get();
        
        $news = News::with('createdBy')->where('status',1)->get();
        $locations = Location::get();

        // invitations
        $invitations = UpcomingGuest::select('upcoming_guests.*', 'users.fname', 'users.lname', 'users.email')
        ->join('users', 'host_uuid', '=', 'users.uuid')->with('location', 'host', 'guest')
        ->where(function($w){
            $w->where('guest_uuid', auth()->user()->uuid)
            ->orWhere('host_uuid', auth()->user()->uuid);
        })->orderBy('upcoming_guests.id','desc')->limit(4)->get();
        //dd($invitations);
        $invcount = UpcomingGuest::select('upcoming_guests.*', 'users.fname', 'users.lname', 'users.email')
        ->join('users', 'host_uuid', '=', 'users.uuid')->with('location', 'host')
        ->where('guest_uuid', auth()->user()->uuid)->count();
        // bookings
        $bookings = Booking::with('loc','locLanding')->leftJoin('booking_details as studio', function($join){
            $join->on('booking_master.booking_id','studio.booking_id')->whereNotNull('studio.studio_id');
        })->leftJoin('booking_details as equip', function($join){
            $join->on('booking_master.booking_id','equip.booking_id')->whereNotNull('equip.equipment_id');
        })->leftJoin('booking_details as resource', function($join){
            $join->on('booking_master.booking_id','resource.booking_id')->whereNotNull('resource.resource_id');
        })->select('booking_master.*','studio.studio_id as studioNum','equip.equipment_id as equipNum','resource.resource_id as resourceNum')->where('uuid',auth()->user()->uuid)->limit(3)->get();
        //dd($bookings);

        // advance date flag
        $advance_date_flag = "";
        if(!is_null(auth()->user()->membership)){
            $plan = Plan::where('slug',auth()->user()->membership)->first();
            if($plan->advance_duration > 0){
                if($plan->advance_frequency=='week'){
                    $advance_date_flag = Carbon::now()->addWeeks($plan->advance_duration)->format('Y-m-d');
                }else if($plan->advance_frequency=='month'){
                    $advance_date_flag = Carbon::now()->addMonths($plan->advance_duration)->format('Y-m-d');
                }
            }
        }

        // pending booking
        $pending_booking = '';
        if(session()->has('temp-booking-points')){
            $points = session()->get('temp-booking-points');
            if(isset($points['resource'])){
                $redirect = 'resource';
            }else if(isset($points['equipment'])){
                $redirect = 'equipment';
            }else if(isset($points['studio'])){
                $redirect = 'studio';
            }
        }
        if(isset($redirect)){
            $pending_booking = url('choose-your-preference/'.$redirect);
        }

        return view("frontend.my-profile")->with(['events'=>$events,'related_news'=>$news,'locations'=>$locations, 'invitations'=>$invitations, 'invcount'=>$invcount, 'bookings'=>$bookings, 'advance_date_flag'=>$advance_date_flag, 'pending_booking'=>$pending_booking]);
    }
    
}
