<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Arr;
use App\Helpers;
use App\Models\User;
use App\Models\Location, App\Models\LandingPage;
use App\Models\Booking, App\Models\BookingDetail;
use App\Models\Equipment, App\Models\UpcomingGuest;
use App\Models\Studio, App\Models\Event, App\Models\Participant;
use App\Models\StudioTypes, App\Models\ResourceTypes;
use Carbon\Carbon, Validator, Session;
use Illuminate\Support\Facades\DB;
class ManagingController extends Controller
{
    private $paginate = 20;  
	public function schedule_location(Request $request, $locationId)
	{
        $page = LandingPage::where('type','location')->where('location_id',$locationId)->first();
        $query = Studio::where('location_id', $locationId);
        if($request->has('name') && $request->name!=""){
            $query->whereRaw('name like "%'.$request->name.'%"');
        }
        $local_studios = $query->paginate($this->paginate);
        
        $events = [];
        $bookings = Booking::where('location_id', $locationId)->with('booking_by','studios','resources','rentals')->get();
        //dd($bookings);
        foreach ($bookings as $booking) {
            $createdByPhone = $booking->booking_by->mobile_number;
            $createdByEmail = $booking->booking_by->email; 
            $createdByUser = $booking->booking_by->fname.' '.$booking->booking_by->lname;

            if($booking->studios){
                foreach($booking->studios as $studio){
                    $studio_title = $studio->name;
                    $studio_type = $studio->studioType;
	                    $events[] = [
                        'id' => $studio->detid,
						'booking_status' => $studio->detstatus,
                        'booking_id' => $booking->booking_id,
						'booking_detail_id' =>  $studio->detid,
                        'title' => $createdByUser.", ".$studio_title,
                        'start' => $booking->start_date.'T'.$booking->start_time,
                        'end' => $booking->end_date.'T'.$booking->end_time,
                        'start_date' => $booking->start_date,
                        'end_date' => $booking->end_date, 
                        'start_time' => $booking->start_time,
                        'end_time' => $booking->end_time,
                        'type' => 'studio',
                        'studio_type' => $studio_type,
                        'studio_name' => $studio_title,
                        'resources' => '',
                        'equipments' => '',
                        'client_name' => $createdByUser,
                        'client_phone' => $createdByPhone,
                        'client_email' => $createdByEmail,
                        'total_points' => $booking->total_points,
                        'bgcolor' => "#0009ff",
                        'color' => "#0009ff",
                        'textColor' => 'black',
                        'booking'=>true
                    ];
                }
            }

            if($booking->rentals){
                foreach($booking->rentals as $rental){
                    $events[] = [
                        'id' => $rental->detid,
                        'booking_id' => $booking->booking_id,
                        'booking_status' => $rental->detstatus,
                        'booking_detail_id' =>  $rental->detid,
                        'title' => $createdByUser.", ".$rental->name,
                        'start' => $booking->start_date.'T'.$booking->start_time,
                        'end' => $booking->end_date.'T'.$booking->end_time,
                        'start_date' => $booking->start_date,
                        'end_date' => $booking->end_date, 
                        'start_time' => $booking->start_time,
                        'end_time' => $booking->end_time,
                        'type' => 'rental',
                        'studio_type' => '',
                        'resources' => '',
                        'equipments' => $rental->name,
                        'client_name' => $createdByUser,
                        'client_phone' => $createdByPhone,
                        'client_email' => $createdByEmail,
                        'total_points' => $booking->total_points,
                        'bgcolor' => "#7600FF",
                        'color' => "#7600FF",
                        'textColor' => 'black',
                        'booking'=>true
                    ];
                }
            }
            
            if($booking->resources){
                foreach($booking->resources as $resource){
                    $events[] = [
                        'id' => $resource->detid,
                        'booking_id' => $booking->booking_id,
						'booking_detail_id' =>  $resource->detid,
						'booking_status' => $resource->detstatus,
                        'title' => $createdByUser.", ".$resource->name,
                        'start' => $booking->start_date.'T'.$booking->start_time,
                        'end' => $booking->end_date.'T'.$booking->end_time,
                        'start_date' => $booking->start_date,
                        'end_date' => $booking->end_date, 
                        'start_time' => $booking->start_time,
                        'end_time' => $booking->end_time,
                        'type' => 'resource',
                        'studio_type' => '',
                        'resource_name' => $resource->fname.' '.$resource->lname,
                        'resource_type' => $resource->name,
                        'equipments' => '',
                        'client_name' => $createdByUser,
                        'client_phone' => $createdByPhone,
                        'client_email' => $createdByEmail,
                        'total_points' => $booking->total_points,
                        'bgcolor' => "#5FBE82",
                        'color' => "#5FBE82",
                        'textColor' => 'black',
                        'booking'=>true
                    ];
                }
            }
        }
        //dd($events);
		//dd(DB::getQueryLog());
        return view("managing.schedule-location")->with(['locationId' => $locationId, 'page' => $page,  'local_studios' => $local_studios, 'events' => $events]); 
    }

    public function studio_detail(Request $request)
    {
        $lp = LandingPage::select('studios','our_crew')->where('type','location')
        ->where('location_id',$request->locationId)->first();
		$crews = ResourceTypes::where('status',1)->whereIn('id',explode(',',$lp->our_crew))->pluck('name','id');
        $studio_type = StudioTypes::where('status',1)->whereIn('id',explode(',',$lp->studios))->pluck('name','id');
        try{
            $data = null;
            if($request->has('lid') && $request->lid!=""){ 
                $data = Studio::find($request->lid);
            }
            $content = view("managing.studio-card")->with(['data'=>$data,'locationId'=>$request->locationId,'studio_type'=>$studio_type, 'crews'=>$crews])->render();    
            return response()->json([
                'status' => true,
                'content' => $content,
            ], 200);
        }catch(\PDOException $pde ) {
            return response()->json([
                'status' => false,
                'error' => $pde->getMessage(),
            ], 422);
        }catch(\Exception $e){
            return response()->json([
                'status' => false,
                'error' => $e->getMessage(),
            ], 422);
        }
    }

    public function save_studio(Request $request)
    {
		$validator = Validator::make($request->all(),[ 
            'name' => 'required',
            'studio_type' => 'required',
        ]);
        
        if($validator->fails()) {
            return response()->json([
                'status' => false,
                'error'=>$validator->errors()
            ], 422);
        }

        try{
            if($request->studioid){
                $data = Studio::find($request->studioid);
                if(is_null($data->studio_slug)){
                    $data->studio_slug = Helpers::clean_string($data->name);
                }
                $msg = 'Studio updated successfully.';
            }else{
                $data = new Studio;
                $data->studio_slug = Helpers::clean_string($request->name);
                $msg = 'Studio created successfully.';
            }
            $data->name = $request->name;
			$data->location_id = $request->locationId;
			$data->studio_type = $request->studio_type; 
            if(isset($request->crew)){
                $data->crew = implode(',',$request->crew);
            }
            $data->daily_rate = Helpers::convertCurrencyToUSD($request->daily_rate);
			$data->hourly_rate = Helpers::convertCurrencyToUSD($request->hourly_rate);
            $data->save();
            return response()->json([
                'status' => true,
                'message' => $msg,
            ], 200);
        }catch(\PDOException $pde ) {
            return response()->json([
                'status' => false,
                'error' => $pde->getMessage(),
            ], 422);
        }catch(\Exception $e){
            return response()->json([
                'status' => false,
                'error' => $e->getMessage(),
            ], 422);
        }
    }

    
	public function schedule_event_list(Request $request, $locationId)
	{
		$events = [];
	    $event_list = Event::with('createdBy','updatedBy')->where('location_id',$locationId)->get();
     
	    foreach ($event_list as $booking) {
            $createdByPhone = $booking->createdBy->mobile_number;
            $createdByEmail = $booking->createdBy->email; 
            $createdByUser = $booking->createdBy->fname.' '.$booking->createdBy->lname;
               
            $events[] = [
                'id' => $booking->event_id,
                'title' => $createdByUser.", ".$booking->address,
                'start' => $booking->event_date.'T'.$booking->event_time,
                'end' => $booking->end_date,
                'start_date' => $booking->event_date,
                'end_date' => $booking->event_date, 
                'start_time' => $booking->event_time,
                'type' => $booking->event_type,
                'client_name' => $createdByUser,
                'client_phone' => $createdByPhone,
                'client_email' => $createdByEmail,
                'bgcolor' => "#0009ff",
                'color' => "#0009ff",
                'borderColor'=> "#0009ff",
                'textColor' => 'black',
            ];
            
        }
        //dd($events);
       
        return view("managing.schedule-events")->with(['locationId' => $locationId,  'events' => $events]);
	}
	
	public function event_detail(Request $request, $locationId, $eventID)
    {
        $id = auth()->user()->id;
        $method = request()->route()->getActionMethod();
        $layout = ($method=='event_detail') ? 'sidebar' : 'main';

        $event = Event::with('createdBy', 'updatedBy')->with(['interested'=> function ($query) use($id){
            $query->where('user_id', $id);
        }])->with(['going'=> function ($query) use($id){
            $query->where('user_id', $id);
        }])->where('location_id', $locationId)->find($eventID); 
        $interestedCount = $event->participants()->wherePivot('status', 'interested')->count();
        $goingCount = $event->participants()->wherePivot('status', 'going')->count();

        return view("managing.event-detail")->with(['locationId' => $locationId, 'goingCount' =>$goingCount,'interestedCount' =>$interestedCount, 'event' => $event, 'layout'=>$layout]);
    }

    public function bookingStatus($bookingDetailId,$status)
    {
        $bookingDetail = BookingDetail::findOrFail($bookingDetailId);
        $bookingDetail->update(['status' => $status]);
            return response()->json([
            'status' => true,
            'message' => 'Succesfully updated',
        ], 200);
    }

	public function markInterested(Event $event)
    {
        auth()->user()->events()->syncWithoutDetaching([$event->event_id => ['status' => 'interested']]);

        return redirect()->back()->with('success', 'You are interested in this event.');
    }

    public function markGoing(Event $event)
    {
        auth()->user()->events()->syncWithoutDetaching([$event->event_id => ['status' => 'going']]);

        return redirect()->back()->with('success', 'You are going to this event.');
    }

    public function event_action_going(Request $request,$eventId)
    {
        if(isset(auth()->user()->id)){
            Participant::insert(['event_id'=>$eventId,'user_id'=>auth()->user()->id,'status'=>'going']);

            return response()->json([
                'status' => true,
                'message' => 'You are going to this event.',
            ], 200);
        }else{
            return response()->json([
                'status' => false,
                'error' => 'Please login to perform action.',
            ], 422);
        }
    }

    public function event_action_interested(Request $request, $eventId)
    {
        if(isset(auth()->user()->id)){
            Participant::insert(['event_id'=>$eventId,'user_id'=>auth()->user()->id,'status'=>'interested']);

            return response()->json([
                'status' => true,
                'message' => 'You are interested in this event.',
            ], 200);
        }else{
            return response()->json([
                'status' => false,
                'error' => 'Please login to perform action.',
            ], 422);
        }
    }
	
	public function listParticipants(Request $request, $locationId, $eventID)
    {
        $query = UpcomingGuest::select('upcoming_guests.*','users.fname','users.lname','users.email')
        ->Join('users','guest_uuid','users.uuid')->with('location','host')->where('location_id',$locationId)
        ->where('invitation_type','event')->where('ref_id',$eventID);
        if($request->has('name') && $request->name!=""){
            $query->whereRaw('concat(fname," ",lname) like "'.$request->name.'%"');
        }
        $guest_list = $query->OrderBy('created_at', 'desc')->paginate(10);
		// $query = Participant::where('event_id', $eventID)->with('user');
        // $participants = $query->paginate($this->paginate);
		
        $event = Event::with('createdBy', 'updatedBy')->where('location_id', $locationId)->find($eventID);
        return view('managing.event-responded')->with(['locationId' => $locationId, 'event' => $event,  'data' => $guest_list, 'layout'=>'sidebar']);
    }

    public function removeParticipant(Event $event)
    {
        $user_id = auth()->user()->id; 
        Participant::where('event_id', $event->event_id)->where('user_id', $user_id)->delete();

        return redirect()->back()->with('success', 'You have been removed from this event.');
    }
	
    
}
