<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Models\Location;
use App\Models\LandingPage;
use App\Models\StudioTypes;
use App\Models\ResourceTypes;
use App\Models\Resources;
use App\Models\Studio;
use App\Models\EquipmentCategory;
use App\Models\Equipment;
use App\Models\Participant;
use App\Models\Event;
use App\Models\News;
use App\Models\User;
use App\Models\UpcomingGuest;
use App\Models\File;
use DB;

class PageController extends Controller
{
    public function locations()
    {
        $locations = Location::with('landing_page')->get();
        return view("frontend.locations.locations")->with(['locations'=>$locations]);
    }

    public function location_detail(Request $request, $slug)
    {
        $crews = null;
        $resources = null;
        $location = Location::where('slug',$slug)->with('landing_page','gallery','benefit','Studio')->first();
        if($location->landing_page->our_crew){
            $crews = ResourceTypes::whereIn('id',explode(',',$location->landing_page->our_crew))->get();
        }
        $resources = Resources::Join('resource_types','resource_types.id','resources.resource_type_id')
            ->Join('users','users.id','resourceId')->select('uuid','name','fname','lname','profile_pic')
            ->where('location_id',$location->id)->get();
        $studios = LandingPage::with('studio')->where('type','studio')->where('location_id',$location->id)->get();

        return view("frontend.locations.location-detail")->with(['loc'=>$location, 'studios'=>$studios, 'crews'=>$crews, 'resources'=>$resources]);
    }

    public function studios()
    {
        $files = File::where('page','Studios')->get();
        
        return view("frontend.studios.studios")->with(['files' => $files]);
    }

    public function studio_type(Request $request, $slug) 
    {
        $studioType = StudioTypes::where('studio_types.slug',$slug)->first();
        $locations = Location::select('location.*')->with('landing_page')->Join('studios','location_id','location.id')->Join('studio_types','studio_types.id','studio_type')->where('studio_types.slug',$slug)->groupBy('location.id')
        ->get();
        //dd($locations);
        $crews = ResourceTypes::get();
        $resources = Resources::Join('resource_types','resource_types.id','resources.resource_type_id')
        ->Join('users','users.id','resourceId')->select('uuid','name','fname','lname','profile_pic')
        ->inRandomOrder()->limit(3)->get();
        
        
        return view("frontend.studios.studio-type-".$slug)->with(['studioType'=>$studioType,'locations'=>$locations, 'crews'=>$crews, 'resources'=>$resources, 'stslug'=>$slug]);
    }

    public function location_studio(Request $request, $locslug, $stslug)
    {
        $location = Location::where('slug',$locslug)->with('landing_page')->first();
        $locId = $location->id;
        // $studios = Studio::Join('studio_types','studio_types.id','studio_type')
        // ->Join('landing_pages as lp',function($q) use($locId){
        //     $q->on('lp.location_id',$locId)->where('type','studio');
        // })->select('studios.id','studios.studio_slug','studios.name','studio_types.id as studio_type_id','studio_types.name as studio_type', 'studio_types.slug as studio_slug', 'lp.banner_picture')->where('studio_types.slug',$stslug)->where('studios.location_id',$location->id)->get();
        
        $studios = LandingPage::with(["studio" => function($q) use($stslug){
            $q->where('st.slug', $stslug);
        }])
        ->where('type','studio')->where('location_id',$location->id)->get();
        // $studios = LandingPage::with(['studio'=> function($query) use($stslug){
        //     $query->where('st.slug', $stslug);
        // }])->where('type','studio')->where('location_id',$location->id)->get();
        
        $studioIds = $studios->pluck('id');
        
        $gallery = LandingPage::select('gallery.image_url')->Join('gallery',function($join){
            $join->on('gallery.ref_id','landing_pages.id')->where('gallery.type','studio');
        })->where('landing_pages.type','studio')->WhereIn('landing_pages.studios',$studioIds)->get();
        
        $crews = ResourceTypes::get();
        $resources = Resources::Join('resource_types','resource_types.id','resources.resource_type_id')
        ->Join('users','users.id','resourceId')->select('name','fname','lname','profile_pic')
        ->where('location_id',$location->id)->inRandomOrder()->limit(3)->get();
        
        $equipments = EquipmentCategory::Join('equipments','category','equipment_category.id')->select('equipment_category.id','cat_name')->where('location_id',$location->id)->groupBy('equipment_category.id')->get();
        
        return view("frontend.studios.location-studio")->with(['loc'=>$location, 'studios'=>$studios, 'crews'=>$crews, 'resources'=>$resources, 'equipments'=>$equipments, 'gallery'=>$gallery, 'stslug'=>$stslug]);
    }

    public function studio_detail(Request $request, $locslug, $studiotype, $stslug)
    {
        $studio = Studio::where('studio_slug',$stslug)->first();
        $id = $studio->id;
        $lp = LandingPage::with('location','studio','gallery')->where('landing_pages.type','studio')->where('landing_pages.studios',$id)->first();
        if($lp){
            $resourceTypes = explode(',',$lp->our_crew);
            $crews = ResourceTypes::whereIn('id',$resourceTypes)->get();
            //dd($studio);
            $resources = Resources::Join('resource_types','resource_types.id','resources.resource_type_id')
            ->Join('users','users.id','resourceId')->select('name','fname','lname','profile_pic')
            ->where('location_id',$lp->location->id)->inRandomOrder()->limit(3)->get();
            
            $equipments = EquipmentCategory::Join('equipments','category','equipment_category.id')->select('equipment_category.id','cat_name')->where('location_id',$lp->location->id)->groupBy('equipment_category.id')->get();
        }else{
            abort(404);
        }
        return view("frontend.studios.studio-detail")->with(['lp'=>$lp, 'crews'=>$crews, 'resources'=>$resources, 'equipments'=>$equipments]);
    }

    public function studio_access(Request $request, $stslug)
    {
        $studio = Studio::where('studio_slug',$stslug)->first();
        $id = $studio->id;
        $lp = LandingPage::with('location','studio','gallery')->where('landing_pages.type','studio')->where('landing_pages.studios',$id)->first();
        if($lp){
            $resourceTypes = explode(',',$lp->our_crew);
            $crews = ResourceTypes::whereIn('id',$resourceTypes)->get();
            //dd($studio);
            $resources = Resources::Join('resource_types','resource_types.id','resources.resource_type_id')
            ->Join('users','users.id','resourceId')->select('uuid','name','fname','lname','profile_pic')
            ->where('location_id',$lp->location->id)->inRandomOrder()->limit(3)->get();
            
            $equipments = EquipmentCategory::Join('equipments','category','equipment_category.id')->select('equipment_category.id','cat_name')->where('location_id',$lp->location->id)->groupBy('equipment_category.id')->get();
        }else{
            abort(404);
        }
        return view("frontend.studios.studio-detail")->with(['lp'=>$lp, 'crews'=>$crews, 'resources'=>$resources, 'equipments'=>$equipments]);
    }

    public function our_partners()
    {
        $locations = Location::get();
        $partners = File::Where('page','our-partners')->where('section','Section One')->get();
        
        //$studioTypes = DB::table('studio_types')->get();
        //$resources = Resources::Join('resource_types','resource_types.id','resources.resource_type_id')
        //->Join('users','users.id','resourceId')->select('name','fname','lname','profile_pic')->get();
        
        return view("frontend.our-partners")->with(['locations'=>$locations, 'partners'=>$partners]);
    }

    public function crew()
    {
        $locations = Location::get();
        $crews = ResourceTypes::get();
        $resources = Resources::Join('resource_types','resource_types.id','resources.resource_type_id')
        ->Join('users','users.id','resourceId')->select('name','uuid','fname','lname','profile_pic')->get();
        
        return view("frontend.people.people")->with(['locations'=>$locations, 'crews'=>$crews, 'resources'=>$resources]);
    }

    public function crew_profile($uuid)
    {
        $resource = User::where('uuid',$uuid)->first();
        if($resource){
            $specialist = Resources::Join('resource_types','resource_types.id','resources.resource_type_id')
            ->join('location','location.id','resources.location_id')->select('location.location','resource_types.name')->where('resources.resourceId',$resource->id)->get();

            return view("frontend.people.people-profile")->with(['specialist'=>$specialist, 'resource'=>$resource]);
        }
        abort(404);
    }

    public function events(Request $request)
    {
        $id = 0;
        if(isset(auth()->user()->id)){
            $id = auth()->user()->id;
        }
        $query = Event::withCount(['interested','going'])->where('event_status',1);
        
        if($request->has('filterDate') && $request->filterDate!=""){
            $query->whereDate('created_at','=',$request->filterDate);
        }
        if($request->has('filterLocation') && $request->filterLocation!=""){
            $query->where('location_id',$request->filterLocation);
        }

        $events = $query->with(['interested'=> function ($query) use($id){
            $query->where('user_id', $id);
        }])->with(['going'=> function ($query) use($id){
            $query->where('user_id', $id);
        }])->get();
         
        $locations = Location::pluck('location','id');
        
        return view("frontend.event.events")->with(['events'=>$events, 'locations'=>$locations]);
    }

    public function view_event(Request $request, $eventID)
    {
        $id = 0;
        if(isset(auth()->user()->id)){
            $id = auth()->user()->id;
        }
        $event = Event::with('createdBy', 'updatedBy')->with(['interested'=> function ($query) use($id){
            $query->where('user_id', $id);
        }])->with(['going'=> function ($query) use($id){
            $query->where('user_id', $id);
        }])->find($eventID);
        $interestedCount = $event->participants()->wherePivot('status', 'interested')->count();
        $goingCount = $event->participants()->wherePivot('status', 'going')->count();

        return view("managing.event-detail")->with(['locationId' => $event->location_id, 'goingCount' =>$goingCount,'interestedCount' =>$interestedCount, 'event' => $event, 'layout'=>'main']);
    }

    public function news(Request $request)
    {
        $query = News::with('createdBy')->where('status',1);
        if($request->has('filterDate') && $request->filterDate!=""){
            $query->whereDate('created_at','=',$request->filterDate);
        }
        if($request->has('filterTags') && $request->filterTags!=""){
            $query->where('tags','like','%'.$request->filterTags.'%');
        }
        $news = $query->get();
        return view("frontend.news.news")->with(['newsData'=>$news]);
    }

    public function view_news(Request $request, $newsId)
    {
        $tags = [];
        $related_news = null;
        $news = News::with('createdBy')->find($newsId);
        if($news->tags){
            $tags = explode(',',$news->tags);
        }
        if($tags){
            $query = News::with('createdBy')->where('status',1)->where('id','!=',$newsId);
            foreach($tags as $tag){
                $query->where('tags','like','%'.$tag.'%');
            }
            $related_news = $query->take(8)->get();
        }

        return view("frontend.news.view-news")->with(['news' => $news, 'related_news'=>$related_news]);
    }

    public function equipments()
    {
        return view("frontend.equipments.equipments");
    }

    public function services()
    {
        return view("frontend.services.services");
    }

    public function services_pages($page)
    {
        $pageNames = ['social-media-services', 'legal-services', 'accounting-tax-services', 'online-services'];
        if(!in_array($page, $pageNames)){
            abort(404);
        }
        return view("frontend.services.".$page);
    }
    
    
}