<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Http;
use Carbon\Carbon, Auth, DB, Session, Validator, Hash;
use App\Models\Location, App\Models\Role, App\Models\RolePages;
use App\Models\Studio, App\Models\StudioTypes;
use App\Models\User, App\Models\UserPermission;
use App\Models\Booking;
use App\Models\Equipment;
use App\Models\EquipmentCategory;
use App\Models\ResourceTypes;
use App\Helpers;
class StudioController extends Controller
{
	private $paginate = 20;
    
    public function studio_booking(Request $request,$locationId,$studioId){
        $studio = Studio::find($studioId);
        $query = Equipment::where('studios_id', $studioId)->with('Category');
        if($request->has('name') && $request->name!=""){
            $query->whereRaw('name like "%'.$request->name.'%"');
        }
        $studio_equipments = $query->paginate($this->paginate);
        
        $min_booking['min_days'] = 0;
        $min_booking['min_hours'] = 0;
        $min_booking['min_minutes'] = 0;
        if(!is_null($studio->min_booking_time)){
            $minBooking = explode('-',$studio->min_booking_time);
            $min_booking['min_days'] = $minBooking[0];
            $min_booking['min_hours'] = $minBooking[1];
            $min_booking['min_minutes'] = $minBooking[2];
        }

        $max_booking['max_days'] = 0;
        $max_booking['max_hours'] = 0;
        $max_booking['max_minutes'] = 0;
        if(!is_null($studio->max_booking_time)){
            $maxBooking = explode('-',$studio->max_booking_time);
            $max_booking['max_days'] = $maxBooking[0];
            $max_booking['max_hours'] = $maxBooking[1];
            $max_booking['max_minutes'] = $maxBooking[2];
        }

        return view("studio.studio-booking")->with(['locationId' => $locationId, 'studioId' => $studioId, 'studio_equipments' =>$studio_equipments, 'studio'=>$studio, 'min_booking' => $min_booking, 'max_booking' => $max_booking]); 
    }
	
	public function equipment_detail(Request $request)
    {
        $equipment_category = EquipmentCategory::pluck('cat_name','id');
        try{
            $data = null;
            if($request->has('lid') && $request->lid!=""){
                $data = Equipment::find($request->lid);
            }
            $content = view("studio.equipment-card")->with(['data'=>$data,'locationId'=>$request->locationId,'studioId'=>$request->studioId,'equipment_category'=>$equipment_category])->render();    
            return response()->json([ 
                'status' => true,
                'content' => $content,
            ], 200);
        }catch(\PDOException $pde ) {
            return response()->json([
                'status' => false,
                'error' => $pde->getMessage(),
            ], 422);
        }catch(\Exception $e){
            return response()->json([
                'status' => false,
                'error' => $e->getMessage(),
            ], 422);
        }
    }

    public function save_equipment(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'studioId' => 'required',
            'category' => 'required',
            'serial_number' => 'required',
            'manual_link' => 'nullable|url'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => false,
                'error' => $validator->errors()
            ], 422);
        }

        try {
            if ($request->equipmentid) {
                $data = Equipment::find($request->equipmentid);
                $msg = 'Studio updated successfully.';
            } else {
                $data = new Equipment;
                $msg = 'Studio created successfully.';
            }

            $data->manual = $request->manual;
            $data->manual_link = $request->manual_link;
			$data->receipt = $request->receipt;
			$data->name = $request->name;
            $data->studios_id = $request->studioId;
            $data->category = $request->category;
            $data->description = $request->description;
            $data->serial_number = $request->serial_number;
            $data->price = Helpers::convertCurrencyToUSD($request->price);
            $data->note = $request->note;
            $data->save();
            Session::flash('success',$msg);

            return response()->json([
                'status' => true,
                'message' => $msg,
            ], 200);
        } catch (\PDOException $pde) {
            return response()->json([
                'status' => false,
                'error' => $pde->getMessage(),
            ], 422);
        } catch (\Exception $e) {
            return response()->json([
                'status' => false,
                'error' => $e->getMessage(),
            ], 422);
        }
    }	
}
