<?php
namespace App\Http\Middleware;
use Carbon\Carbon; use Closure;
use App\Helpers, Session;

class CustomAuth
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if(Session::has('page_access') && !in_array(auth()->user()->role,['super-admin','admin'])){
            if (str_contains($request->url(), 'backend')) {
                $reqUrl = $request->url();
                $locationId = $request->route()->parameter('locationId');
                if(isset(Session::get('page_access')[$locationId])){
                    $isAccess = false;
                    $pages = explode(',',Session::get('page_access')[$locationId]);
                    foreach($pages as $page){
                        if (str_contains($reqUrl, $page)) {
                            $isAccess = true;
                            break;
                        }
                    }
                    if (!$isAccess) {
                        abort(403);
                    }
                }
            }
        }

        return $next($request);
    }
}
