<?php

namespace App\Http\Middleware;
use Closure, Session;

class UserRole
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $current_path = $request->path();
        $path_arr = explode('/',$current_path);
        
        if(auth()->user()->role_id==1 || $request->path()=='logout'){
            return $next($request);
        }else if(auth()->user()->role_id==2 && in_array($path_arr[0],config('clinical.user'))){
            return $next($request);
        }else{
            abort(403);
        }
        return $next($request);
    }
}
