<?php

namespace App\Models;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Booking extends Model
{
	protected $table = 'booking_master';
    protected $primaryKey = 'id';
	
    public function booking_by()
    {
        return $this->hasOne(User::class, 'uuid','uuid')->select('fname','lname','mobile_number','email','users.uuid');
    }
	
    function detail() {
        return $this->hasMany(BookingDetail::class, 'booking_id', 'booking_id');
    }

    function loc() {
        return $this->hasOne(Location::class, 'id', 'location_id');
    }

    function locLanding() {
        return $this->hasOne(LandingPage::class, 'location_id', 'location_id')->where('type','location');
    }

    function studios() {
        return $this->hasMany(BookingDetail::class, 'booking_id', 'booking_id')->where('type','studio')
        ->Join('studios','studios.id','studio_id')->Join('studio_types','studio_types.id','studio_type')
        ->select('studios.id','studios.name','studio_types.name as studioType','booking_details.booking_id','booking_details.id as detid','booking_details.status as detstatus');
    }
	function resources() {
        return $this->hasMany(BookingDetail::class, 'booking_id', 'booking_id')->where('type','resource')
        ->Join('users','users.id','resource_id')->Join('resource_types','resource_types.id','resource_type')
        ->select('users.id','fname','lname','resource_types.name','resource_types.id','booking_details.booking_id','booking_details.id as detid','booking_details.status as detstatus');
    }
    function rentals() {
        return $this->hasMany(BookingDetail::class, 'booking_id', 'booking_id')->where('type','rental')
        ->Join('equipments','equipments.id','equipment_id')->leftJoin('equipment_checkin as ch',function($join){
            $join->on('ch.equipment_id', '=', 'equipments.id')
            ->whereColumn('ch.booking_id', '=', 'booking_details.booking_id')
            ->where('ch.status', 0);
        })
        ->select('equipments.id','equipments.serial_number','name','booking_details.booking_id','booking_details.id as detid','booking_details.status as detstatus','ch.id as checkin_id');
    }
    function notes() {
        return $this->hasMany(BookingNote::class, 'booking_id', 'booking_id');
    }
	
}
