<?php

namespace App\Models;
use Illuminate\Database\Eloquent\Model;

class Schedule extends Model
{
    protected $table = 'schedules';
    protected $primaryKey = 'id';

    // Mutator: convert to 24-hour format before storing
    public function setStartTimeAttribute($value)
    {
        try {
            $this->attributes['start_time'] = \Carbon\Carbon::createFromFormat('h:i A', $value)->format('H:i:s');
        } catch (\Exception $e) {
            $this->attributes['start_time'] = $value; // fallback for raw 24-hour input
        }
    }

    // Accessor: (optional) convert back to 12-hour format on read
    // public function getStartTimeAttribute($value)
    // {
    //     if (!$value) return null;

    //     try {
    //         return \Carbon\Carbon::createFromFormat('H:i:s', $value)->format('h:i A');
    //     } catch (\Exception $e) {
    //         return $value; // fallback if format unexpected
    //     }
    // }

    // Mutator: convert to 24-hour format before storing
    public function setEndTimeAttribute($value)
    {
        try {
            $this->attributes['end_time'] = \Carbon\Carbon::createFromFormat('h:i A', $value)->format('H:i:s');
        } catch (\Exception $e) {
            $this->attributes['end_time'] = $value; // fallback for raw 24-hour input
        }
    }

    // Accessor: (optional) convert back to 12-hour format on read
    // public function getEndTimeAttribute($value)
    // {
    //     if (!$value) return null;

    //     try {
    //         return \Carbon\Carbon::createFromFormat('H:i:s', $value)->format('h:i A');
    //     } catch (\Exception $e) {
    //         return $value; // fallback if format unexpected
    //     }
    // }
}
