<?php

namespace App\Providers;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\View;
use Schema, DB;
class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Schema::defaultStringLength(191);
        $tags = [];
        $meta_tags = DB::table('seo_metatags')->where('active',1)->get();
        foreach($meta_tags as $tag){
            $tags[$tag->page_url] = $tag;
        }
        view::share('meta_tags', $tags);
        // view()->composer('partials.language_switcher', function ($view) {
        //     $view->with('current_locale', app()->getLocale());
        //     $view->with('available_locales', config('app.available_locales'));
        // });
    }
}
