<div class="position-relative">
    <div class="chat-messages p-4">
        @dump($messages)
        @foreach($messages as $msg)
            @if(auth()->user()->uuid == $msg['user']['user_id'])
            <div class="chat-message-right pb-4">
                <div>
                    <img src="https://bootdey.com/img/Content/avatar/avatar1.png" class="rounded-circle me-1" alt="Chris Wood" width="40" height="40">
                    <div class="text-muted small text-nowrap mt-2">{{date('Y-m-d H:i',$msg['created_at'])}}</div>
                </div>
                <div class="flex-shrink-1 bg-light rounded py-2 px-3 me-3" data-msgid="{{$msg['message_id']}}">
                    <div class="font-weight-bold mb-1">You</div>
                    {{$msg['message']}}
                </div>
            </div>
            @else
            <div class="chat-message-left pb-4">
                <div>
                    <img src="https://bootdey.com/img/Content/avatar/avatar3.png" class="rounded-circle me-1" alt="Sharon Lessman" width="40" height="40">
                    <div class="text-muted small text-nowrap mt-2">{{formatTimestamp($msg['created_at'])}}</div>
                </div>
                <div class="flex-shrink-1 bg-light rounded py-2 px-3 ms-3" data-msgid="{{$msg['message_id']}}">
                    <div class="font-weight-bold mb-1">{{$msg['user']['nickname']}}</div>
                    {{$msg['message']}}
                </div>
            </div>
            @endif
        @endforeach        
    </div>
</div>
<div class="flex-grow-0 py-3 px-4 border-top">
    <div class="input-group">
        <input type="text" class="form-control border chat-text" placeholder="Type your message">
        <button class="btn btn-primary">Send</button>
    </div>
</div>