var calendar;
var fetchDates = false;
var availableDates = [];
var months = [
    "January",
    "February",
    "March",
    "April",
    "May",
    "June",
    "July",
    "August",
    "September",
    "October",
    "November",
    "December",
];
function scheduleCalendarInit() {
    var calendarEl = document.getElementById("calendar");
    calendar = new FullCalendar.Calendar(calendarEl, {
        timeZone: "UTC",
        themeSystem: "bootstrap5",
        initialView: "listMonth",
        headerToolbar: {
            left: "today prev,next",
            center: "title",
            right: "listMonth,dayGridMonth,timeGridWeek,timeGridDay",
        },
        views: {
            listMonth: { buttonText: "Schedule" },
        },
        titleFormat: {
            year: "numeric",
            month: "short",
        },
        navLinks: true,
        selectable: true,
        nowIndicator: true,
        dayMaxEvents: true,
        editable: true,
        selectable: true,
        businessHours: false,
        dayMaxEvents: true,
        weekNumbers: false,
        dayMaxEvents: true,
        events: {
            url: APP_URL + "/calendar-sch-events",
            method: "POST",
            extraParams: function () {
                return {
                    _token: _token,
                    category: "schedule",
                    type: $("#type").val(),
                    refrence_id: $("#refrence_id").val(),
                    schedule_location: $("#schedule_location").val(),
                };
            },
            failure: function () {
                alert("there was an error while fetching events!");
            },
        },
        eventClick: function (info) {
            console.log(info.event.extendedProps);
            if (info.event.extendedProps.booking) {
                let startTime = info.event.start.toLocaleTimeString([], {
                    hour: "2-digit",
                    minute: "2-digit",
                    hour12: true,
                });
                let startDate =
                    info.event.start.getDay() +
                    " " +
                    months[info.event.start.getMonth()] +
                    " " +
                    info.event.start.getFullYear() +
                    " " +
                    startTime;
                let endTime = info.event.end.toLocaleTimeString([], {
                    hour: "2-digit",
                    minute: "2-digit",
                    hour12: true,
                });
                let endDate =
                    info.event.end.getDay() +
                    " " +
                    months[info.event.end.getMonth()] +
                    " " +
                    info.event.end.getFullYear() +
                    " " +
                    endTime;
                booking_html(startDate, endDate, info.event.extendedProps);
            } else {
                if (confirm("Are you sure want to update this schedule?")) {
                    let availtype = $('select[name="availability_type"]').val();
                    if (availtype == "1") {
                        $("#dailyAvailCont").show();
                        $("#recuAvailCont").hide();
                        $('select[name="availability_type"]').val(0);
                    }
                    $('select[name="availability_type"]').attr(
                        "disabled",
                        true
                    );
                    $("#schedule_id").val(info.event.id);
                    $("#schedule_location").val(
                        info.event.extendedProps.location_id
                    );
                    $('input[name="daily_daily_rate[0]"]').val(
                        info.event.extendedProps.daily_rate
                    );
                    $('input[name="daily_hourly_rate[0]"]').val(
                        info.event.extendedProps.hourly_rate
                    );
                    $('input[name="daily_start_date[0]"]').val(
                        info.event.extendedProps.start_date
                    );
                    $('input[name="daily_start_time[0]"]').val(
                        info.event.extendedProps.start_time
                    );
                    $('input[name="daily_end_time[0]"]').val(
                        info.event.extendedProps.end_time
                    );
                }
            }
        },
        eventDrop: function (info) {
            return false;
        },
    });
    calendar.render();
}
function reload_tab(tabId) {
    let currentUrl = window.location.href.split("#");
    window.location.href = currentUrl[0] + tabId;
    window.location.reload();
}
function cropperImageFunc(file, done, myDropZone, aRatio, iwidth, iheight) {
    // Create the image editor overlay
    let editor = document.createElement("div");
    editor.style.position = "fixed";
    editor.style.left = 0;
    editor.style.right = 0;
    editor.style.top = 0;
    editor.style.bottom = 0;
    editor.style.zIndex = 9999;
    editor.style.backgroundColor = "#000";
    document.body.appendChild(editor);
    // Create confirm button at the top left of the viewport
    let buttonConfirm = document.createElement("button");
    buttonConfirm.classList.add("btn");
    buttonConfirm.classList.add("btn-primary");
    buttonConfirm.style.position = "absolute";
    buttonConfirm.style.left = "10px";
    buttonConfirm.style.top = "10px";
    buttonConfirm.style.zIndex = 9999;
    buttonConfirm.textContent = "Confirm";
    editor.appendChild(buttonConfirm);
    buttonConfirm.addEventListener("click", function () {
        // Get the canvas with image data from Cropper.js
        let canvas = cropper.getCroppedCanvas({
            width: iwidth,
            height: iheight,
        });
        // Turn the canvas into a Blob (file object without a name)
        canvas.toBlob(function (blob) {
            // Create a new Dropzone file thumbnail
            myDropZone.createThumbnail(
                blob,
                myDropZone.options.thumbnailWidth,
                myDropZone.options.thumbnailHeight,
                myDropZone.options.thumbnailMethod,
                false,
                function (dataURL) {
                    // Update the Dropzone file thumbnail
                    myDropZone.emit("thumbnail", file, dataURL);
                    // Return the file to Dropzone
                    done(blob);
                }
            );
        });
        // Remove the editor from the view
        document.body.removeChild(editor);
    });
    // Create an image node for Cropper.js
    let image = new Image();
    image.src = URL.createObjectURL(file);
    editor.appendChild(image);

    // Create Cropper.js
    let cropper = new Cropper(image, {
        cropBoxResizable: true,
        aspectRatio: aRatio,
    });
}
function timer(remaining) {
    var m = Math.floor(remaining / 60);
    var s = remaining % 60;

    m = m < 10 ? "0" + m : m;
    s = s < 10 ? "0" + s : s;
    $(".otp-timer").html(m + ":" + s);
    remaining -= 1;

    if (remaining >= 0) {
        setTimeout(function () {
            timer(remaining);
        }, 1000);
        return;
    }

    $(".otp-timer").html('<a class="send-otp pointer">Send again</a>');
}

$(document).ready(function () {
    if ($(".timepicker").length > 0) {
        $(".timepicker").timepicker({
            interval: 15,
            startTime: "09:00am",
            defaultTime: "09:00am",
            dynamic: false,
            dropdown: true,
            scrollbar: true,
        });
    }
    if ($(".timepicker1").length > 0) {
        $(".timepicker1").timepicker({
            interval: 15,
            startTime: "05:00pm",
            defaultTime: "05:00pm",
            dynamic: false,
            dropdown: true,
            scrollbar: true,
        });
    }
    if ($(".stimepickerbook").length > 0) {
        $(".stimepickerbook").timepicker({
            interval: 15,
            startTime: "09:00am",
            //defaultTime: "09:00am",
            dynamic: false,
            dropdown: true,
            scrollbar: true,
        });
    }

    if ($(".etimepickerbook").length > 0) {
        $(".etimepickerbook").timepicker({
            interval: 15,
            startTime: "05:00pm",
            //defaultTime: "05:00pm",
            dynamic: false,
            dropdown: true,
            scrollbar: true,
        });
    }

    //open modal for guest
    $(document).on("click", ".clear-booking", function () {
        $.ajax({
            type: "POST",
            dataType: "json",
            data: { _token: _token },
            url: APP_URL + "/clear-booking",
            success: function (res) {
                if (res.status) {
                    $(".pending-booking").remove();
                }
            },
        });
    });
    $(document).on("click", ".invitedcard", function () {
        let id = $(this).data("id");
        $.ajax({
            type: "POST",
            dataType: "json",
            data: { _token: _token, upcoming_id: id },
            url: APP_URL + "/guest-data",
            success: function (res) {
                if (res.status) {
                    $("#guest_modal .md-container").html(res.content);
                    $("#guest_modal").modal("show");
                }
            },
            error: function (res) {
                ajax_error(res);
            },
        });
    });
    $(document).on("click", ".guestaction", function () {
        let status = $(this).data("status");
        let upcoming_id = $(this).data("id");
        $.ajax({
            type: "POST",
            dataType: "json",
            data: { _token: _token, upcoming_id: upcoming_id, status: status },
            url: APP_URL + "/invite-action",
            success: function (res) {
                if (res.status) {
                    window.location.reload();
                }
            },
            error: function (res) {
                ajax_error(res);
            },
        });
    });
    // open modal for email address
    if ($("#myemail").length > 0 && $("#myemail").val() == "") {
        setTimeout(function () {
            $("#general_modal .modal-title").html("Add Email Address");
            let htmlContent =
                "<p>Please add your email address for account recovery and notifications.</p>";
            htmlContent +=
                '<p><a class="btn btn-secondary" href="' +
                APP_URL +
                '/account-setting#security-tab">Add Email Address</button></p>';
            $("#general_modal .modal-body").html(htmlContent);
            $("#general_modal").modal("show");
        }, 1000);
    }
    // active tab on page load
    var navLinkId = window.location.hash;
    console.log(navLinkId);
    if (navLinkId != "") {
        if (navLinkId == "#calendar-tab") {
            var evt = document.createEvent("UIEvents");
            evt.initUIEvent("resize", true, false, window, 0);
            window.dispatchEvent(evt);
        }
        $("#borderedTab .nav-link, #borderedTab2 .nav-link").removeClass(
            "active"
        );
        $(navLinkId).addClass("active");
        let tabPanId = $(navLinkId).data("bs-target");
        $(
            "#borderedTabContent .tab-pane, #borderedTabContent2 .tab-pane"
        ).removeClass("active");
        $(tabPanId).addClass("show active");
    }
    // tab click
    // $(document).on('click', '#borderedTab2 .nav-link', function(e){
    //   let hashId = $(this).attr('id');
    //   console.log(hashId);
    //   window.location.hash = hashId;
    //   e.preventDefault();
    // });
    $(document).on("click", ".notificationBell", function () {
        //$('.notifications').toggleClass('show');
        if ($(".notificationBell .badge-number").length > 0) {
            $.ajax({
                type: "POST",
                dataType: "json",
                data: { _token: _token },
                url: APP_URL + "/read-notification",
                success: function (res) {
                    if (res.status) {
                        $(".notificationBell .badge-number").remove();
                    }
                },
                error: function (res) {
                    ajax_error(res);
                },
            });
        }
    });
    $(document).on("click", ".profileIcon", function () {
        //$('.profile').toggleClass('show');
    });

    $(document).on("click", ".lang-box", function () {
        let lang_code = $(this).data("code");
        window.location.href = APP_URL + "/language/" + lang_code;
    });
    $(document).on("click", ".dlteprofilepic", function () {
        let uuid = $(this).data("uuid");
        deleteprofilepic(uuid);
    });
    $(document).on("click", ".cur-box", function () {
        let cur_code = $(this).data("code");
        $.ajax({
            type: "POST",
            dataType: "json",
            data: { _token: _token, currency: cur_code },
            url: APP_URL + "/set-currency",
            success: function (res) {
                if (res.status) {
                    window.location.reload();
                }
            },
            error: function (res) {
                ajax_error(res);
            },
        });
    });

    $(document).on("click", ".btnappaction", function () {
        let obj = $(this);
        obj.children(".spinner-border").show();
        let uuid = $("#user_uuid").val();
        let type = $(this).data("type");
        let action = $(this).data("action");
        $.ajax({
            type: "POST",
            dataType: "json",
            data: { _token: _token, uuid: uuid, action: action },
            url: APP_URL + "/user-app-action",
            success: function (res) {
                obj.children(".spinner-border").hide();
                if (res.status) {
                    if (type == "app") {
                        if (action == 2) {
                            $(".usraction, ." + uuid).html(
                                '<span class="txtApproved">Approved</span>'
                            );
                        } else if (action == 3) {
                            $(".usraction, ." + uuid).html(
                                '<span class="txtDenied">Denied</span>'
                            );
                        }
                    } else if (type == "muser") {
                        if (action == 2) {
                            $(".txt-status").html(
                                '<span class="txtApproved">Approved</span>'
                            );
                        } else if (action == 4) {
                            $(".txt-status").html(
                                '<span class="txtDenied">Suspended</span>'
                            );
                        } else if (action == 5) {
                            $(".txt-status").html(
                                '<span class="txtDenied">Blocked</span>'
                            );
                        }
                        obj.attr("disabled", true);
                    }
                }
            },
            error: function (res) {
                obj.children(".spinner-border").hide();
                ajax_error(res);
            },
        });
    });

    $(document).on("click", "#btn_delete", function () {
        let obj = $(this);
        obj.attr("disabled", true);
        let did = obj.data("did");
        let type = obj.data("type");
        $.ajax({
            type: "POST",
            dataType: "json",
            data: { _token: _token, type: type, did: did },
            url: APP_URL + "/remove-action",
            success: function (res) {
                obj.attr("disabled", false);
                if (res.status) {
                    $("#alertMsg .pagemsgcontent").html(
                        '<div class="alert alert-success">' +
                            res.message +
                            "</div>"
                    );
                    $("#alertMsg").modal("show");
                    window.location.reload();
                }
            },
            error: function (res) {
                obj.attr("disabled", false);
                ajax_error(res);
            },
        });
    });

    $(document).on("click", ".searchicon", function () {
        let search = $("#search_field").val();
        let current_href = window.location.href;
        let href_arr = current_href.split("?");
        if ($.trim(search) != "") {
            window.location.href = href_arr[0] + "?name=" + search;
        }
    });

    $(document).on("change", 'select[name="location"]', function () {
        let location = $(this).val();
        if (location == "") {
            $('select[name="role"]').html("").selectpicker("refresh");
            return false;
        }
        if (location == "all") {
            $('select[name="role"]').selectpicker("destroy");
            $('select[name="role"]').prop("multiple", false);
            $('select[name="role"]').selectpicker();
        } else {
            $('select[name="role"]').selectpicker("destroy");
            $('select[name="role"]').prop("multiple", "true");
            $('select[name="role"]').selectpicker();
        }

        let user_uuid = $("#user_uuid").val();
        $.ajax({
            type: "POST",
            dataType: "json",
            data: { _token: _token, uuid: user_uuid, location: location },
            url: APP_URL + "/userroles",
            success: function (res) {
                if (res.status) {
                    $('select[name="role"]')
                        .html(res.content)
                        .selectpicker("refresh");
                }
            },
            error: function (res) {
                ajax_error(res);
            },
        });
    });

    $(document).on("keyup", "#txt_email", function () {
        let search_text = $(this).val();
        var re = /([A-Z0-9a-z_-][^@])+?@[^$#<>?]+?\.[\w]{2,4}/.test(
            search_text
        );
        if (re) {
            $.ajax({
                type: "POST",
                dataType: "json",
                data: { _token: _token, search_text: search_text },
                url: APP_URL + "/search-user",
                success: function (res) {
                    if (res.status && res.uuid != "") {
                        $("#user_uuid").val(res.uuid);
                        $("#btn_addpoints").prop("disabled", false);
                    } else {
                        $("#btn_addpoints").prop("disabled", true);
                    }
                },
                error: function (res) {
                    $("#btn_addpoints").prop("disabled", true);
                    ajax_error(res);
                },
            });
        }
    });

    $(document).on("click", "#btn_addpoints", function () {
        let user_uuid = $("#user_uuid").val();
        if (user_uuid == "") {
            $("#alertMsg .pagemsgcontent").html(
                '<div class="alert alert-danger">User not available with this email.</div>'
            );
            $("#alertMsg").modal("show");
            return false;
        }
        let points = $('input[name="points"]').val();
        if (points == "") {
            $("#alertMsg .pagemsgcontent").html(
                '<div class="alert alert-danger">Points can not be blank.</div>'
            );
            $("#alertMsg").modal("show");
            return false;
        }
        let obj = $(this);
        obj.attr("disabled", true);
        $.ajax({
            type: "POST",
            dataType: "json",
            data: { _token: _token, user_uuid: user_uuid, points: points },
            url: APP_URL + "/add-points",
            success: function (res) {
                obj.attr("disabled", false);
                if (res.status) {
                    $("#alertMsg .pagemsgcontent").html(
                        '<div class="alert alert-success">' +
                            res.message +
                            "</div>"
                    );
                    $("#alertMsg").modal("show");
                    if (
                        $("#page").length > 0 &&
                        $("#page").html() == "account-setting"
                    ) {
                        window.location.reload();
                    }
                }
            },
            error: function (res) {
                obj.attr("disabled", false);
                ajax_error(res);
            },
        });
    });

    $(document).on("keyup", "#txt_points", function () {
        let points_per_usd = $("#points_per_usd").val();
        let points = $(this).val();
        if (points == "") {
            points = 0;
        }
        let amount = points / points_per_usd;
        $("#txt_amount").html("$" + amount);
        if (amount > 0) {
            $("#btn_buypoints").prop("disabled", false);
        } else {
            $("#btn_buypoints").prop("disabled", true);
        }
    });

    $(document).on("click", "#btn_buypoints", function () {
        let payment_method = $("#payment_method").val();
        let txt_points = $("#txt_points").val();
        if (txt_points == "" || txt_points == 0 || payment_method == "") {
            $("#alertMsg .pagemsgcontent").html(
                '<div class="alert alert-danger">Please fill the required fields.</div>'
            );
            $("#alertMsg").modal("show");
            return false;
        }

        $.ajax({
            type: "POST",
            dataType: "json",
            data: {
                _token: _token,
                token: payment_method,
                points: txt_points,
            },
            url: APP_URL + "/process-buy-more-points",
            success: function (res) {
                if (res.status) {
                    $("#otp_modal").modal("hide");
                    $("#alertMsg .pagemsgcontent").html(
                        '<div class="alert alert-success">Payment captured successfully</div>'
                    );
                    $("#alertMsg").modal("show");
                }
            },
            error: function (res) {
                ajax_error(res);
            },
        });
    });

    $(document).on("click", ".delete-record", function () {
        let del_url = $(this).data("url");
        if (del_url == "") {
            return false;
        }
        $("#confirm_action").data("url", del_url);
        $("#confirmBox").modal("show");
    });

    $("#delparticipants").submit(function (event) {
        event.preventDefault();

        $("#confirmBox").modal("show");

        $(document).on("click", "#confirm_action", function () {
            $("#delparticipants").off("submit").submit();
        });
    });

    $(document).on("click", "#confirm_action", function () {
        let del_url = $(this).data("url");
        window.location.href = del_url;
    });

    // calendar actions js
    $(document).on("click", "#schedule_reset", function () {
        $("#schedule_id").val("");
        $("#edit_schedule_type").val("");
        $('select[name="availability_type"]').attr("disabled", false);
        $('input[name^="daily_daily_rate"]').val("");
        $('input[name^="daily_hourly_rate"]').val("");
        $('input[name^="daily_start_date"]').val("");
        $('input[name^="daily_start_time"]').val("");
        $('input[name^="daily_end_time"]').val("");
    });
    $(document).on("click", "#add_daily_click", function () {
        if ($("#schedule_id").val() != "") {
            return false;
        }
        let time = new Date().getTime();
        let daily_rate = $("#daily_rate").val();
        let hourly_rate = $("#hourly_rate").val();
        let dailyHtml =
            "<tr>" +
            '<td><input name="daily_start_date[' +
            time +
            ']" type="date" class="form-control" style="width:100px;" data-index="' +
            time +
            '" onkeyup="validateDateTime(' +
            time +
            ')"></td>' +
            '<td><input name="daily_start_time[' +
            time +
            ']" type="text" class="form-control timepicker" placeholder="Start time" readonly data-index="' +
            time +
            '" onkeyup="validateDateTime(' +
            time +
            ')"></td>' +
            '<td><input name="daily_end_time[' +
            time +
            ']" type="text" class="form-control timepicker" placeholder="End time" readonly data-index="' +
            time +
            '" onkeyup="validateDateTime(' +
            time +
            ')"></td>' +
            '<td><input name="daily_daily_rate[' +
            time +
            ']" type="number" class="form-control" placeholder="0" value="' +
            daily_rate +
            '"></td>' +
            '<td><input name="daily_hourly_rate[' +
            time +
            ']" type="number" class="form-control" placeholder="0" value="' +
            hourly_rate +
            '"></td>' +
            '<td><i class="bi bi-trash daily-trash f20"></i></td>' +
            "</tr>";
        $("#daily_container").append(dailyHtml);
        $(".timepicker").timepicker({
            interval: 15,
            dynamic: false,
            dropdown: true,
            scrollbar: true,
        });
    });

    $(document).on("change", "#schedule_location", function () {
        if ($("#schedule_id").val() == "") {
            //load_calendar_events();
            calendar.refetchEvents();
        }
    });
    $(document).on("change", 'select[name="availability_type"]', function () {
        if ($(this).val() == "0") {
            $("#dailyAvailCont").show();
            $("#recuAvailCont").hide();
        } else if ($(this).val() == "1") {
            $("#dailyAvailCont").hide();
            $("#recuAvailCont").show();
        }
    });
    $(document).on("click", ".add-recurring-days", function () {
        let day = $(this).data("day");
        recurring_row(day);
    });
    $(document).on("click", ".daily-trash", function () {
        let schedule_id = $("#schedule_id").val();
        if (schedule_id != "") {
            let del_recurring = false;
            let event = calendar.getEventById(schedule_id);
            console.log(event);
            if (event.extendedProps.schedule_type == "recurring") {
                if (
                    confirm(
                        "Same should apply on all recurring event of this slot?"
                    )
                ) {
                    del_recurring = true;
                }
            }
            $.ajax({
                type: "POST",
                dataType: "json",
                data: {
                    _token: _token,
                    schedule_id: schedule_id,
                    recurring: del_recurring,
                },
                url: APP_URL + "/calendar-delete-sch-events",
                success: function (res) {
                    if (res.status) {
                        window.location.reload();
                    }
                },
                error: function (res) {
                    ajax_error(res);
                },
            });
        } else {
            $(this).parent().parent().remove();
        }
    });
    $(document).on("click", "#schedule_save", function () {
        let schedule_id = $("#schedule_id").val();
        if (schedule_id != "") {
            let event = calendar.getEventById(schedule_id);
            if (event.extendedProps.schedule_type == "recurring") {
                if (
                    confirm(
                        "Same should apply on all recurring event of this slot?"
                    )
                ) {
                    $("#edit_schedule_type").val("recurring");
                }
            }
        }
        save_schedule();
    });

    $(document).on("click", "#btn_booking_continue", function () {
        console.log($('input[name="booking_studio"]:checked').length);
        if ($(this).data("type") == "studio") {
            if ($('input[name="booking_studio"]:checked').length == 0) {
                alert("Please select studio to proceed.");
                return false;
            }
        } else if ($(this).data("type") == "equipment") {
            if ($('input[name="booking_equipment"]:checked').length == 0) {
                alert("Please select equipment to proceed.");
                return false;
            }
        } else if ($(this).data("type") == "resource") {
            if ($('input[name="booking_resource"]:checked').length == 0) {
                alert("Please select resource to proceed.");
                return false;
            }
        }

        window.location.href = $(this).data("redirect");
    });

    $(document).on(
        "click",
        'input[name="booking_studio"], input[name="booking_equipment"], input[name="booking_resource"]',
        function () {
            let typeId = $(this).val();
            let type = $(this).data("type");
            let days = $(this).data("days");
            let hours = $(this).data("hours");
            let day_hours = "";
            if (days > 0) {
                day_hours += days + "D ";
            }
            day_hours += hours + "H";
            $("#days_hours").html(day_hours);
            make_selection(type, typeId);
        }
    );

    function make_selection(type, id) {
        $("#txt_price_container").html(
            '<div class="text-center"><div class="spinner-border" role="status"><span class="visually-hidden">Loading...</span></div></div>'
        );
        $.ajax({
            type: "POST",
            dataType: "json",
            data: { _token: _token, type: type, id: id },
            url: APP_URL + "/make-selection",
            success: function (res) {
                $("#txt_price_container").html(res.content);
            },
            error: function (res) {
                $("#txt_price_container").html("");
                ajax_error(res);
            },
        });
    }

    $(document).on("click", ".check-availability", function () {
        // destroy datepicker if available
        if (!$(".availability-calendar").data("datepicker")) {
            $(".availability-calendar").datepicker("destroy");
        }

        // initialize datepicker
        updateAvailableDates("", "").then((result) => {
            $(".availability-calendar").datepicker({
                inline: true,
                //'multidate':2,
                startDate: "now",
                beforeShowDay: function (date) {
                    let dmy =
                        date.getFullYear() +
                        "-" +
                        ("0" + (date.getMonth() + 1)).slice(-2) +
                        "-" +
                        ("0" + date.getDate()).slice(-2);
                    if ($.inArray(dmy, availableDates) != -1) {
                        return { classes: "highlight" };
                    } else {
                        return false;
                    }
                },
            });
            //$('.availability-calendar').on('changeMonth', handleMonthChange);
        });
    });

    $(document).on("click", "#btn_booking_form", function () {
        if ($("#bookingForm").valid()) {
            $("#btn_booking .spinner").show();
            $.ajax({
                type: "POST",
                dataType: "json",
                data: $("#bookingForm").serialize(),
                url: APP_URL + "/booking-form",
                success: function (res) {
                    $("#btn_booking .spinner").hide();
                    if (res.status) {
                        window.location.href = APP_URL + res.redirect;
                    }
                },
                error: function (res) {
                    $("#btn_booking .spinner").hide();
                    ajax_error(res);
                },
            });
        }
    });

    $("#bookingForm").validate({
        rules: {
            txt_location: {
                required: true,
            },
            txt_start_date: {
                required: true,
            },
            txt_start_time: {
                required: true,
            },
            txt_end_date: {
                required: true,
            },
            txt_end_time: {
                required: true,
            },
        },
        errorElement: "span",
        errorPlacement: function (error, element) {
            error.addClass("invalid-feedback float-start");
            element.closest(".col-md-2").append(error);
        },
        highlight: function (element, errorClass, validClass) {
            $(element).addClass("is-invalid");
        },
        unhighlight: function (element, errorClass, validClass) {
            $(element).removeClass("is-invalid");
        },
    });

    $(document).on("click", ".cancel-booking", function () {
        let obj = $(this);
        let id = obj.data("booking");
        obj.attr("disabled", true);
        if (confirm("Are you sure want to cancel this booking?")) {
            $.ajax({
                type: "POST",
                dataType: "json",
                data: { _token: _token, booking: id },
                url: APP_URL + "/booking-cancelled",
                success: function (res) {
                    window.location.reload();
                },
                error: function (res) {
                    ajax_error(res);
                },
            });
        } else {
            obj.attr("disabled", false);
        }
    });

    $(document).on("click", ".mark-complete", function () {
        let obj = $(this);
        let id = obj.data("booking");
        obj.attr("disabled", true);
        if (confirm("Are you sure want to complete this booking?")) {
            $.ajax({
                type: "POST",
                dataType: "json",
                data: { _token: _token, booking: id },
                url: APP_URL + "/booking-completed",
                success: function (res) {
                    window.location.reload();
                },
                error: function (res) {
                    ajax_error(res);
                },
            });
        } else {
            obj.attr("disabled", false);
        }
    });

    $(document).on("click", ".reset-key", function () {
        let id = $(this).data("id");
        let type = $(this).data("type");
        let num = $(this).data("num");
        $.ajax({
            type: "POST",
            dataType: "json",
            data: { _token: _token, id: id, type: type, num: num },
            url: APP_URL + "/reset-stream-key",
            success: function (res) {
                if (res.status) {
                    window.location.reload();
                }
            },
            error: function (res) {
                ajax_error(res);
            },
        });
    });

    $(document).on("click", ".goingevent", function () {
        let eventId = $(this).data("event");
        let guestId = 0;
        if (typeof guestId !== "undefined") {
            guestId = $(this).data("guest");
        }
        $.ajax({
            type: "POST",
            dataType: "json",
            data: { _token: _token, event_id: eventId, guest_id: guestId },
            url: APP_URL + "/going-event",
            success: function (res) {
                if (res.status) {
                    window.location.reload();
                } else {
                    $("#general_modal .modal-title").html(
                        "Recharge your wallet"
                    );
                    $("#general_modal .modal-body").html(res.content);
                    $("#general_modal").modal("show");
                }
            },
            error: function (res) {
                ajax_error(res);
            },
        });
    });

    $(document).on("click", ".buypoints", function () {
        $.ajax({
            type: "POST",
            dataType: "json",
            data: { _token: _token },
            url: APP_URL + "/buy-more-points",
            success: function (res) {
                if (res.status) {
                    $("#otp_modal").html(res.content).modal("show");
                }
            },
            error: function (res) {
                ajax_error(res);
            },
        });
    });

    $(document).on("click", ".galimgdel", function () {
        let obj = $(this);
        let id = $(this).data("id");
        let lpid = $("#lpid").val();
        let type = $(this).data("type");
        $.ajax({
            type: "POST",
            dataType: "json",
            data: { _token: _token, id: id, lpid: lpid, type: type },
            url: APP_URL + "/gallery-image-delete",
            success: function (res) {
                if (res.status) {
                    obj.parent().remove();
                }
            },
            error: function (res) {
                ajax_error(res);
            },
        });
    });

    $(document).on("click", ".enlarge-image", function () {
        let src = $(this).attr("src");
        $("#enlargedImage").attr("src", src);
        $("#enlargeImageModal").modal("show");
        console.log(1111);
    });
});

function view_guest(obj) {
    $(".gridcard").removeClass("col-xl-12").addClass("col-xl-7");

    let picurl;
    let hpic = obj.data("hpic");
    if (hpic) {
        picurl = APP_URL + "/storage/profile-pic/" + hpic;
    } else {
        picurl = APP_URL + "/images/user-img.png";
    }
    $("#upcomingid").val(obj.data("id"));
    $("#hpic").attr("src", picurl);
    $("#gname").html(obj.data("gfname") + " " + obj.data("glname"));
    $("#gemail").html(obj.data("gemail"));
    $("#hname").html(obj.data("hfname") + " " + obj.data("hlname"));
    $("#invdate").html(
        obj.data("invitation-date") + " " + obj.data("invitation-time")
    );
    $("#ulocation").html(obj.data("location"));
    let statusHtml;
    let status = obj.data("status");
    if (status == 0) {
        statusHtml =
            '<div class="col-md-6"><input type="button" class="btn btn-danger invaction w-100 mb-2" data-status="2" value="Cancel Invitation" /></div><div class="col-md-6"><input type="button" class="btn btn-dark invaction w-100 mb-2" data-status="1" value="CheckIn" /></div>';
    } else if (status == 1) {
        statusHtml =
            '<div class="col-md-6"><input type="button" class="btn btn-danger invaction w-100 mb-2" data-status="2" value="Cancel Invitation" /></div>';
    } else if (status == 2) {
        statusHtml =
            '<div class="col-md-6"><input type="button" class="btn btn-dark invaction w-100 mb-2" data-status="0" value="Invite Again" /></div>';
    }
    $(".actionbtns").html(statusHtml);
    $(".user-card").show();
}
function handleMonthChange(e) {
    // Get the selected month and year
    let selectedMonth = ("0" + (e.date.getMonth() + 1)).slice(-2);
    let selectedYear = e.date.getFullYear();

    // Log the selected month and year (you can replace this with your logic)
    console.log(
        "Month changed to: " + selectedMonth + " Year: " + selectedYear
    );
    fetchDates = true;
    // updateAvailableDates(selectedMonth, selectedYear).then(result => {
    //   console.log(result);
    //   // Set the new available dates
    //   if(availableDates.length>0){
    //     $('.availability-calendar').datepicker('setDates', availableDates);
    //   }
    // });
}

async function updateAvailableDates(month, year) {
    return await getAvailableDates(month, year);
}

function getAvailableDates(month, year) {
    let selection = $(".availability-calendar").data("id");
    let selection_type = $(".availability-calendar").data("type");
    return new Promise((resolve, reject) => {
        $.ajax({
            type: "POST",
            dataType: "json",
            data: {
                _token: _token,
                selection_type: selection_type,
                selection: selection,
                month: month,
                year: year,
            },
            url: APP_URL + "/check-availability",
            success: function (res) {
                console.log("updating");
                availableDates = res.available_dates;
                resolve(availableDates);
            },
        });
    });
}

function save_schedule() {
    let error = false;
    let avail_type = $('select[name="availability_type"]').val();
    if (avail_type == 0) {
        $(
            'input[name^="daily_start_time"], input[name^="daily_end_time"], input[name^="daily_daily_rate"], input[name^="daily_hourly_rate"]'
        ).each(function () {
            if ($.trim($(this).val()) == "") {
                $(this).addClass("border-error");
                error = true;
            } else {
                $(this).removeClass("border-error");
            }
        });
    } else if (avail_type == 1) {
        $(".recurrchk:checked").each(function () {
            let daynum = $(this).data("day");
            $(
                "input[name='recurring_start_time[" +
                    daynum +
                    "][]'], input[name='recurring_end_time[" +
                    daynum +
                    "][]'], input[name='recurring_daily_rate[" +
                    daynum +
                    "][]'], input[name='recurring_hourly_rate[" +
                    daynum +
                    "][]']"
            ).each(function () {
                if ($(this).val() == "") {
                    $(this).addClass("border-error");
                    error = true;
                }
            });
        });
    }

    if (!error) {
        $.ajax({
            type: "POST",
            dataType: "json",
            data: $("#scheduleCalendar").serialize(),
            url: APP_URL + "/calendar-upsert-sch",
            success: function (res) {
                if (res.status) {
                    window.location.reload();
                }
            },
            error: function (res) {
                ajax_error(res);
            },
        });
    }
}

function booking_html(startDate, endDate, obj) {
    console.log(obj);
    window.location.href = APP_URL + "/booking-detail/" + obj.booking_id;
    return;

    $("#createplanner .modal-header").css(
        "border-top",
        "5px solid " + obj.bgcolor
    );
    let modal_html =
        '<table class="table table-borderless" id="tbl_boolingdtls">' +
        "<tbody>" +
        '<tr><td><div class="text-uppercase">Date</div><b id="book_datetime">' +
        startDate +
        " - " +
        endDate +
        "</b></td></tr>";
    if (obj.type == "studio") {
        modal_html +=
            '<tr><td><div class="text-uppercase">Studio</div><b id="book_studio_type">' +
            obj.studio_name +
            "</b></td></tr>";
        modal_html +=
            '<tr><td><div class="text-uppercase">Type of Studio</div><b id="book_studio_type">' +
            obj.studio_type +
            "</b></td></tr>";
    }
    if (obj.type == "rental") {
        modal_html +=
            '<tr><td><div class="text-uppercase">Equipment</div> <b id="book_equipments">' +
            obj.equipments +
            "</b></td></tr>";
    }
    if (obj.type == "resource") {
        modal_html +=
            '<tr><td><div class="text-uppercase">Resource</div><b id="book_resources">' +
            obj.resource_name +
            "</b></td></tr>";
        modal_html +=
            '<tr><td><div class="text-uppercase">Resource Type</div><b id="book_resources">' +
            obj.resource_type +
            "</b></td></tr>";
    }
    modal_html +=
        '<tr><td><div class="text-uppercase">Client</div> <b id="book_client_name">' +
        obj.client_name +
        "</b>" +
        '<div class="row mt-2">' +
        '<div class="col-md-6">' +
        '<small>Phone</small><br/><small id="book_client_phone">' +
        obj.client_phone +
        "</small>" +
        "</div>" +
        '<div class="col-md-6">' +
        '<small>Email</small><br/><small id="book_client_email">' +
        obj.client_email +
        "</small>" +
        "</div>" +
        "</div>" +
        "</td></tr>" +
        "<tr>" +
        '<td colspan="1">' +
        '<table class="table table-borderless" style="border-top:1px solid;">' +
        "<tbody>" +
        '<tr><td colspan="2"></td></tr>' +
        "<tr>" +
        "<td><b>Booking Cost</b></td>" +
        '<td><b id="book_points">' +
        obj.total_points +
        "</b> <b>pts</b></td>" +
        "</tr>" +
        "<tr>" +
        '<td colspan="2">' +
        '<div class="text-center mt-4">';
    if (obj.booking_status == 1) {
        modal_html += "<p><b>Booking completed</b></p>";
    } else if (obj.booking_status == 2) {
        modal_html += "<p><b>Booking canceled</b></p>";
    } else {
        modal_html +=
            '<button type="button" class="btn btn-dark" onclick="updateStatus(' +
            obj.booking_detail_id +
            ', 2)">Cancel booking</button>' +
            '<button type="button" class="btn btn-primary ms-2" onclick="updateStatus(' +
            obj.booking_detail_id +
            ', 1)" >Make as completed</button>';
    }
    modal_html +=
        "</div>" +
        "</td>" +
        "</tr>" +
        "</tbody>" +
        "</table>" +
        "</td>" +
        "</tr>" +
        "</tbody>" +
        "</table>";
    $("#book_modal").html(modal_html);
    $("#createplanner").modal("show");
}

function updateStatus(bookingDetailId, status) {
    $.ajax({
        type: "POST",
        url: "/booking/mark/" + bookingDetailId + "/" + status,
        data: { _token: _token },
        success: function (response) {
            console.log(response);
            $(".btn-dark, .btn-primary").remove();
            var message =
                status === 2 ? "Booking canceled" : "Booking completed";
            $(".text-center").html(
                '<p class="alert alert-success">' + message + "</p>"
            );
        },
        error: function (error) {
            ajax_error(res);
        },
    });
}

function OTPInput() {
    $(".otp-input").on("input", function () {
        var $this = $(this);
        if ($this.val().length == $this.attr("maxlength")) {
            var nextInput = $this.next(".otp-input");
            if (nextInput.length) {
                nextInput.focus();
            }
        }
    });

    $(".otp-input").on("keydown", function (e) {
        var $this = $(this);
        if (e.key === "Backspace" && $this.val() === "") {
            var prevInput = $this.prev(".otp-input");
            if (prevInput.length) {
                prevInput.focus();
            }
        }
    });

    $(".otp-input").on("paste", function (e) {
        var pasteData = e.originalEvent.clipboardData.getData("text");
        var inputs = $(".otp-input");
        for (var i = 0; i < pasteData.length; i++) {
            $(inputs[i]).val(pasteData[i]);
        }
        e.preventDefault();
    });
}

function deleteprofilepic(uuid) {
    $.ajax({
        type: "POST",
        dataType: "json",
        data: { _token: _token, uuid: uuid },
        url: APP_URL + "/remove-profile-picture",
        success: function (res) {
            if (res.status) {
                window.location.href = APP_URL + "/profile-picture";
            }
        },
        error: function (res) {
            ajax_error(res);
        },
    });
}

function event_action(obj, eventId, type) {
    $.ajax({
        type: "POST",
        url: APP_URL + "/event/" + type + "/" + eventId,
        data: { _token: _token },
        success: function (res) {
            obj.disabled = true;
            if ($("#" + type + "_count").length > 0) {
                let count = parseInt($("#" + type + "_count").html());
                $("#" + type + "_count").html(count + 1);
            }
            $("#alertMsg .pagemsgcontent").html(
                '<div class="alert alert-success">' + res.message + "</div>"
            );
            $("#alertMsg").modal("show");
        },
        error: function (error) {
            ajax_error(res);
        },
    });
}

function ajax_error(data) {
    let errors = "<ul>";
    if (typeof data.responseJSON.error === "string") {
        errors += "<li>" + data.responseJSON.error + "</li>";
    } else {
        for (datos in data.responseJSON.error) {
            console.log(data.responseJSON.error);
            errors += "<li>" + data.responseJSON.error[datos] + "</li>";
        }
    }
    errors += "</ul>";
    $("#alertMsg .pagemsgcontent").html(
        '<div class="alert alert-danger">' + errors + "</div>"
    );
    $("#alertMsg").modal("show");
}

function validateEmail(emailField) {
    var reg = /^([A-Za-z0-9_\-\.])+\@([A-Za-z0-9_\-\.])+\.([A-Za-z]{2,4})$/;
    if (reg.test(emailField.value) == false) {
        return false;
    }
    return true;
}

function share(id) {
    if (navigator.share) {
        navigator
            .share({
                title: "NOMADIC STUDIOS",
                text: "Check out this Event!",
                url: APP_URL + "/view-event/" + id,
            })
            .then(() => console.log("Successful share"))
            .catch((error) => console.log("Error sharing:", error));
    } else {
        alert(
            "Sharing is not supported on this browser. You can manually copy the link."
        );
    }
}

function gallery_images(location_type, image_type, refid, containerId) {
    $.ajax({
        type: "POST",
        dataType: "json",
        data: {
            _token: _token,
            location_type: location_type,
            image_type: image_type,
            refid: refid,
        },
        url: APP_URL + "/gallery-images",
        success: function (res) {
            if (res.status) {
                $("#" + containerId).html(res.content);
            }
        },
        error: function (res) {
            ajax_error(res);
        },
    });
}

function carousel_images(containerId, page, section) {
    $.ajax({
        type: "POST",
        dataType: "json",
        data: { _token: _token, page: page, section: section },
        url: APP_URL + "/carousel-images",
        success: function (res) {
            if (res.status) {
                $("#" + containerId).html(res.content);
            }
        },
        error: function (res) {
            ajax_error(res);
        },
    });
}

function convertDateTime(txt_date, txt_time) {
    let date = new Date(txt_date + " " + txt_time);
    return date;
}
function validateDateTime(index) {
    if (
        $("input[name='daily_start_date[" + index + "]']").val() != "" &&
        $("input[name='daily_start_time[" + index + "]']").val() != "" &&
        $("input[name='daily_end_time[" + index + "]']").val() != ""
    ) {
        let cur_start_date = $(
            "input[name='daily_start_date[" + index + "]']"
        ).val();
        let cur_start_time = $(
            "input[name='daily_start_time[" + index + "]']"
        ).val();
        let cur_end_time = $(
            "input[name='daily_end_time[" + index + "]']"
        ).val();
        let startDateObj = convertDateTime(
            cur_start_date,
            cur_start_time
        ).getTime();
        let endDateObj = convertDateTime(
            cur_start_date,
            cur_end_time
        ).getTime();
        if (endDateObj <= startDateObj) {
            $(
                "input[name='recurring_start_time[" + day + "][" + index + "]']"
            ).val("");
            $(
                "input[name='recurring_end_time[" + day + "][" + index + "]']"
            ).val("");
            return false;
        }

        let input_index = $("input[name^='daily_start_date']")
            .map(function () {
                return $(this).data("index");
            })
            .get();
        let start_date = $("input[name^='daily_start_date']")
            .map(function () {
                return $(this).val();
            })
            .get();
        let start_time = $("input[name^='daily_start_time']")
            .map(function () {
                return $(this).val();
            })
            .get();
        let end_time = $("input[name^='daily_end_time']")
            .map(function () {
                return $(this).val();
            })
            .get();

        for (let i = 0; i < start_date.length; i++) {
            if (
                input_index[i] != index &&
                start_time[i] != "" &&
                end_time[i] != ""
            ) {
                let arrStartDateObj = convertDateTime(
                    start_date[i],
                    start_time[i]
                ).getTime();
                let arrEndDateObj = convertDateTime(
                    start_date[i],
                    end_time[i]
                ).getTime();
                if (
                    (startDateObj <= arrStartDateObj &&
                        arrStartDateObj <= endDateObj) ||
                    (startDateObj <= arrEndDateObj &&
                        arrEndDateObj <= endDateObj) ||
                    (startDateObj >= arrStartDateObj &&
                        startDateObj <= arrEndDateObj)
                ) {
                    $("input[name='daily_start_time[" + index + "]']").val("");
                    $("input[name='daily_end_time[" + index + "]']").val("");
                    break;
                }
            }
        }
    }
}
function validateDateTimeRecu(day, index) {
    if (
        $(
            "input[name='recurring_start_time[" + day + "][" + index + "]']"
        ).val() != "" &&
        $(
            "input[name='recurring_end_time[" + day + "][" + index + "]']"
        ).val() != ""
    ) {
        let cur_start_time = $(
            "input[name='recurring_start_time[" + day + "][" + index + "]']"
        ).val();
        let cur_end_time = $(
            "input[name='recurring_end_time[" + day + "][" + index + "]']"
        ).val();
        let startDateObj = convertDateTime(
            "2023-11-15",
            cur_start_time
        ).getTime();
        let endDateObj = convertDateTime("2023-11-15", cur_end_time).getTime();
        if (endDateObj <= startDateObj) {
            $(
                "input[name='recurring_start_time[" + day + "][" + index + "]']"
            ).val("");
            $(
                "input[name='recurring_end_time[" + day + "][" + index + "]']"
            ).val("");
            return false;
        }
        let input_index = $("input[name^='recurring_start_time[" + day + "]']")
            .map(function () {
                return $(this).data("index");
            })
            .get();
        let start_time = $("input[name^='recurring_start_time[" + day + "]']")
            .map(function () {
                return $(this).val();
            })
            .get();
        let end_time = $("input[name^='recurring_end_time[" + day + "]']")
            .map(function () {
                return $(this).val();
            })
            .get();
        console.log(start_time);
        console.log(end_time);
        console.log(input_index);
        console.log(index);
        for (let i = 0; i < start_time.length; i++) {
            if (
                input_index[i] != index &&
                start_time[i] != "" &&
                end_time[i] != ""
            ) {
                let arrStartDateObj = convertDateTime(
                    "2023-11-15",
                    start_time[i]
                ).getTime();
                let arrEndDateObj = convertDateTime(
                    "2023-11-15",
                    end_time[i]
                ).getTime();
                if (
                    (startDateObj <= arrStartDateObj &&
                        arrStartDateObj <= endDateObj) ||
                    (startDateObj <= arrEndDateObj &&
                        arrEndDateObj <= endDateObj) ||
                    (startDateObj >= arrStartDateObj &&
                        startDateObj <= arrEndDateObj)
                ) {
                    //console.log(111);
                    $(
                        "input[name='recurring_start_time[" +
                            day +
                            "][" +
                            index +
                            "]']"
                    ).val("");
                    $(
                        "input[name='recurring_end_time[" +
                            day +
                            "][" +
                            index +
                            "]']"
                    ).val("");
                    break;
                }
            }
        }
    }
}
function recurring_row(num) {
    let time = new Date().getTime();
    let days = ["Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"];
    let daily_rate = $(
        'input[name="recurring_daily_rate[' + num + '][0]"]'
    ).val();
    let hourly_rate = $(
        'input[name="recurring_hourly_rate[' + num + '][0]"]'
    ).val();
    let html =
        "<tr>" +
        '<td class="fw-bold"></td>' +
        '<td><input name="recurring_start_time[' +
        num +
        "][" +
        time +
        ']" data-index="' +
        time +
        '" type="text" class="form-control timepicker" placeholder="Start time" readonly onkeyup="validateDateTimeRecu(' +
        num +
        "," +
        time +
        ')"></td>' +
        '<td><input name="recurring_end_time[' +
        num +
        "][" +
        time +
        ']" type="text" class="form-control timepicker1" placeholder="End time" readonly onkeyup="validateDateTimeRecu(' +
        num +
        "," +
        time +
        ')"></td>' +
        '<td><input name="recurring_daily_rate[' +
        num +
        "][" +
        time +
        ']" type="number" class="form-control" placeholder="0" value="' +
        daily_rate +
        '"></td>' +
        '<td><input name="recurring_hourly_rate[' +
        num +
        "][" +
        time +
        ']" type="number" class="form-control" placeholder="0" value="' +
        hourly_rate +
        '"></td>' +
        '<td><i class="bi bi-trash daily-trash f20"></i></td>' +
        "</tr>";
    $(".row-" + num).after(html);
    $(".timepicker").timepicker({
        interval: 15,
        startTime: "09:00am",
        defaultTime: "09:00am",
        dynamic: false,
        dropdown: true,
        scrollbar: true,
    });
    $(".timepicker1").timepicker({
        interval: 15,
        startTime: "05:00pm",
        defaultTime: "05:00pm",
        dynamic: false,
        dropdown: true,
        scrollbar: true,
    });
}

function formatTime(date) {
    let hours = date.getHours();
    const minutes = date.getMinutes().toString().padStart(2, "0");
    const ampm = hours >= 12 ? "PM" : "AM";
    hours = hours % 12;
    hours = hours ? hours : 12; // the hour '0' should be '12'
    return `${hours}:${minutes} ${ampm}`;
}
