@extends('layouts.main')
@section('title', 'Nomadic Studios | Plans')
@section('content')
<div class="banner">
    <div class="img-text img-margin">{{__('Join global creatives')}}</div>
    <img class="img-fluid w-100" src="{{asset('images/banner1.png')}}">
</div>

<div class="container" data-aos="fade-up">
    <h2 class="mt-4 mb-4">{{__('Select membership level')}}</h2> 
    <span>- {{__('14 days residence/year')}}</span></br>
    <span>- {{__('14 days studio time/year')}}</span>
    <div class="row gy-4 justify-content-center text-center mt-2">
        @foreach($plans as $plan)
        <div class="col-12 col-sm-6 col-lg-2 mb-4 subscription-box">
            <div class="p-2 mb-4">{{__($plan->name)}}</div>
            <h3 class="mb-4"><b>${{$plan->price}}</b><span>/{{__($plan->frequency)}}</span></h3>
            <div class="p-2"><i class="bi bi-check2 me-2"></i>{{$plan->points}} Pts</div>
            <div class="p-2"><i class="bi bi-check2 me-2"></i>
            @if($plan->stripe_plan=="")
            {{__('Must be invited by member')}}
            @else
            {{__('Book up')}} {{$plan->advance_duration}} {{__($plan->advance_frequency)}} {{__('in advance')}}
            @endif
            </div>
            <div class="p-2"><i class="bi bi-check2 me-2"></i>{{$guests[$plan->num_of_guest]}} {{__('guests')}}</div>
            <a href="{{ url('signup/'.$plan->slug) }}" class="btn btn-primary pull-right mt-4 mb-3">{{__('Choose plan')}}</a>
        </div>
        @endforeach
    </div>
</div>
@endsection
