@extends('layouts.main')
@section('title', 'Nomadic-Login')
@section('content')
<div class="banner">
    <div class="img-text img-margin">{{__('Join global creatives')}}</div>
    <img class="img-fluid w-100" src="{{asset('images/banner1.png')}}">
</div>

<div class="container" data-aos="fade-up">
    <h2 class="sub-head mt-4">{{__('Login')}}</h2>
    <div class="row mb-5 d-block" align="center">
        <div class="col-md-4">
            @if (session('error'))
            <div class="alert alert-danger">{{session('error')}}</div>
            @endif
            @if (session('success'))
            <div class="alert alert-success">{{session('success')}}</div>
            @endif
            <form id="loginForm" class="w-100">
                @csrf
                <div class="form-container">
                    <div class="form-group mb-2">
                        <input type="text" id="mobile_number" name="mobile_number" class="form-control" placeholder="{{__('Phone Number')}}/{{__('Email')}}" />
                    </div>
                    <div class="form-group mb-3">
                        <input type="password" id="password" name="password" class="form-control" placeholder="{{__('Password')}}" />
                    </div>
                    <div class="form-group mb-3" align="left">
                        <input id="checkbox-20" name="remember_token" class="checkbox-custom" value="1" type="checkbox" checked>
                        <label for="checkbox-20" class="checkbox-custom-label">{{__('Keep me logged in')}}</label> 
                    </div>

                    <a class="float-start anc-color" href="{{url('login')}}">{{__('Login with phone')}}</a>
                    <a class="float-end anc-color" href="{{url('reset-password')}}">{{__('Forgot password?')}}</a>

                    <div class="btnconter clearfix mt-5 mb-4">
                        <button class="btn btn-primary" type="button" id="btn_login">{{__('Login')}}
                            <div class="spinner-border text-primary spinner" role="status" style="display:none;vertical-align:text-top;"><span class="visually-hidden">{{__('Loading')}}...</span></div>
                        </button>
                    </div>
                    <span>{{__("Don’t have an account?")}}</span> <a class="anc-color" href="{{url('choose-your-plan')}}">{{__('Sign up')}}</a>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('footer_scripts')
<script>
    $(document).ready(function () {
        $('#btn_login').click(function(){
            if($('#loginForm').valid()){
                $('#btn_login .spinner').show();
                $.ajax({
                    type: 'POST',
                    dataType: 'json',
                    data: $('#loginForm').serialize(),
                    url: APP_URL+"/login-save",
                    success: function(res) {
                        $('#btn_login .spinner').hide();
                        if(res.status){
                            window.location.href = APP_URL+'/home';
                        }
                    },
                    error: function(res) {                    
                        $('#btn_login .spinner').hide();
                        ajax_error(res);
                    }
                });
            }
        });

        $('#loginForm').validate({
            rules: {
                mobile_number: {
                    required: true,
                },
                password: {
                    required: true
                },
            },
            errorElement: 'span',
            errorPlacement: function (error, element) {
                // error.addClass('invalid-feedback float-start');
                // element.closest('.form-group').append(error);
            },
            highlight: function (element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function (element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            }
        });  

    });
</script>
@endsection
