@extends('layouts.main')
@section('title', 'Nomadic-Reset Password')
@section('content')
<div class="banner">
    <div class="img-text img-margin">{{__('Join global creatives')}}</div>
    <img class="img-fluid w-100" src="{{asset('images/banner1.png')}}">
</div>

<div class="container" data-aos="fade-up">
    <h2 class="sub-head" style="margin-top:2rem;margin-bottom:2rem;">{{__('Reset Password')}}</h2>
    <div class="row mb-5 d-block" align="center">
        <div class="col-md-4">
            @if (session('error'))
            <div class="alert alert-danger">{{session('error')}}</div>
            @endif
            @if (session('success'))
            <div class="alert alert-success">{{session('success')}}</div>
            @endif
            <form id="resetForm" class="w-100">
                @csrf
                <div class="mb-3">
                    <input name="email" type="email" class="form-control" id="emailInput" placeholder="Please enter your email">
                </div>
                <div class="mb-3">
                    <button class="btn btn-primary" id="btn_forgot_pass" type="button">Send Password Reset Link</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
@section('footer_scripts')
<script>
$(document).ready(function () {
    $('#btn_forgot_pass').click(function(){
        $.ajax({
            type: 'POST',
            dataType: 'json',
            data: $('#resetForm').serialize(),
            url: APP_URL+"/reset-password",
            success: function(res) {
                if(res.status){
                    window.location.reload();
                }else{
                    $('.pagemsgcontent').html('<div class="alert alert-error">'+res.message+'</div>');
                    $('#alertMsg').modal('show');
                }
            },
            error: function(res) {                    
                ajax_error(res);
            }
        });
    });
});
</script>
@endsection
