@extends('layouts.sidebar')
@section('title', 'Nomadic-CMS')
@section('content')
<div class="pagetitle">
  <h1>{{$page}} Page</h1>
</div>

<section class="section profile">
  <div class="col-xl-12">
    @if(session('success'))
    <div class="alert alert-success p-2">{{session('success')}}</div>
    @endif
    
    @foreach($files as $file)
    <div class="row">
      <div class="col-xl-4">
        <div class="card">
          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
            <label class="lblprofile">{{$file->section}}</label>
          </div>
        </div>
      </div>
      <div class="col-xl-8 mt-4">
        <div class="card">
          <div class="card-body pt-3">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">
                <form action="{{url('save-file')}}" method="post" enctype="multipart/form-data" id="cms_files_{{$file->id}}" class="dropzone">
                  @csrf
                  <input type="hidden" name="file_id" value="{{$file->id}}" readonly>
                </form>
                <div align="center" class="mt-2">
                  <img id="file_cont_{{$file->id}}" src="{{asset($file->image_path)}}" width="330px" class="rounded" />
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    @endforeach

  </div>
</section>
@endsection
@section('footer_scripts')
<link href="{{asset('css/dropzone.min.css')}}" rel="stylesheet">
<link href="{{asset('css/dropzone.custom.css')}}" rel="stylesheet">
<script src="{{asset('js/dropzone.js')}}"></script>
<script src="{{asset('js/cropper.js')}}"></script>
<link href="{{asset('css/cropper.css')}}" rel="stylesheet">
<script>
  Dropzone.autoDiscover = false;
  var drozoneArray = [];
  $(".dropzone").each(function() {
    let elemId = $(this).attr('id');
    drozoneArray[elemId] = new Dropzone("#"+elemId,{ 
      maxFiles: 1,
      maxFilesize: 100,
      autoProcessQueue: true,
      uploadMultiple: false, 
      addRemoveLinks: true,
      acceptedFiles: ".jpeg,.jpg,.png",
      // transformFile: function(file, done) {
      //   cropperImageFunc(file, done, this, 1, 600, 600);
      // }
    });
    drozoneArray[elemId].on("uploadprogress", function (file, progress) {
        $('.progress-text').html(parseInt(progress)+'%');
    });
    drozoneArray[elemId].on("error", function (file, errorMessage) {
        $('.progress-text').html('0%').hide();
    });
    drozoneArray[elemId].on("success", function (file, response) {
      $('.progress-text').html('0%').hide();
      drozoneArray[elemId].removeAllFiles(true);
      $('#file_cont_'+response.file_id).attr('src',response.image_url);
    });
  });
  
  $(document).ready(function () {
    

    
  });
</script>
@endsection