@extends('layouts.sidebar')
@section('title', 'Nomadic-CMS')
@section('content')
<div class="pagetitle">
  <h1>Our Partners Page</h1>
</div>

<section class="section profile">
  <div class="col-xl-12">
    @if(session('success'))
    <div class="alert alert-success p-2">{{session('success')}}</div>
    @endif
    
    <div class="row">
      <div class="col-xl-4">
        <div class="card">
          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
            <label class="lblprofile">Partners</label>
          </div>
        </div>
      </div>
      <div class="col-xl-8 mt-4">
        <div class="card">
          <div class="card-body pt-3">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">
                <form action="{{url('save-carousel-file')}}" method="post" enctype="multipart/form-data" id="cms_file" class="dropzone">
                  @csrf
                  <input type="hidden" name="page" value="our-partners" readonly />
                  <input type="hidden" name="section" value="Section One" readonly />
                </form>
                <div id="carouselImages"></div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

  </div>
</section>
@endsection
@section('footer_scripts')
<link href="{{asset('css/dropzone.min.css')}}" rel="stylesheet">
<link href="{{asset('css/dropzone.custom.css')}}" rel="stylesheet">
<script src="{{asset('js/dropzone.js')}}"></script>
<script src="{{asset('js/cropper.js')}}"></script>
<link href="{{asset('css/cropper.css')}}" rel="stylesheet">
<script>
  Dropzone.autoDiscover = false;
  var drozoneArray = [];
  $(".dropzone").each(function() {
    let elemId = $(this).attr('id');
    drozoneArray[elemId] = new Dropzone("#"+elemId,{ 
      maxFiles: 1,
      maxFilesize: 100,
      autoProcessQueue: true,
      uploadMultiple: false, 
      addRemoveLinks: true,
      acceptedFiles: ".jpeg,.jpg,.png",
      transformFile: function(file, done) {
        cropperImageFunc(file, done, this, 1, 600, 600);
      }
    });
    drozoneArray[elemId].on("uploadprogress", function (file, progress) {
        $('.progress-text').html(parseInt(progress)+'%');
    });
    drozoneArray[elemId].on("error", function (file, errorMessage) {
        $('.progress-text').html('0%').hide();
    });
    drozoneArray[elemId].on("success", function (file, response) {
      $('.progress-text').html('0%').hide();
      drozoneArray[elemId].removeAllFiles(true);
      carousel_images('carouselImages', 'our-partners', 'Section One');
    });
  });
  
  $(document).ready(function () {
    carousel_images('carouselImages', 'our-partners', 'Section One');

    $(document).on('click','.galimgdel',function(){
      let obj = $(this);
      let id = $(this).data('id');
      $.ajax({
        type: 'POST',
        dataType: 'json',
        data: {_token:_token, id:id},
        url: APP_URL+"/carousel-image-delete",
        success: function(res) {
          if(res.status){
            obj.parent().remove();
          }
        },
        error: function(res) {                    
          ajax_error(res);
        }
      });
    });
    
  });
</script>
@endsection