@extends('layouts.sidebar')
@section('title', 'Nomadic-Events')
@section('content')
<div class="pagetitle">
  <h1>@if(isset($events->event_id))Update @else Create new @endif event</h1>
</div>

<section class="section profile">

  <div class="col-xl-12">
    <input type="hidden" id="eventsid" name="eventsid" value="@if(isset($events->event_id)){{$events->event_id}}@endif" readonly>
    <input type="hidden" id="type" name="type" value="events" readonly>
    <input type="hidden" id="location_id" name="location_id" value="{{$locationId}}" readonly>

    @if(session('success'))
    <div class="alert alert-success p-2">{{session('success')}}</div>
    @endif

    <div class="row">
      <div class="col-xl-4">
        <div class="card">
          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
            <label class="lblprofile">Type</label>
          </div>
        </div>
      </div>
      <div class="col-xl-8 mt-4">
        <div class="card">
          <div class="card-body pt-3">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">
                <div>
                  <input id="checkbox-1" class="checkbox-custom" value="location" name="event_type" type="radio" @if(isset($events->event_type) && $events->event_type=='location') checked @endif>
                  <label for="checkbox-1" class="checkbox-custom-label">Location</label> 
                </div>
                <div>
                  <input id="checkbox-2" class="checkbox-custom" value="online" name="event_type" type="radio" @if(isset($events->event_type) && $events->event_type=='online') checked @endif>
                  <label for="checkbox-2" class="checkbox-custom-label">Online</label> 
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="row">
      <div class="col-xl-4">
        <div class="card">
          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
            <label class="lblprofile">Public or Private</label>
          </div>
        </div>
      </div>
      <div class="col-xl-8 mt-4">
        <div class="card">
          <div class="card-body pt-3">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">
                <div>
                  <input id="checkbox-3" class="checkbox-custom" value="public" name="public_private" type="radio" @if(isset($events->public_private) && $events->public_private=='public') checked @endif>
                  <label for="checkbox-3" class="checkbox-custom-label">Public</label> 
                </div>
                <div>
                  <input id="checkbox-4" class="checkbox-custom" value="private" name="public_private" type="radio" @if(isset($events->public_private) && $events->public_private=='private') checked @endif>
                  <label for="checkbox-4" class="checkbox-custom-label">Private</label> 
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="row stream-url">
      <div class="col-xl-4">
        <div class="card">
          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
            <label class="lblprofile">Stream URL</label>
          </div>
        </div>
      </div>
      <div class="col-xl-8 mt-4">
        <div class="card">
          <div class="card-body pt-3">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">
                <input type="text" class="form-control" name="stream_url" placeholder="Stream URL" value="@if(isset($events->stream_url)){{$events->stream_url}}@endif" disabled />
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="row stream-key">
      <div class="col-xl-4">
        <div class="card">
          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
            <label class="lblprofile">Stream Key</label>
          </div>
        </div>
      </div>
      <div class="col-xl-8 mt-4">
        <div class="card">
          <div class="card-body pt-3">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">
                <input type="text" class="form-control" placeholder="Stream Key" value="@if(isset($events->stream_key)){{$events->stream_key}}@endif" disabled />
              </div>
              @if(isset($events->stream_key))
              <div class="col-md-2">
                <a class="reset-key pointer" data-type="event" data-id="{{$events->event_id}}" data-num="">Reset Key</a>
              </div>
              @endif
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="row">
      <div class="col-xl-4">
        <div class="card">
          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
            <label class="lblprofile">Title</label>
          </div>
        </div>
      </div>
      <div class="col-xl-8 mt-4">
        <div class="card">
          <div class="card-body pt-3">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">
                <input type="text" class="form-control" name="event_title" placeholder="Title" value="@if(isset($events->event_title)){{$events->event_title}}@endif" />
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="row">
      <div class="col-xl-4">
        <div class="card">
          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
            <label class="lblprofile">Date and time</label>
          </div>
        </div>
      </div>
      <div class="col-xl-8 mt-4">
        <div class="card">
          <div class="card-body pt-3">
            <div class="row">
              <div class="col-md-4 mb-2 position-relative">
                <input type="date" class="form-control" name="event_date" placeholder="Date" value="@if(isset($events->event_date)){{$events->event_date}}@endif" />
              </div>
              <div class="col-md-3 mb-2 position-relative">
                <input type="text" class="form-control timepicker" readonly name="event_time" placeholder="Time" value="@if(isset($events->event_time)){{$events->event_time}}@endif" />
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="row">
      <div class="col-xl-4">
        <div class="card">
          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
            <label class="lblprofile">Duration (HH:MM)</label>
          </div>
        </div>
      </div>
      <div class="col-xl-8 mt-4">
        <div class="card">
          <div class="card-body pt-3">
            <div class="row">
              <div class="col-md-4 mb-2 position-relative">
                <select class="form-control" name="event_hour">
                <option value="00" @if($hours=='00') selected @endif>00</option>
                  <option value="01" @if($hours=='01') selected @endif>01</option>
                  <option value="02" @if($hours=='02') selected @endif>02</option>
                  <option value="03" @if($hours=='03') selected @endif>03</option>
                  <option value="04" @if($hours=='04') selected @endif>04</option>
                  <option value="05" @if($hours=='05') selected @endif>05</option>
                  <option value="06" @if($hours=='06') selected @endif>06</option>
                  <option value="07" @if($hours=='07') selected @endif>07</option>
                  <option value="08" @if($hours=='08') selected @endif>08</option>
                  <option value="09" @if($hours=='09') selected @endif>09</option>
                  <option value="10" @if($hours=='10') selected @endif>10</option>
                  <option value="11" @if($hours=='11') selected @endif>11</option>
                  <option value="12" @if($hours=='12') selected @endif>12</option>
                </select>
                <i class="bi bi-caret-down-fill searchicon"></i>
              </div>
              <div class="col-md-3 mb-2 position-relative">
                <select class="form-control" name="event_minute">
                  <option value="00" @if($minutes=='00') selected @endif>00</option>
                  <option value="15" @if($minutes=='15') selected @endif>15</option>
                  <option value="30" @if($minutes=='30') selected @endif>30</option>
                  <option value="45" @if($minutes=='45') selected @endif>45</option>
                </select>
                <i class="bi bi-caret-down-fill searchicon"></i>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="row">
      <div class="col-xl-4">
        <div class="card">
          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
            <label class="lblprofile">Address</label>
          </div>
        </div>
      </div>
      <div class="col-xl-8 mt-4">
        <div class="card">
          <div class="card-body pt-3">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">
                <input type="text" class="form-control" name="address" placeholder="Address" value="@if(isset($events->address)){{$events->address}}@endif" style="height:70px;"/>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="row">
      <div class="col-xl-4">
        <div class="card">
          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
            <label class="lblprofile">Ticket Price (In Points)</label>
          </div>
        </div>
      </div>
      <div class="col-xl-8 mt-4">
        <div class="card">
          <div class="card-body pt-3">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">
                <input type="number" class="form-control" name="ticket_price" placeholder="0" value="@if(isset($events->ticket_price)){{$events->ticket_price}}@endif" />
              </div>
              <!-- <div class="col-md-5 mb-2 position-relative">
                <input type="text" class="form-control" name="ticket_url" placeholder="Ticket URL" value="@if(isset($events->ticket_url)){{$events->ticket_url}}@endif" />
              </div> -->
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="row">
      <div class="col-xl-4">
        <div class="card">
          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
            <label class="lblprofile">Picture</label>
          </div>
        </div>
      </div>
      <div class="col-xl-8 mt-4">
        <div id="dispthumbnailimg" class="mb-3">
          @if(isset($events->thumbnail) && $events->thumbnail!="")
          <img src="{{asset('storage/location/events')}}/{{$events->thumbnail}}" class="img-fluid w-75" style="border-radius:5px;">
          @endif
        </div>
        <div class="card">
          <div class="card-body pt-3">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">
                <form action="{{url('fileupload')}}" method="post" enctype="multipart/form-data" id="thumbnail_picture" class="dropzone">
                  @csrf
                  <input type="hidden" name="image_type" value="thumbnail" readonly>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="row">
      <div class="col-xl-4">
        <div class="card">
          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
            <label class="lblprofile">Description</label>
          </div>
        </div>
      </div>
      <div class="col-xl-8 mt-4">
        <div class="card">
          <div class="card-body pt-3">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">
                <textarea id="quill-editor-default" class="quill-editor-default" style="height:100px;">@if(isset($events->description)){{$events->description}}@endif</textarea>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    
    <div class="row mt-3">
      <div class="col-md-12 text-center">
        <input id="btn_saveevent" type="button" class="btn btn-primary mb-2 mt-4" value="Save event">
      </div>
    </div>

  </div>
</section>
@endsection
@section('footer_scripts')
<script src="https://cdn.tiny.cloud/1/7oxmjjhuf38181ubsazv0hcwhi602g0gw8bbalyo8kvqttzl/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>
<script>
  tinyMCE.init({
    selector: 'textarea#quill-editor-default',
    plugins: 'anchor autolink link code',
    menubar: '',
    toolbar: 'bold italic underline link bullist code',
  });
</script>
<link href="{{asset('css/dropzone.min.css')}}" rel="stylesheet">
<link href="{{asset('css/dropzone.custom.css')}}" rel="stylesheet">
<script src="{{asset('js/dropzone.js')}}"></script>
<script src="{{asset('js/cropper.js')}}"></script>
<link href="{{asset('css/cropper.css')}}" rel="stylesheet">
<script>
  Dropzone.autoDiscover = false;
  var myDropzone = new Dropzone("#thumbnail_picture",{ 
      maxFiles: 1,
      maxFilesize: 100,
      autoProcessQueue: true,
      uploadMultiple: false, 
      addRemoveLinks: true,
      acceptedFiles: ".jpeg,.jpg,.png",
      transformFile: function(file, done) {
        let aRatio = 16/9;
        cropperImageFunc(file, done, this, aRatio, 1280, 720);
      }
  });
  myDropzone.on("sending", function(file, xhr, formData) {
    formData.append("type", $('#type').val());  
    formData.append("eventsid", $('#eventsid').val());
    formData.append("location_id", $('#location_id').val());
  });
  myDropzone.on("uploadprogress", function (file, progress) {
      $('.progress-text').html(parseInt(progress)+'%');
  });
  myDropzone.on("error", function (file, errorMessage) {
      $('.progress-text').html('0%').hide();
  });
  myDropzone.on("success", function (file, response) {
      $('.progress-text').html('0%').hide();
      $('#eventsid').val(response.eventsid);
      $('#dispthumbnailimg').html('<img src="'+APP_URL+'/'+response.imgurl+'" class="img-fluid w-75" style="border-radius:5px;">');
      myDropzone.removeAllFiles(true);
  });
   
  $(document).ready(function () {
    $(document).on('click','#btn_saveevent',function(){
      let eventsid = $('#eventsid').val();
      let location_id = $('#location_id').val();
      let event_type = $('input[name="event_type"]:checked').val();

      let public_private = $('input[name="public_private"]:checked').val();
      let stream_url = $('input[name="stream_url"]').val();
      let event_title = $('input[name="event_title"]').val();
      let event_date = $('input[name="event_date"]').val();
      let event_time = $('input[name="event_time"]').val();
      let address = $('input[name="address"]').val();
      let ticket_price = $('input[name="ticket_price"]').val();
      //let ticket_url = $('input[name="ticket_url"]').val();
      let event_hour = $('select[name="event_hour"]').val();
      let event_minute = $('select[name="event_minute"]').val();
      let duration = event_hour+':'+event_minute;
      let description = tinyMCE.get('quill-editor-default').getContent();
      
      $.ajax({
        type: 'POST',
        dataType: 'json',
        data: {_token:_token, location_id:location_id, eventsid:eventsid, event_type:event_type, public_private:public_private, stream_url:stream_url, event_title:event_title, event_date:event_date, event_time:event_time, address:address, ticket_price:ticket_price, duration:duration, description:description},
        url: APP_URL+"/backend/save-events/"+location_id,
        success: function(res) {
          if(res.status){
            window.location.href = APP_URL+'/backend/events/'+location_id+'/'+res._id;
          }
        },
        error: function(res) {                    
          ajax_error(res);
        }
      });
    });
  });
</script>
@endsection