@extends('layouts.sidebar')
@section('title', 'Nomadic-Manage Events')
@section('content')
<div class="pagetitle">
  <h1 class="float-start">Manage Events</h1>
  <a class="btn btn-primary float-end" href="{{url('backend/events/'.$locId)}}"><i class="bi bi-plus"></i> Create Events</a>
</div>

<section class="section profile">
  @if(session()->has('success'))
  <div class="alert alert-success">{{session()->get('success')}}</div>
  @endif
  @if(session()->has('error'))
  <div class="alert alert-danger">{{session()->get('error')}}</div>
  @endif
  <div class="row">
    <div class="gridcard col-xl-12">

      <div class="card">
        <div class="row">
          <div class="col-md-7 mb-2 position-relative">
            <input id="search_field" type="text" class="form-control" placeholder="Search" value="@if(request()->get('name')){{request()->get('name')}}@endif">
            <i class="bi bi-search searchicon" title="Search Member"></i>
          </div>
        </div>
        <div class="card-body profile-card pt-4 pl-0 d-flex flex-column align-items-center">
          <table class="table">
            <thead>
              <tr>
                <td>Title</td>
                <td>Address</td>
                <td>Event Type</td>
                <td>CreatedBy</td>
                <td>UpdatedBy</td>
                <td>Invite</td>
                <td>Action</td>
              </tr>
            </thead>
            <tbody>
              @if($data->count()>0)
                @foreach($data as $dt)
                <tr>
                  <td>{{ucfirst($dt->event_title)}}</td>
                  <td>{{$dt->address}}</td>
                  <td>{{ucfirst($dt->event_type)}}</td>
                  <td>@if($dt->createdBy) {{$dt->createdBy->fname}} {{$dt->createdBy->lname}} @endif</td>
                  <td>@if($dt->updatedBy) {{$dt->updatedBy->fname}} {{$dt->updatedBy->lname}} @endif</td>
                  <td><a href="{{url('invite-guest/event/'.$dt->event_id)}}">Invite Guest</a></td>
                  <td>
                    <a href="{{url('backend/events/'.$dt->location_id.'/'.$dt->event_id)}}"><i class="bi bi-pencil"></i></a>
                    <a class="delete-record pointer" data-url="{{url('backend/delete-events/'.$dt->location_id.'/'.$dt->event_id)}}"><i class="bi bi-trash"></i></a>
                  </td>
                </tr>
                @endforeach
              @else
              <tr>
                <td colspan="7">No record found</td>
              </tr>  
              @endif
            </tbody>
            <tfoot>
              <tr>
                <td colspan="7">
                  <div class="foot-paging">
                    {!! $data->withQueryString()->links('vendor.pagination.bootstrap-5') !!}
                  </div>  
                </td>
              </tr>
            </tfoot>
          </table>
        </div>
      </div>

    </div>

  </div>
</section>
@endsection