@extends('layouts.sidebar')
@section('title', 'Nomadic-Studio')
@section('content')
<div class="pagetitle">
  <h1>{{$location->location}} Studio Landing Page</h1>
</div>

<section class="section profile">
  <div class="col-xl-12">
    <input type="hidden" id="type" name="type" value="studio" readonly>
    <input type="hidden" id="lpid" name="lpid" value="@if($page){{$page->id}}@endif" readonly>
    <input type="hidden" id="location_id" name="location_id" value="@if($location){{$location->id}}@endif" readonly>
    
    @if(session('success'))
    <div class="alert alert-success p-2">{{session('success')}}</div>
    @endif
    
    <div class="row">
      <div class="col-xl-4">
        <div class="card">
          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
              <label class="lblprofile">Location</label>
          </div>
        </div>
      </div>
      <div class="col-xl-8 mt-4">
        <div class="card">
          <div class="card-body pt-3">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">{{$location->location}}</div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="row">
      <div class="col-xl-4">
        <div class="card">
          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
            <label class="lblprofile">Studios</label>
          </div>
        </div>
      </div>
      <div class="col-xl-8 mt-4">
        <div class="card">
          <div class="card-body pt-3">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">
                <select class="form-control" name="studio">  
                  <option value="">Select</option>
                  @foreach($local_studios as $key=>$val)
                  <option value="{{$key}}" @if(isset($page->studios) && $page->studios==$key) selected @endif>{{$val}}</option>    
                  @endforeach
                </select>
                <i class="bi bi-caret-down-fill searchicon"></i>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="row">
      <div class="col-xl-4">
        <div class="card">
          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
            <label class="lblprofile">Banner Picture</label>
          </div>
        </div>
      </div>
      <div class="col-xl-8 mt-4">
        <div id="dispbannerimg" class="mb-3">
        @if(isset($page->banner_picture) && $page->banner_picture!="")
          <img src="{{asset('storage/location')}}/{{$page->banner_picture}}" class="img-fluid w-75" style="border-radius:5px;">
        @endif
        </div>
        <div class="card">
          <div class="card-body pt-3">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">
                <form action="{{url('fileupload')}}" method="post" enctype="multipart/form-data" id="banner_picture" class="dropzone">
                  @csrf
                  <input type="hidden" name="image_type" value="banner" readonly>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="row">
      <div class="col-xl-4">
        <div class="card">
          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
            <label class="lblprofile">Gallery Photos</label>
          </div>
        </div>
      </div>
      <div class="col-xl-8 mt-4">
        <div class="card">
          <div class="card-body pt-3">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">
                <form action="{{url('fileupload')}}" method="post" enctype="multipart/form-data" id="gallery" class="dropzone">
                  @csrf
                  <input type="hidden" name="image_type" value="gallery" readonly>
                </form>
                <div id="galleryimages"></div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="row">
      <div class="col-xl-4">
        <div class="card">
          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
            <label class="lblprofile">Description</label>
          </div>
        </div>
      </div>
      <div class="col-xl-8 mt-4">
        <div class="card">
          <div class="card-body pt-3">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">
                <textarea id="quill-editor-default" class="quill-editor-default" style="height:100px;">@if(isset($page->description)){{$page->description}}@endif</textarea>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="row">
      <div class="col-xl-4">
        <div class="card">
          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
            <label class="lblprofile">Our Crew</label>
          </div>
        </div>
      </div>
      <div class="col-xl-8 mt-4">
        <div class="card">
          <div class="card-body pt-3">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">
                @foreach($resources as $resource)
                <div>
                    <input id="checkbox-2{{$loop->index}}" class="checkbox-custom" name="crew[]" type="checkbox" value="{{$resource->id}}" @if(isset($page->our_crew) && strpos($page->our_crew,$resource->id) !== false) checked @endif>
                    <label for="checkbox-2{{$loop->index}}" class="checkbox-custom-label">{{__($resource->name)}}</label> 
                </div>
                @endforeach
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="row">
      <div class="col-xl-4">
        <div class="card">
          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
            <label class="lblprofile">Equipment</label>
          </div>
        </div>
      </div>
      <div class="col-xl-8 mt-4">
        <div class="card">
          <div class="card-body pt-3">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">
                @foreach($equipments as $eqp)
                <div>
                    <input id="checkbox-3{{$loop->index}}" class="checkbox-custom" name="equipment[]" type="checkbox" value="{{$eqp->id}}" @if(isset($page->equipment_ids) && strpos($page->equipment_ids,$eqp->id) !== false) checked @endif>
                    <label for="checkbox-3{{$loop->index}}" class="checkbox-custom-label">{{__($eqp->name)}}</label> 
                </div>
                @endforeach
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    
    <div class="row mt-3">
      <div class="col-md-12 text-center">
        <input id="btn_saveloclandingpage" type="button" class="btn btn-primary mb-2 mt-4" value="Save changes">
      </div>
    </div>

  </div>
</section>
@endsection
@section('footer_scripts')
<script src="https://cdn.tiny.cloud/1/7oxmjjhuf38181ubsazv0hcwhi602g0gw8bbalyo8kvqttzl/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>
<script>
  tinyMCE.init({
    selector: 'textarea#quill-editor-default',
    plugins: 'anchor autolink link code',
    menubar: '',
    toolbar: 'bold italic underline link bullist code',
  });
</script>
<link href="{{asset('css/dropzone.min.css')}}" rel="stylesheet">
<link href="{{asset('css/dropzone.custom.css')}}" rel="stylesheet">
<script src="{{asset('js/dropzone.js')}}"></script>
<script src="{{asset('js/cropper.js')}}"></script>
<link href="{{asset('css/cropper.css')}}" rel="stylesheet">
<script>
  Dropzone.autoDiscover = false;
  var myDropzone = new Dropzone("#banner_picture",{ 
      maxFiles: 1,
      maxFilesize: 100,
      autoProcessQueue: true,
      uploadMultiple: false, 
      addRemoveLinks: true,
      acceptedFiles: ".jpeg,.jpg,.png",
      transformFile: function(file, done) {
        let aRatio = 3/1;
        cropperImageFunc(file, done, this, aRatio, 1800, 600);
      }
  });
  myDropzone.on("sending", function(file, xhr, formData) {
      formData.append("type", $('#type').val());
      formData.append("lpid", $('#lpid').val());
      formData.append("location_id", $('#location_id').val());
  });
  myDropzone.on("uploadprogress", function (file, progress) {
      $('.progress-text').html(parseInt(progress)+'%');
  });
  myDropzone.on("error", function (file, errorMessage) {
      $('.progress-text').html('0%').hide();
  });
  myDropzone.on("success", function (file, response) {
      $('.progress-text').html('0%').hide();
      $('#lpid').val(response.lpid);
      $('#dispbannerimg').html('<img src="'+APP_URL+'/'+response.imgurl+'" class="img-fluid w-75" style="border-radius:5px;">');
      myDropzone.removeAllFiles(true);
  });

  // gallery photos
  var myDropzone2 = new Dropzone("#gallery",{ 
      maxFiles: 10,
      maxFilesize: 100,
      autoProcessQueue: true,
      uploadMultiple: false, 
      addRemoveLinks: true,
      acceptedFiles: ".jpeg,.jpg,.png",
      transformFile: function(file, done) {
        let aRatio = 3/2;
        cropperImageFunc(file, done, this, aRatio, 558, 400);
      }
  });
  myDropzone2.on("sending", function(file, xhr, formData) {
      formData.append("type", $('#type').val());
      formData.append("lpid", $('#lpid').val());
      formData.append("location_id", $('#location_id').val());
  });
  myDropzone2.on("uploadprogress", function (file, progress) {
      $('.progress-text').html(parseInt(progress)+'%');
  });
  myDropzone2.on("error", function (file, errorMessage) {
      $('.progress-text').html('0%').hide();
  });
  myDropzone2.on("success", function (file, response) {
      $('.progress-text').html('0%').hide();
      $('#lpid').val(response.lpid);
      myDropzone2.removeAllFiles(true);
      gallery_images('studio','gallery',response.lpid,'galleryimages');
  });
   
  $(document).ready(function () {
    let lpid = $('#lpid').val();
    if(lpid!=""){
      gallery_images('studio','gallery',lpid,'galleryimages');
    }

    $(document).on('click','#btn_saveloclandingpage',function(){
      let lpid = $('#lpid').val();
      // if(lpid==""){
      //   $('#alertMsg .pagemsgcontent').html('<div class="alert alert-danger">Please fill some required fields.</div>');
      //   $('#alertMsg').modal('show');return;
      // }
      let location_id = $('#location_id').val();
      let studio = $('select[name="studio"]').val();
      let description = tinyMCE.get('quill-editor-default').getContent();
      let equipment = $('input[name="equipment[]"]:checked').map(function() {
        return this.value;
      }).get();
      let crew = $('input[name="crew[]"]:checked').map(function() {
        return this.value;
      }).get()
      
      $.ajax({
        type: 'POST',
        dataType: 'json',
        data: {_token:_token, lpid:lpid, location_id:location_id, studio:studio, our_crew:crew, equipment:equipment, description:description},
        url: APP_URL+"/backend/studio-landing-page-save/"+location_id,
        success: function(res) {
          if(res.status){
            $('#alertMsg .pagemsgcontent').html('<div class="alert alert-success">'+res.message+'</div>');
            $('#alertMsg').modal('show');
          }
        },
        error: function(res) {                    
          ajax_error(res);
        }
      });
    });
  });
</script>
@endsection