@extends('layouts.main')
@section('title', 'Booking Detail')
@section('content')
<style>
.booking-list-accordion .accordion-button {
    font-weight: 600;
    background: #f8f9fa;
    color: #2c3e50;
}
.booking-list-accordion .accordion-item {
    border-radius: 8px;
    margin-bottom: 16px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.04);
    border: none;
}
.booking-list-accordion .accordion-body {
    background: #fff;
    border-radius: 0 0 8px 8px;
}
.booking-notes {
    background: #f2eeeb;
    border-radius: 8px;
    padding: 16px;
    margin-top: 12px;
}
.booking-notes .notes-actions {
    margin-top: 10px;
}
</style>
<div class="container position-relative" data-aos="fade-up" style="top:25px;padding-bottom:30px;">
    <h2 class="mb-4">Bookings of - {{ucfirst($user->fname)}} {{ucfirst($user->lname)}}</h2>
    <div class="accordion booking-list-accordion" id="bookingAccordion">
        @foreach($bookings as $book)
        <div class="accordion-item">
            <h2 class="accordion-header" id="heading{{$book->booking_id}}">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse{{$book->booking_id}}" aria-expanded="false" aria-controls="collapse{{$book->booking_id}}">
                    Booking #{{$book->booking_id}} &mdash; {{ \Carbon\Carbon::parse($book->start_date . ' ' . $book->start_time)->format('d M Y, h:i A') }}
                </button>
            </h2>
            <div id="collapse{{$book->booking_id}}" class="accordion-collapse collapse @if($booking_id==$book->booking_id) show @endif" aria-labelledby="heading{{$book->booking_id}}" data-bs-parent="#bookingAccordion">
                <div class="accordion-body">
                    <div class="booking-notes">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <strong>Notes:</strong>
                                <span id="notes_display_{{$book->booking_id}}">
                                    @if($book->notes && count($book->notes))
                                        <ul class="list-unstyled mb-0">
                                            @foreach($book->notes as $note)
                                                <li class="mb-2">
                                                    <span class="d-block">{!! $note->notes !!}</span>
                                                    <small class="text-muted">{{ \Carbon\Carbon::parse($note->created_at)->format('d M Y, h:i A') }}</small>
                                                    @if($note->createdby == auth()->id())
                                                    <div class="notes-actions mt-1">
                                                        <button class="btn btn-sm btn-outline-primary me-2 edit-notes-btn" data-booking="{{$book->booking_id}}" data-note="{{$note->id}}">Edit</button>
                                                        <button class="btn btn-sm btn-outline-danger delete-notes-btn" data-booking="{{$book->booking_id}}" data-note="{{$note->id}}">Delete</button>
                                                    </div>
                                                    <div class="edit-notes-form mt-2" id="edit_notes_form_{{$book->booking_id}}_{{$note->id}}" style="display:none;">
                                                        <textarea cols="100" class="form-control mb-2" id="edit_notes_textarea_{{$book->booking_id}}_{{$note->id}}">{!! $note->notes !!}</textarea>
                                                        <button class="btn btn-primary btn-sm save-notes-btn" data-booking="{{$book->booking_id}}" data-note="{{$note->id}}">Save</button>
                                                        <button class="btn btn-secondary btn-sm cancel-notes-btn" data-booking="{{$book->booking_id}}" data-note="{{$note->id}}">Cancel</button>
                                                    </div>
                                                    @endif
                                                </li>
                                            @endforeach
                                        </ul>
                                    @else
                                        <span class="text-muted">No notes available.</span>
                                    @endif
                                </span>
                            </div>
                        </div>
                        <div class="mt-3">
                            <button class="btn btn-success btn-sm add-notes-btn" data-booking="{{$book->booking_id}}">Add Note</button>
                            <div class="add-notes-form mt-2" id="add_notes_form_{{$book->booking_id}}" style="display:none;">
                                <textarea cols="100" class="form-control mb-2" id="add_notes_textarea_{{$book->booking_id}}"></textarea>
                                <button class="btn btn-primary btn-sm save-add-notes-btn" data-booking="{{$book->booking_id}}">Save</button>
                                <button class="btn btn-secondary btn-sm cancel-add-notes-btn" data-booking="{{$book->booking_id}}">Cancel</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @endforeach
    </div>
</div>
@endsection
@section('footer_scripts')
<script>
$(document).ready(function(){
    // Add note
    $('.add-notes-btn').on('click', function(){
        var bookingId = $(this).data('booking');
        $('#add_notes_form_' + bookingId).show();
    });
    $('.cancel-add-notes-btn').on('click', function(){
        var bookingId = $(this).data('booking');
        $('#add_notes_form_' + bookingId).hide();
    });
    $('.save-add-notes-btn').on('click', function(){
        var bookingId = $(this).data('booking');
        var notes = $('#add_notes_textarea_' + bookingId).val();
        var btn = $(this);
        btn.prop('disabled', true);
        $.ajax({
            type: 'POST',
            dataType: 'json',
            data: {_token:_token, booking_id: bookingId, notes: notes, action: 'add'},
            url: APP_URL+"/save-booking-notes",
            success: function(res) { location.reload(); },
            error: function(res) { btn.prop('disabled', false); ajax_error(res); }
        });
    });
    // Edit note
    $('.edit-notes-btn').on('click', function(){
        var bookingId = $(this).data('booking');
        var noteId = $(this).data('note');
        $('#notes_display_' + bookingId + ' .edit-notes-form').hide();
        $('#edit_notes_form_' + bookingId + '_' + noteId).show();
    });
    $('.cancel-notes-btn').on('click', function(){
        var bookingId = $(this).data('booking');
        var noteId = $(this).data('note');
        $('#edit_notes_form_' + bookingId + '_' + noteId).hide();
    });
    $('.save-notes-btn').on('click', function(){
        var bookingId = $(this).data('booking');
        var noteId = $(this).data('note');
        var notes = $('#edit_notes_textarea_' + bookingId + '_' + noteId).val();
        var btn = $(this);
        btn.prop('disabled', true);
        $.ajax({
            type: 'POST',
            dataType: 'json',
            data: {_token:_token, booking_id: bookingId, note_id: noteId, notes: notes, action: 'edit'},
            url: APP_URL+"/save-booking-notes",
            success: function(res) { location.reload(); },
            error: function(res) { btn.prop('disabled', false); ajax_error(res); }
        });
    });
    // Delete note
    $('.delete-notes-btn').on('click', function(){
        if(!confirm('Are you sure you want to delete this note?')) return;
        var bookingId = $(this).data('booking');
        var noteId = $(this).data('note');
        var btn = $(this);
        btn.prop('disabled', true);
        $.ajax({
            type: 'POST',
            dataType: 'json',
            data: {_token:_token, booking_id: bookingId, note_id: noteId, action: 'delete'},
            url: APP_URL+"/save-booking-notes",
            success: function(res) { location.reload(); },
            error: function(res) { btn.prop('disabled', false); ajax_error(res); }
        });
    });
});
</script>
@endsection