@extends('layouts.main')
@section('title', 'Booking Detail')
@section('content')
<style>
.booking-details-section {
    background: #f2eeeb;
    border-radius: 12px;
    padding: 32px 24px 24px 24px;
    box-shadow: 0 2px 12px rgba(0,0,0,0.04);
    margin-bottom: 32px;
}
.booking-details-section h5 {
    color: #2c3e50;
    margin-bottom: 18px;
}
.booking-details-section .text-uppercase {
    color: #6c757d;
    font-size: 0.95rem;
    letter-spacing: 1px;
    margin-bottom: 4px;
}
.booking-details-section b {
    font-size: 1.1rem;
    color: #222;
}
.booking-details-section .row-detail {
    border-bottom: 1px solid #e0e0e0;
    padding-bottom: 18px;
    margin-bottom: 18px;
}
.booking-details-section .fw-bold {
    color:#c58b63;
}
.booking-details-section .row-detail:last-child {
    border-bottom: none;
    margin-bottom: 0;
    padding-bottom: 0;
}



.booking-list-accordion .accordion-button {
    font-weight: 600;
    background: #f8f9fa;
    color: #2c3e50;
}
.booking-list-accordion .accordion-item {
    border-radius: 8px;
    margin-bottom: 16px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.04);
    border: none;
}
.booking-list-accordion .accordion-body {
    background: #fff;
    border-radius: 0 0 8px 8px;
}
.booking-notes {
    background: #f2eeeb;
    border-radius: 8px;
    padding: 16px;
    margin-top: 12px;
}
.booking-notes .notes-actions {
    margin-top: 10px;
}
</style>
<div class="container position-relative" data-aos="fade-up" style="top:25px;padding-bottom:30px;">
    @php
        $startDateTime = \Carbon\Carbon::parse($booking->start_date . ' ' . $booking->start_time);
        $endDateTime = \Carbon\Carbon::parse($booking->end_date . ' ' . $booking->end_time);
    @endphp
    <h2 class="mt-4 mb-4">Booking Details</h2>
    <div class="booking-details-section row g-3">
        <div class="col-md-6 row-detail">
            <div class="text-uppercase"># Booking Id</div>
            <b>{{ $booking->booking_id }}</b>
        </div>
        <div class="col-md-6 row-detail">
            <div class="text-uppercase">Date</div>
            <b id="book_datetime">{{ $startDateTime->format('d M Y, h:i A') }} - {{ $endDateTime->format('d M Y, h:i A') }}</b>
        </div>
        <div class="col-12 row-detail heading"><h5 class="fw-bold">Studio Details</h5></div>
        <div class="col-md-6 row-detail">
            <div class="text-uppercase">Studio</div>
            @foreach($booking->studios as $studio)
                <b id="book_studio_name">{{ $studio->name }}</b>
            @endforeach
        </div>
        <div class="col-md-6 row-detail">
            <div class="text-uppercase">Type of Studio</div>
            @foreach($booking->studios as $studio)
                <b id="book_studio_type">{{ $studio->studioType }}</b>
            @endforeach
        </div>
        @if($booking->rentals->count() > 0)
        <div class="col-12 row-detail"><h5 class="fw-bold mt-4">Equipment Details</h5></div>
        <div class="col-md-6 row-detail">
            <div class="text-uppercase">Equipment</div>
            @foreach($booking->rentals as $rental)
                @if(!is_null($rental->checkin_id))
                <b id="book_equipments"><a href="{{url('equipment-checkin/'.$rental->checkin_id)}}">{{ $rental->name }}</a></b>
                @else
                <b id="book_equipments">{{ $rental->name }}</b>
                @endif
            @endforeach
        </div>
        <div class="col-md-6 row-detail">
            <div class="text-uppercase">Serial Number</div>
            @foreach($booking->rentals as $rental)
                <b>{{ $rental->serial_number }}</b>
            @endforeach
        </div>
        @endif
        @if($booking->resources->count() > 0)
        <div class="col-12 row-detail"><h5 class="fw-bold mt-4">Resource Details</h5></div>
        <div class="col-md-6 row-detail">
            <div class="text-uppercase">Resource</div>
            @foreach($booking->resources as $resource)
                <b id="book_equipments">{{ ucfirst($resource->fname) }} {{ ucfirst($resource->lname) }}</b>
            @endforeach
        </div>
        <div class="col-md-6 row-detail">
            <div class="text-uppercase">Role</div>
            @foreach($booking->resources as $resource)
                <b>{{ $resource->name }}</b>
            @endforeach
        </div>
        @endif
        <div class="col-12 row-detail"><h5 class="fw-bold mt-4">Client Details</h5></div>

        <div class="col-md-6 row-detail">
            <div class="text-uppercase">Name</div>
            <b id="book_client_name">{{ucfirst($booking->booking_by->fname)}} {{ucfirst($booking->booking_by->lname)}}</b>
        </div>
        <div class="col-3 row-detail">
            <div class="text-uppercase">Phone</div>
            <b id="book_client_phone">{{$booking->booking_by->mobile_number}}</b>
        </div>
        <div class="col-3 row-detail">
            <div class="text-uppercase">Email</div>
            <b id="book_client_email">{{$booking->booking_by->email}}</b>
        </div>
        
        <div class="col-12 row-detail"><h5 class="fw-bold mt-4">Notes</h5></div>
        <div class="col-md-12 row-detail">
            <div class="text-uppercase">Notes</div>
            <div class="accordion" id="bookingDetailNotesAccordion">
                <div class="accordion-item">
                    <h2 class="accordion-header" id="bookingDetailNotesHeading">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#bookingDetailNotesCollapse" aria-expanded="false" aria-controls="bookingDetailNotesCollapse">
                            View Notes
                        </button>
                    </h2>
                    <div id="bookingDetailNotesCollapse" class="accordion-collapse collapse" aria-labelledby="bookingDetailNotesHeading" data-bs-parent="#bookingDetailNotesAccordion">
                        <div class="accordion-body">
                            @if($booking->notes && is_iterable($booking->notes) && count($booking->notes))
                                <ul class="list-unstyled mb-3">
                                    @foreach($booking->notes as $note)
                                        <li class="mb-2">
                                            <span class="d-block">{!! $note->notes !!}</span>
                                            <small class="text-muted">{{ \Carbon\Carbon::parse($note->created_at)->format('d M Y, h:i A') }}</small>
                                            @if($booking->status == 0 && $note->createdby == auth()->id())
                                            <div class="notes-actions mt-1">
                                                <button class="btn btn-sm btn-outline-primary me-2 edit-notes-btn" data-booking="{{$booking->booking_id}}" data-note="{{$note->id}}">Edit</button>
                                                <button class="btn btn-sm btn-outline-danger delete-notes-btn" data-booking="{{$booking->booking_id}}" data-note="{{$note->id}}">Delete</button>
                                            </div>
                                            <div class="edit-notes-form mt-2" id="edit_notes_form_{{$booking->booking_id}}_{{$note->id}}" style="display:none;">
                                                <textarea cols="100" class="form-control mb-2" id="edit_notes_textarea_{{$booking->booking_id}}_{{$note->id}}">{!! $note->notes !!}</textarea>
                                                <button class="btn btn-primary btn-sm save-notes-btn" data-booking="{{$booking->booking_id}}" data-note="{{$note->id}}">Save</button>
                                                <button class="btn btn-secondary btn-sm cancel-notes-btn" data-booking="{{$booking->booking_id}}" data-note="{{$note->id}}">Cancel</button>
                                            </div>
                                            @endif
                                        </li>
                                    @endforeach
                                </ul>
                            @else
                                <span class="text-muted">No notes available.</span>
                            @endif
                            @if($booking->status == 0)
                                <button class="btn btn-success btn-sm add-notes-btn" data-booking="{{$booking->booking_id}}">Add Note</button>
                                <div class="add-notes-form mt-2" id="add_notes_form_{{$booking->booking_id}}" style="display:none;">
                                    <textarea cols="100" class="form-control mb-2" id="add_notes_textarea_{{$booking->booking_id}}"></textarea>
                                    <button class="btn btn-primary btn-sm save-add-notes-btn" data-booking="{{$booking->booking_id}}">Save</button>
                                    <button class="btn btn-secondary btn-sm cancel-add-notes-btn" data-booking="{{$booking->booking_id}}">Cancel</button>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-12 row-detail">
            <div class="pt-3 h-100 d-flex flex-column justify-content-center align-items-center">
                <div class="row w-100 justify-content-center">
                    <div class="col-6 text-end">
                        <b>Booking Cost</b>
                    </div>
                    <div class="col-6 text-start">
                        <b id="book_points">{{$booking->total_points}}</b> <b>pts</b>
                    </div>
                </div>
                <div class="text-center mt-4 w-100">
                    @if($booking->status == 2)
                        <span class="text-danger fw-bold">Cancelled</span>
                    @elseif($booking->status == 1)
                        <span class="text-success fw-bold">Completed</span>
                    @elseif($endDateTime > \Carbon\Carbon::now())
                        <button type="button" class="btn btn-dark cancel-booking ms-2" data-booking="{{$booking->booking_id}}">Cancel booking</button>
                        <button type="button" class="btn btn-primary ms-2 mark-complete" data-booking="{{$booking->booking_id}}">Make as completed</button>
                    @else
                        <span class="text-warning fw-bold">Booking is not marked as complete</span>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <div class="container position-relative" data-aos="fade-up" style="top:25px;padding-bottom:30px;">
        <div class="accordion booking-list-accordion" id="bookingAccordion">
            @foreach($old_bookings as $book)
            <div class="accordion-item">
                <h2 class="accordion-header" id="heading{{$book->booking_id}}">
                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse{{$book->booking_id}}" aria-expanded="false" aria-controls="collapse{{$book->booking_id}}">
                        Booking #{{$book->booking_id}} &mdash; {{ \Carbon\Carbon::parse($book->start_date . ' ' . $book->start_time)->format('d M Y, h:i A') }}
                    </button>
                </h2>
                <div id="collapse{{$book->booking_id}}" class="accordion-collapse collapse @if($booking_id==$book->booking_id) show @endif" aria-labelledby="heading{{$book->booking_id}}" data-bs-parent="#bookingAccordion">
                    <div class="accordion-body">
                        <div class="booking-notes">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <strong>Notes:</strong>
                                    <span id="notes_display_{{$book->booking_id}}">
                                        @if($book->notes && count($book->notes))
                                            <ul class="list-unstyled mb-0">
                                                @foreach($book->notes as $note)
                                                    <li class="mb-2">
                                                        <span class="d-block">{!! $note->notes !!}</span>
                                                        <small class="text-muted">{{ \Carbon\Carbon::parse($note->created_at)->format('d M Y, h:i A') }}</small>
                                                        @if($book->status == 0 && $note->createdby == auth()->id())
                                                        <div class="notes-actions mt-1">
                                                            <button class="btn btn-sm btn-outline-primary me-2 edit-notes-btn" data-booking="{{$book->booking_id}}" data-note="{{$note->id}}">Edit</button>
                                                            <button class="btn btn-sm btn-outline-danger delete-notes-btn" data-booking="{{$book->booking_id}}" data-note="{{$note->id}}">Delete</button>
                                                        </div>
                                                        <div class="edit-notes-form mt-2" id="edit_notes_form_{{$book->booking_id}}_{{$note->id}}" style="display:none;">
                                                            <textarea cols="100" class="form-control mb-2" id="edit_notes_textarea_{{$book->booking_id}}_{{$note->id}}">{!! $note->notes !!}</textarea>
                                                            <button class="btn btn-primary btn-sm save-notes-btn" data-booking="{{$book->booking_id}}" data-note="{{$note->id}}">Save</button>
                                                            <button class="btn btn-secondary btn-sm cancel-notes-btn" data-booking="{{$book->booking_id}}" data-note="{{$note->id}}">Cancel</button>
                                                        </div>
                                                        @endif
                                                    </li>
                                                @endforeach
                                            </ul>
                                        @else
                                            <span class="text-muted">No notes available.</span>
                                        @endif
                                    </span>
                                </div>
                            </div>
                            <div class="mt-3">
                                @if($book->status == 0)
                                    <button class="btn btn-success btn-sm add-notes-btn" data-booking="{{$book->booking_id}}">Add Note</button>
                                    <div class="add-notes-form mt-2" id="add_notes_form_{{$book->booking_id}}" style="display:none;">
                                        <textarea cols="100" class="form-control mb-2" id="add_notes_textarea_{{$book->booking_id}}"></textarea>
                                        <button class="btn btn-primary btn-sm save-add-notes-btn" data-booking="{{$book->booking_id}}">Save</button>
                                        <button class="btn btn-secondary btn-sm cancel-add-notes-btn" data-booking="{{$book->booking_id}}">Cancel</button>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
    </div>



</div>
@endsection
@section('footer_scripts')
<script>
$(document).ready(function(){
    $(document).on('click', '#btn_saveNotes', function(){
      let obj = $(this);
      obj.attr('disabled',true);
      let booking_id = $(this).data('booking');
      let notes = $('#book_notes').val();
      $.ajax({
          type: 'POST',
          dataType: 'json',
          data: {_token:_token, booking_id: booking_id, notes: notes},
          url: APP_URL+"/save-booking-notes",
          success: function(res) {
            window.location.href = APP_URL+"/booking-detail/"+booking_id;
          },
          error: function(res) {
            obj.attr('disabled',false);  
            ajax_error(res);
          }
      });
    });

    // Add note
    $('.add-notes-btn').on('click', function(){
        var bookingId = $(this).data('booking');
        $('#add_notes_form_' + bookingId).show();
    });
    $('.cancel-add-notes-btn').on('click', function(){
        var bookingId = $(this).data('booking');
        $('#add_notes_form_' + bookingId).hide();
    });
    $('.save-add-notes-btn').on('click', function(){
        var bookingId = $(this).data('booking');
        var notes = $('#add_notes_textarea_' + bookingId).val();
        var btn = $(this);
        btn.prop('disabled', true);
        $.ajax({
            type: 'POST',
            dataType: 'json',
            data: {_token:_token, booking_id: bookingId, notes: notes, action: 'add'},
            url: APP_URL+"/save-booking-notes",
            success: function(res) { location.reload(); },
            error: function(res) { btn.prop('disabled', false); ajax_error(res); }
        });
    });
    // Edit note
    $('.edit-notes-btn').on('click', function(){
        var bookingId = $(this).data('booking');
        var noteId = $(this).data('note');
        $('#notes_display_' + bookingId + ' .edit-notes-form').hide();
        $('#edit_notes_form_' + bookingId + '_' + noteId).show();
    });
    $('.cancel-notes-btn').on('click', function(){
        var bookingId = $(this).data('booking');
        var noteId = $(this).data('note');
        $('#edit_notes_form_' + bookingId + '_' + noteId).hide();
    });
    $('.save-notes-btn').on('click', function(){
        var bookingId = $(this).data('booking');
        var noteId = $(this).data('note');
        var notes = $('#edit_notes_textarea_' + bookingId + '_' + noteId).val();
        var btn = $(this);
        btn.prop('disabled', true);
        $.ajax({
            type: 'POST',
            dataType: 'json',
            data: {_token:_token, booking_id: bookingId, note_id: noteId, notes: notes, action: 'edit'},
            url: APP_URL+"/save-booking-notes",
            success: function(res) { location.reload(); },
            error: function(res) { btn.prop('disabled', false); ajax_error(res); }
        });
    });
    // Delete note
    $('.delete-notes-btn').on('click', function(){
        if(!confirm('Are you sure you want to delete this note?')) return;
        var bookingId = $(this).data('booking');
        var noteId = $(this).data('note');
        var btn = $(this);
        btn.prop('disabled', true);
        $.ajax({
            type: 'POST',
            dataType: 'json',
            data: {_token:_token, booking_id: bookingId, note_id: noteId, action: 'delete'},
            url: APP_URL+"/save-booking-notes",
            success: function(res) { location.reload(); },
            error: function(res) { btn.prop('disabled', false); ajax_error(res); }
        });
    });
});
</script>
@endsection