@extends('layouts.main')
@section('title', 'Booking Detail')
@section('content')
<style>
.booking-details-section {
    background: #f2eeeb;
    border-radius: 12px;
    padding: 32px 24px 24px 24px;
    box-shadow: 0 2px 12px rgba(0,0,0,0.04);
    margin-bottom: 32px;
}
.booking-details-section h5 {
    color: #2c3e50;
    margin-bottom: 18px;
}
.booking-details-section .text-uppercase {
    color: #6c757d;
    font-size: 0.95rem;
    letter-spacing: 1px;
    margin-bottom: 4px;
}
.booking-details-section b {
    font-size: 1.1rem;
    color: #222;
}
.booking-details-section .row-detail {
    border-bottom: 1px solid #e0e0e0;
    padding-bottom: 18px;
    margin-bottom: 18px;
}
.booking-details-section .fw-bold {
    color:#c58b63;
}
.booking-details-section .row-detail:last-child {
    border-bottom: none;
    margin-bottom: 0;
    padding-bottom: 0;
}
</style>
<div class="container position-relative" data-aos="fade-up" style="top:25px;padding-bottom:30px;">
    <h2 class="mb-4">Bookings of - {{ucfirst($booking->booking_by->fname)}} {{ucfirst($booking->booking_by->lname)}}</h2>
    <div class="row">
        @foreach($bookings_list as $book)
        <div class="col-md-1 mb-2">
            <a class="btn @if($booking_id==$book->booking_id) btn-primary @else btn-dark @endif" href="{{url('booking-detail/'.$book->booking_id)}}">{{$book->booking_id}}</a>
        </div>
        @endforeach
    </div>
    <hr>
    @php
        $startDateTime = \Carbon\Carbon::parse($booking->start_date . ' ' . $booking->start_time);
        $endDateTime = \Carbon\Carbon::parse($booking->end_date . ' ' . $booking->end_time);
    @endphp
    <h2 class="mt-4 mb-4">Booking Details</h2>
    <div class="booking-details-section row g-3">
        <div class="col-md-6 row-detail">
            <div class="text-uppercase"># Booking Id</div>
            <b>{{ $booking->booking_id }}</b>
        </div>
        <div class="col-md-6 row-detail">
            <div class="text-uppercase">Date</div>
            <b id="book_datetime">{{ $startDateTime->format('d M Y, h:i A') }} - {{ $endDateTime->format('d M Y, h:i A') }}</b>
        </div>
        <div class="col-12 row-detail heading"><h5 class="fw-bold">Studio Details</h5></div>
        <div class="col-md-6 row-detail">
            <div class="text-uppercase">Studio</div>
            @foreach($booking->studios as $studio)
                <b id="book_studio_name">{{ $studio->name }}</b>
            @endforeach
        </div>
        <div class="col-md-6 row-detail">
            <div class="text-uppercase">Type of Studio</div>
            @foreach($booking->studios as $studio)
                <b id="book_studio_type">{{ $studio->studioType }}</b>
            @endforeach
        </div>
        @if($booking->rentals->count() > 0)
        <div class="col-12 row-detail"><h5 class="fw-bold mt-4">Equipment Details</h5></div>
        <div class="col-md-6 row-detail">
            <div class="text-uppercase">Equipment</div>
            @foreach($booking->rentals as $rental)
                <b id="book_equipments">{{ $rental->name }}</b>
            @endforeach
        </div>
        <div class="col-md-6 row-detail">
            <div class="text-uppercase">Serial Number</div>
            @foreach($booking->rentals as $rental)
                <b>{{ $rental->serial_number }}</b>
            @endforeach
        </div>
        @endif
        @if($booking->resources->count() > 0)
        <div class="col-12 row-detail"><h5 class="fw-bold mt-4">Resource Details</h5></div>
        <div class="col-md-6 row-detail">
            <div class="text-uppercase">Resource</div>
            @foreach($booking->resources as $resource)
                <b id="book_equipments">{{ ucfirst($resource->fname) }} {{ ucfirst($resource->lname) }}</b>
            @endforeach
        </div>
        <div class="col-md-6 row-detail">
            <div class="text-uppercase">Role</div>
            @foreach($booking->resources as $resource)
                <b>{{ $resource->name }}</b>
            @endforeach
        </div>
        @endif
        <div class="col-12 row-detail"><h5 class="fw-bold mt-4">Client Details</h5></div>

        <div class="col-md-6 row-detail">
            <div class="text-uppercase">Name</div>
            <b id="book_client_name">{{ucfirst($booking->booking_by->fname)}} {{ucfirst($booking->booking_by->lname)}}</b>
        </div>
        <div class="col-3 row-detail">
            <div class="text-uppercase">Phone</div>
            <b id="book_client_phone">{{$booking->booking_by->mobile_number}}</b>
        </div>
        <div class="col-3 row-detail">
            <div class="text-uppercase">Email</div>
            <b id="book_client_email">{{$booking->booking_by->email}}</b>
        </div>
        
        <div class="col-12 row-detail"><h5 class="fw-bold mt-4">Notes</h5></div>
        <div class="col-md-12 row-detail">
            <div class="text-uppercase">Notes</div>
            <div class="">{!! $booking->notes !!}</div>
            <textarea class="form-control" id="book_notes" rows="3"></textarea>
        </div>
        
        <div class="col-md-12 row-detail">
            <div class="pt-3 h-100 d-flex flex-column justify-content-center align-items-center">
                <div class="row w-100 justify-content-center">
                    <div class="col-6 text-end">
                        <b>Booking Cost</b>
                    </div>
                    <div class="col-6 text-start">
                        <b id="book_points">{{$booking->total_points}}</b> <b>pts</b>
                    </div>
                </div>
                <div class="text-center mt-4 w-100">
                    <button type="button" id="btn_saveNotes" class="btn btn-primary" data-booking="{{$booking->booking_id}}">Save Notes</button>
                    @if($booking->status == 2)
                        <span class="text-danger fw-bold">Cancelled</span>
                    @elseif($booking->status == 1)
                        <span class="text-success fw-bold">Completed</span>
                    @elseif($endDateTime > \Carbon\Carbon::now())
                        <button type="button" class="btn btn-dark cancel-booking ms-2" data-booking="{{$booking->booking_id}}">Cancel booking</button>
                        <button type="button" class="btn btn-primary ms-2 mark-complete" data-booking="{{$booking->booking_id}}">Make as completed</button>
                    @else
                        <span class="text-warning fw-bold">Booking is not marked as complete</span>
                    @endif
                </div>
            </div>
        </div>
    </div>

</div>
@endsection
@section('footer_scripts')
<script>
$(document).ready(function(){
    $(document).on('click', '#btn_saveNotes', function(){
      let obj = $(this);
      obj.attr('disabled',true);
      let booking_id = $(this).data('booking');
      let notes = $('#book_notes').val();
      $.ajax({
          type: 'POST',
          dataType: 'json',
          data: {_token:_token, booking_id: booking_id, notes: notes},
          url: APP_URL+"/save-booking-notes",
          success: function(res) {
            window.location.href = APP_URL+"/booking-detail/"+booking_id;
          },
          error: function(res) {
            obj.attr('disabled',false);  
            ajax_error(res);
          }
      });
    });
});
</script>
@endsection