@extends('layouts.main')
@section('title', 'Bookings')
@section('content')
<div class="banner">
    <div class="img-text img-margin">{{__('Create something with us!')}}</div>
    <img class="img-fluid w-100" src="{{asset('images/booking-banner.png')}}">
</div>

<section class="visible">
    <div class="container text-dark" data-aos="fade-up">
        <h2 class="mt-4">{{__('Bookings')}}</h2>
        @if($bookings->count() > 0)
        <div class="row">
          <div class="col-md-12">
            @foreach($bookings as $book)
            <div class="row">
              <div class="card boxshadow">
                <div class="card-body pt-3">
                  <div class="row">
                    <div class="col-md-4 mb-2 position-relative">
                      <div class="imgbox1">
                        <img class="imgfluidlogged" src="{{url('storage/location/'.$book->locLanding->banner_picture)}}" height="200">
                      </div>
                    </div>
                    <div class="col-md-8 mb-2 position-relative">
                      <label>Date</label>
                      <div class="cleaefix"></div>
                      <div class="fw-bold">
                      {{date('d M, Y', strtotime($book->start_date))}} {{date('g:i A',strtotime($book->start_time))}} - {{date('d M, Y', strtotime($book->end_date))}} {{date('g:i A',strtotime($book->end_time))}}
                      </div>
                      <div class="cleaefix"></div>
                      <table class="table table-borderless">
                        <thead>
                          <tr>
                            <td>Location</td>
                            <td>Studio</td>
                            <td>Equipment</td>
                            <td>Resource</td> 
                          </tr>
                        </thead>
                        <tbody>
                          <tr>
                            <th>{{$book->loc->location}}</th>
                            <th>@if($book->studioNum) Y @endif</th>
                            <th>@if($book->equipNum) Y @endif</th>
                            <th>@if($book->resourceNum) Y @endif</th>
                          </tr>
                          <tr>
                            <th colspan="3">
                              <label class="fw-bold">{{$book->total_points}} pts</label>
                            </th>
                            <th>
                              <a href="{{url('booking-confirmed/'.$book->booking_id)}}" style="color:#000000;">See All
                                <svg class="_252" width="24" height="25" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg">
                                  <path fill-rule="evenodd" clip-rule="evenodd" d="M17.5712 9.24819L6.55037 20.269L5.13616 18.8548L16.157 7.83397L7.25748 7.83397L7.25748 5.83397L19.5712 5.83397L19.5712 18.1477L17.5712 18.1477L17.5712 9.24819Z" fill="#111111"></path>
                                </svg>
                              </a>
                            </th>
                          </tr>            
                        </tbody>
                      </table>
                    </div>
                  </div>        
                </div>
              </div>
            </div>
            @endforeach
            <div class="row col-md-12 mt-5">
                <div class="foot-paging">
                {!! $bookings->withQueryString()->links('vendor.pagination.bootstrap-5') !!}
                </div>
            </div>
          </div>
        </div>
        @else
        <p>No Bookings found.</p>
        @endif
    </div>
</section>
@endsection

@section('footer_scripts')
<script>
    $(document).ready(function () {
        
    });
</script>
@endsection
